/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.component;

import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.ILanguageVisitor;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.ISQLStringVisitorCallback;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.ISubqueryContainer;
import org.teiid.designer.query.sql.proc.IExpressionStatement;
import org.teiid.designer.query.sql.symbol.IAggregateSymbol;
import org.teiid.designer.query.sql.symbol.IExpressionSymbol;
import org.teiid.query.ui.sqleditor.component.DisplayNode;
import org.teiid.query.ui.sqleditor.component.DisplayNodeFactory;
import org.teiid.query.ui.sqleditor.component.DisplayNodeUtils;
import org.teiid.query.ui.sqleditor.component.HavingDisplayNode;
import org.teiid.query.ui.sqleditor.component.WhereDisplayNode;

public final class DisplayNodeVisitor
implements ISQLStringVisitorCallback {
    private final DisplayNode node;
    private final boolean dontAppend;
    private int indentLevel;
    private int originalLevel;

    DisplayNodeVisitor(DisplayNode node, boolean dontAppend, int indentLevel) {
        this.node = node;
        this.dontAppend = dontAppend;
        this.indentLevel = indentLevel;
        this.originalLevel = indentLevel;
    }

    public void visitNode(ILanguageObject obj) {
        if (obj == null) {
            this.append("<undefined>");
            return;
        }
        if (obj instanceof IExpressionSymbol && !(obj instanceof IAggregateSymbol)) {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            ISQLStringVisitor delegate = queryService.getCallbackSQLStringVisitor((ISQLStringVisitorCallback)this);
            obj.acceptVisitor((ILanguageVisitor)delegate);
            return;
        }
        int childIndent = this.indentLevel;
        if ((this.node.languageObject instanceof ISubqueryContainer || this.node.languageObject instanceof IExpressionStatement) && obj instanceof ICommand) {
            childIndent = -1;
        }
        Object child = DisplayNodeFactory.createDisplayNode(this.node, obj, childIndent);
        this.node.addChildNode((DisplayNode)child);
    }

    public void addTabs(int level) {
        this.setIndentLevel(this.originalLevel + level);
        if (this.indentLevel > 0) {
            this.node.displayNodeList.addAll(DisplayNodeUtils.getIndentNodes(this.node, this.indentLevel));
        }
    }

    public void visitCriteria(String keyWord, ICriteria crit) {
        if ("WHERE".equals(keyWord)) {
            WhereDisplayNode child = new WhereDisplayNode(this.node, crit);
            this.createCriteriaNode(keyWord, crit, child);
        } else if ("HAVING".equals(keyWord)) {
            HavingDisplayNode child = new HavingDisplayNode(this.node, crit);
            this.createCriteriaNode(keyWord, crit, child);
        } else {
            this.append(keyWord);
            this.append(" ");
            this.visitNode((ILanguageObject)crit);
        }
    }

    private void createCriteriaNode(String keyWord, ICriteria crit, DisplayNode child) {
        this.node.addChildNode(child);
        child.displayNodeList.add((DisplayNode)DisplayNodeFactory.createDisplayNode(child, keyWord));
        this.setIndentLevel(this.indentLevel + 1);
        this.beginClause(child, this.indentLevel);
        child.addChildNode((DisplayNode)DisplayNodeFactory.createDisplayNode(child, crit, this.indentLevel));
    }

    public void append(Object value) {
        if (this.dontAppend) {
            return;
        }
        this.node.displayNodeList.add((DisplayNode)DisplayNodeFactory.constructDisplayNode(this.node, value));
    }

    public void beginClause(int level) {
        this.setIndentLevel(this.originalLevel + level);
        this.beginClause(this.node, this.indentLevel);
    }

    private void beginClause(DisplayNode node, int level) {
        if (level >= 0 && DisplayNodeUtils.isClauseCROn()) {
            node.displayNodeList.add((DisplayNode)DisplayNodeFactory.createDisplayNode(node, "\n"));
            if (DisplayNodeUtils.isClauseIndentOn()) {
                node.displayNodeList.addAll(DisplayNodeUtils.getIndentNodes(node, level));
            }
        } else {
            node.displayNodeList.add((DisplayNode)DisplayNodeFactory.createDisplayNode(node, " "));
        }
    }

    private void setIndentLevel(int indentLevel) {
        if (this.indentLevel != -1) {
            this.indentLevel = indentLevel;
        }
    }
}

