/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.IGroupCollectorVisitor;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;
import org.teiid.query.ui.sqleditor.component.DisplayNode;
import org.teiid.query.ui.sqleditor.component.SetQueryDisplayNode;
import org.teiid.query.ui.sqleditor.component.SqlIndexLocator;

public class GroupSymbolFinder {
    SqlIndexLocator locator;
    Collection externalGroups;

    public GroupSymbolFinder(SqlIndexLocator locator, Collection exGroups) {
        this.locator = locator;
        this.externalGroups = exGroups.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(exGroups);
    }

    private IGroupCollectorVisitor getGroupVisitor() {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        return queryService.getGroupCollectorVisitor(true);
    }

    public List find() {
        HashSet groups = new HashSet();
        if (this.locator.getCommandDisplayNode() != null) {
            if (this.locator.isCriteriaQuerySelected()) {
                if (!this.externalGroups.isEmpty()) {
                    groups.addAll(this.externalGroups);
                }
                groups.addAll(this.getGroupsForCriteria());
            } else {
                if (this.locator.isSubQuerySelected()) {
                    return this.getGroupsForSubQuery();
                }
                if (this.locator.isUnionSegmentSelected()) {
                    if (!this.externalGroups.isEmpty()) {
                        groups.addAll(this.externalGroups);
                    }
                    groups.addAll(this.getGroupsForUnionSegment());
                } else {
                    return this.getGroups();
                }
            }
        }
        return new ArrayList(groups);
    }

    private List getGroupsForCriteria() {
        IGroupCollectorVisitor groupVisitor = this.getGroupVisitor();
        HashSet groups = new HashSet();
        if (this.locator.isSelectScopeSelected() || this.locator.isWhereSelected()) {
            groups.addAll(groupVisitor.findGroups(this.locator.getPrimaryLanguageObject()));
            List groupsInScope = this.locator.collectCriteriaParentQueries(this.locator.isSelectScopeSelected());
            DisplayNode dNode2 = null;
            for (DisplayNode dNode2 : groupsInScope) {
                groups.addAll(groupVisitor.findGroups(dNode2.getLanguageObject()));
            }
        }
        return new ArrayList(groups);
    }

    private List getGroupsForSubQuery() {
        IGroupCollectorVisitor groupVisitor = this.getGroupVisitor();
        HashSet allGroups = new HashSet();
        allGroups.addAll(groupVisitor.findGroups(this.locator.getPrimaryLanguageObject()));
        if (!this.locator.isUnionSegmentSelected()) {
            DisplayNode selectedSelectQueryNode;
            DisplayNode parentNode = this.locator.getCommandDisplayNode().getParent();
            while (parentNode != null) {
                ILanguageObject parentLangObj = parentNode.getLanguageObject();
                if ((parentNode = parentNode.getParent()) instanceof SetQueryDisplayNode) {
                    parentNode = null;
                }
                if (parentNode == null || !(parentLangObj instanceof ICommand)) continue;
                allGroups.addAll(groupVisitor.findGroups(parentLangObj));
            }
            if (this.locator.isSelectScopeSelected() && (selectedSelectQueryNode = this.locator.getSelectedSelectQuery()) != null) {
                allGroups.addAll(groupVisitor.findGroups(selectedSelectQueryNode.getLanguageObject()));
            }
            if (this.locator.isCriteriaQuerySelected()) {
                allGroups.addAll(this.getGroupsForCriteria());
            }
            if (!this.externalGroups.isEmpty()) {
                allGroups.addAll(this.externalGroups);
            }
        }
        return new ArrayList(allGroups);
    }

    private List getGroupsForUnionSegment() {
        HashSet allGroups = new HashSet();
        allGroups.addAll(this.getGroupVisitor().findGroups(this.locator.getPrimaryLanguageObject()));
        return new ArrayList(allGroups);
    }

    private List getGroups() {
        HashSet allGroups = new HashSet();
        ILanguageObject langObj = this.locator.getPrimaryLanguageObject();
        if (langObj != null && langObj instanceof ICommand) {
            Collection groups = this.getGroupVisitor().findGroupsIgnoreInlineViews(langObj);
            ArrayList<ILanguageObject> clonedGrps = new ArrayList<ILanguageObject>(groups.size());
            for (IGroupSymbol gSymbol : groups) {
                clonedGrps.add(gSymbol.clone());
            }
            allGroups.addAll(this.externalGroups);
            allGroups.addAll(clonedGrps);
        }
        return new ArrayList(allGroups);
    }
}

