/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.component;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.Block;
import org.teiid.designer.core.query.QueryValidationResult;
import org.teiid.designer.core.query.QueryValidator;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.IFrom;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IQuery;
import org.teiid.designer.query.sql.lang.ISelect;
import org.teiid.designer.query.sql.lang.IUnaryFromClause;
import org.teiid.designer.query.sql.lang.util.CommandHelper;
import org.teiid.designer.query.sql.symbol.IMultipleElementSymbol;
import org.teiid.designer.query.sql.symbol.ISymbol;
import org.teiid.query.ui.UiConstants;
import org.teiid.query.ui.sqleditor.component.DisplayNode;
import org.teiid.query.ui.sqleditor.component.DisplayNodeConstants;
import org.teiid.query.ui.sqleditor.component.DisplayNodeFactory;
import org.teiid.query.ui.sqleditor.component.DisplayNodeUtils;
import org.teiid.query.ui.sqleditor.component.FromDisplayNode;
import org.teiid.query.ui.sqleditor.component.QueryDisplayNode;
import org.teiid.query.ui.sqleditor.component.SelectDisplayNode;
import org.teiid.query.ui.sqleditor.component.SetQueryDisplayNode;
import org.teiid.query.ui.sqleditor.component.WhereDisplayNode;

public class QueryDisplayComponent
implements DisplayNodeConstants,
UiConstants {
    private static final String DEFAULT_QUERY = Util.getString("QueryDisplayComponent.defaultSqlText", new Object[0]);
    private static final String QUERY_NOT_PARSABLE_MSG = Util.getString("QueryDisplayComponent.queryNotParsableMsg", new Object[0]);
    private static final String QUERY_PARSABLE_NOT_RESOLVABLE_MSG = Util.getString("QueryDisplayComponent.queryParsableNotResolvableMsg", new Object[0]);
    private static final String QUERY_NOT_VALID_MSG = Util.getString("QueryDisplayComponent.queryNotValidMsg", new Object[0]);
    private static final String RESOLVER_ERROR_MSG = Util.getString("QueryDisplayComponent.resolverErrorMsg", new Object[0]);
    private static final String EMPTY_SQL_MSG = Util.getString("QueryDisplayComponent.emptySqlMsg", new Object[0]);
    private static final String DEFAULT_SQL_MSG = Util.getString("QueryDisplayComponent.defaultSqlMsg", new Object[0]);
    private static final String MONITOR_CHECKING_DISPLAY_NODES = Util.getString("QueryDisplayComponent.checkingDisplayNodes", new Object[0]);
    private static final String MONITOR_VALIDATING_SQL = Util.getString("QueryDisplayComponent.validatingSQL", new Object[0]);
    private static final String MONITOR_PREPARING_RESULTS = Util.getString("QueryDisplayComponent.preparingResults", new Object[0]);
    private QueryValidator queryValidator = null;
    private int queryType = 0;
    private QueryValidationResult validationResult;
    private boolean isParsable = false;
    private boolean isResolvable = false;
    private boolean isValidatable = false;
    private String statusMessage = null;
    private int errorStart = -1;
    private int errorEnd = -1;
    private DisplayNode sqlDisplayNode = null;
    private ICommand command = null;
    private boolean optimizerOn = false;
    private QueryValidator.ElementSymbolOptimization optimized = QueryValidator.ElementSymbolOptimization.UNMODIFIED;
    private PropertyChangeSupport propChgSupport = new PropertyChangeSupport(this);
    private String sqlText = null;

    public QueryDisplayComponent(QueryValidator queryValidator, int type) {
        this.queryValidator = queryValidator;
        this.queryType = type;
    }

    public void addPropertyListener(PropertyChangeListener listener) {
        this.propChgSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyListener(PropertyChangeListener listener) {
        this.propChgSupport.removePropertyChangeListener(listener);
    }

    public void setQueryValidator(QueryValidator validator) {
        this.queryValidator = validator;
        this.validationResult = null;
    }

    private void setText(String sqlString) {
        this.setText(sqlString, true, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public void setText(String sqlString, boolean doResolveAndValidate, QueryValidationResult theResult) {
        this.setText(sqlString, doResolveAndValidate, theResult, (IProgressMonitor)new NullProgressMonitor());
    }

    public void setText(String sqlString, boolean doResolveAndValidate, QueryValidationResult theResult, IProgressMonitor monitor) {
        boolean setSqlText = false;
        if (this.isEmptySql(this.sqlText) || !this.sqlText.equals(sqlString)) {
            setSqlText = true;
        }
        if (setSqlText) {
            this.sqlText = sqlString;
            this.validateSql(sqlString, doResolveAndValidate, theResult, monitor);
        }
    }

    public boolean isDeoptimized() {
        return this.optimized == QueryValidator.ElementSymbolOptimization.DEOPTIMIZED;
    }

    public void reset() {
        this.sqlDisplayNode = null;
        this.sqlText = null;
    }

    private void validateSql(String inputSqlString, boolean doResolveAndValidate, QueryValidationResult theResult) {
        this.validateSql(inputSqlString, doResolveAndValidate, theResult, (IProgressMonitor)new NullProgressMonitor());
    }

    private void validateSql(String inputSqlString, boolean doResolveAndValidate, QueryValidationResult theResult, IProgressMonitor monitor) {
        StringBuffer buff;
        String sqlString = inputSqlString;
        if (sqlString == null || this.isEmptySql(sqlString)) {
            sqlString = "";
        }
        if (this.queryValidator == null || !this.queryValidator.isValidRoot()) {
            this.sqlDisplayNode = DisplayNodeFactory.createUnknownQueryDisplayNode(null, "");
            return;
        }
        if (!this.queryValidator.shouldValidate()) {
            return;
        }
        monitor.subTask(MONITOR_CHECKING_DISPLAY_NODES);
        monitor.worked(5);
        if (!sqlString.trim().toUpperCase().startsWith("CREATE") && this.sqlDisplayNode != null) {
            StringBuffer text = new StringBuffer();
            boolean replaced = false;
            for (DisplayNode node : this.sqlDisplayNode.getDisplayNodeList()) {
                if (node.isVisible()) {
                    if (replaced) continue;
                    text.append(sqlString);
                    replaced = true;
                    continue;
                }
                if (!replaced && node.getParent().languageObject instanceof Block && "END".equals(node.toString())) {
                    text.append(sqlString);
                }
                text.append(node.toString());
            }
            sqlString = text.toString();
        }
        ArrayList statusList = Collections.EMPTY_LIST;
        monitor.subTask(MONITOR_VALIDATING_SQL);
        monitor.worked(5);
        if (!doResolveAndValidate && theResult != null) {
            this.validationResult = theResult;
        } else {
            try {
                QueryValidator.ElementSymbolOptimization status = QueryValidator.ElementSymbolOptimization.UNMODIFIED;
                status = this.optimizerOn ? QueryValidator.ElementSymbolOptimization.OPTIMIZED : QueryValidator.ElementSymbolOptimization.DEOPTIMIZED;
                this.queryValidator.setElementSymbolOptimization(status);
                this.validationResult = this.queryValidator.validateSql(sqlString, this.queryType, false);
                this.optimized = status;
            }
            catch (Exception ex) {
                this.sqlDisplayNode = DisplayNodeFactory.createUnknownQueryDisplayNode(null, sqlString);
                buff = new StringBuffer("Error encountered while validating the transformation.");
                buff.append("\nPlease check the Message log for exceptions");
                this.statusMessage = buff.toString();
                UiConstants.Util.log(4, (Throwable)ex, this.statusMessage);
                this.setCommand(null);
                return;
            }
        }
        monitor.subTask(MONITOR_PREPARING_RESULTS);
        monitor.worked(20);
        this.isParsable = this.validationResult.isParsable();
        this.isResolvable = this.validationResult.isResolvable();
        this.isValidatable = this.validationResult.isValidatable();
        statusList = this.validationResult.getStatusList();
        Collection moreStatus = Collections.EMPTY_LIST;
        if (this.queryType == 1) {
            moreStatus = this.validationResult.getUpdateStatusList(1);
        } else if (this.queryType == 2) {
            moreStatus = this.validationResult.getUpdateStatusList(2);
        } else if (this.queryType == 3) {
            moreStatus = this.validationResult.getUpdateStatusList(3);
        }
        if (moreStatus != null && !moreStatus.isEmpty()) {
            statusList = new ArrayList(statusList);
            statusList.addAll(moreStatus);
        }
        this.setCommand(this.validationResult.getCommand());
        if (!doResolveAndValidate && this.runOptimizeDeoptimize()) {
            return;
        }
        if (!this.isParsable) {
            this.setCommand(null);
            this.sqlDisplayNode = DisplayNodeFactory.createUnknownQueryDisplayNode(null, sqlString);
            if (this.isEmptySql(sqlString)) {
                this.statusMessage = EMPTY_SQL_MSG;
            } else if (this.isDefaultSql(sqlString)) {
                this.statusMessage = DEFAULT_SQL_MSG;
            } else {
                buff = new StringBuffer(QUERY_NOT_PARSABLE_MSG);
                if (statusList != null && !statusList.isEmpty()) {
                    for (IStatus status : statusList) {
                        buff.append("\n" + status.getMessage());
                    }
                }
                this.statusMessage = buff.toString();
            }
        } else {
            this.sqlDisplayNode = DisplayNodeFactory.createDisplayNode(null, this.getCommand());
            this.sqlText = this.sqlDisplayNode.toDisplayString();
            if (!this.isResolvable) {
                buff = new StringBuffer(QUERY_PARSABLE_NOT_RESOLVABLE_MSG);
                if (statusList != null && !statusList.isEmpty()) {
                    for (IStatus status : statusList) {
                        buff.append("\n" + RESOLVER_ERROR_MSG + ":" + " " + status.getMessage());
                    }
                }
                this.statusMessage = buff.toString();
            } else if (!this.isValidatable) {
                buff = new StringBuffer(QUERY_NOT_VALID_MSG);
                if (statusList != null && !statusList.isEmpty()) {
                    for (IStatus status : statusList) {
                        buff.append("\n" + status.getMessage());
                    }
                }
                this.statusMessage = buff.toString();
            } else {
                this.statusMessage = "";
            }
        }
        this.sqlDisplayNode.setStartIndex(0);
        this.propChgSupport.firePropertyChange(null, null, null);
    }

    public void setOptimizerOn(boolean status) {
        this.optimizerOn = status;
        this.runOptimizeDeoptimize();
    }

    private boolean runOptimizeDeoptimize() {
        if (!this.canOptimize()) {
            return false;
        }
        if (this.isOptimizerOn()) {
            if (this.optimized != QueryValidator.ElementSymbolOptimization.OPTIMIZED) {
                this.validateSql(this.getCommand().toString(), true, null);
                return true;
            }
        } else if (this.optimized != QueryValidator.ElementSymbolOptimization.DEOPTIMIZED) {
            String optimizedSql = this.getCommand().toString();
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            queryService.fullyQualifyElements(this.getCommand());
            this.optimized = QueryValidator.ElementSymbolOptimization.DEOPTIMIZED;
            if (optimizedSql != null && !optimizedSql.equalsIgnoreCase(this.getCommand().toString())) {
                this.validateSql(this.getCommand().toString(), true, null);
                return true;
            }
        }
        return false;
    }

    public boolean isOptimizerOn() {
        return this.optimizerOn;
    }

    public boolean canOptimize() {
        return this.isResolvable();
    }

    public DisplayNode getDisplayNode() {
        return this.sqlDisplayNode;
    }

    public List getDisplayNodeList() {
        if (this.sqlDisplayNode != null) {
            return this.sqlDisplayNode.getDisplayNodeList();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isParsable() {
        return this.isParsable;
    }

    public boolean isResolvable() {
        return this.isResolvable;
    }

    public boolean isValidatable() {
        return this.isValidatable;
    }

    public boolean isDefaultQuery() {
        return this.isDefaultSql(this.toDisplayString());
    }

    private boolean isDefaultSql(String sqlString) {
        StringBuffer sb = new StringBuffer(sqlString);
        CoreStringUtil.replaceAll((StringBuffer)sb, (String)"\n", (String)"");
        CoreStringUtil.replaceAll((StringBuffer)sb, (String)"\t", (String)" ");
        CoreStringUtil.replaceAll((StringBuffer)sb, (String)"  ", (String)" ");
        String newString = sb.toString();
        return newString != null && DEFAULT_QUERY != null && newString.trim().equalsIgnoreCase(DEFAULT_QUERY.trim());
    }

    public boolean isEmptyQuery() {
        return this.isEmptySql(this.sqlText);
    }

    private boolean isEmptySql(String sqlString) {
        return sqlString == null || sqlString.trim().length() == 0;
    }

    public int getProjectedSymbolCount() {
        if (this.getCommand() != null) {
            List symbols = CommandHelper.getProjectedSymbols((ICommand)this.getCommand());
            return symbols.size();
        }
        return 0;
    }

    public boolean isSelectStar() {
        ISelect select;
        boolean isSelectStar = false;
        if (this.isParsable && this.getCommand() != null && this.getCommand() instanceof IQuery && (select = ((IQuery)this.getCommand()).getSelect()) != null) {
            isSelectStar = select.isStar();
        }
        return isSelectStar;
    }

    public void expandSelect() {
        ICommand theCommand = this.getCommand();
        if (this.isSelectStar() && theCommand instanceof IQuery) {
            IQuery query = (IQuery)theCommand;
            boolean expandSelect = false;
            List syms = query.getSelect().getSymbols();
            int i = 0;
            while (i < syms.size()) {
                if (syms.get(i) instanceof IMultipleElementSymbol) {
                    expandSelect = true;
                    break;
                }
                ++i;
            }
            if (expandSelect) {
                List symbols = CommandHelper.getProjectedSymbols((ICommand)query);
                StringBuffer selectStr = new StringBuffer("SELECT ");
                int i2 = 0;
                while (i2 < symbols.size()) {
                    if (i2 != 0) {
                        selectStr.append(", ");
                    }
                    String symbolName = ((IExpression)symbols.get(i2)).toString();
                    selectStr.append(symbolName);
                    ++i2;
                }
                if (symbols.size() > 0) {
                    selectStr.append(" \n");
                }
                this.replaceSelect(selectStr.toString());
            }
        }
    }

    public boolean canExpandSelect(int index) {
        DisplayNode commandNode = this.getCommandDisplayNodeAtIndex(index);
        if (this.isParsable && commandNode instanceof QueryDisplayNode) {
            return this.canExpand((IQuery)commandNode.getLanguageObject());
        }
        return false;
    }

    public void expandSelect(int index) {
        if (!this.canExpandSelect(index)) {
            return;
        }
        DisplayNode commandDisplayNode = this.getCommandDisplayNodeAtIndex(index);
        if (commandDisplayNode != null && commandDisplayNode instanceof QueryDisplayNode) {
            QueryDisplayNode queryDisplayNode = (QueryDisplayNode)commandDisplayNode;
            SelectDisplayNode selectDisplayNode = (SelectDisplayNode)queryDisplayNode.getClauseDisplayNode(6);
            IQuery query = (IQuery)queryDisplayNode.getLanguageObject();
            List symbols = CommandHelper.getProjectedSymbols((ICommand)query);
            StringBuffer selectStr = new StringBuffer(" ");
            int i = 0;
            while (i < symbols.size()) {
                if (i != 0) {
                    selectStr.append(", ");
                }
                String symbolName = ((IExpression)symbols.get(i)).toString();
                selectStr.append(symbolName);
                ++i;
            }
            if (symbols.size() > 0) {
                selectStr.append(" \n");
            }
            int startIndex = selectDisplayNode.getStartIndex();
            int endIndex = selectDisplayNode.getEndIndex();
            this.replace(startIndex, endIndex + 1, selectStr.toString());
        }
    }

    public ICommand getCommand() {
        return this.command;
    }

    private void setCommand(ICommand theCommand) {
        this.command = theCommand;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public int getErrorStart() {
        return this.errorStart;
    }

    public int getErrorEnd() {
        return this.errorEnd;
    }

    public DisplayNode getQueryClauseAtIndex(int index) {
        DisplayNode node = this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode ? ((QueryDisplayNode)this.sqlDisplayNode).getClauseAtIndex(index) : (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof SetQueryDisplayNode ? ((SetQueryDisplayNode)this.sqlDisplayNode).getClauseAtIndex(index) : null);
        if (node == null) {
            UiConstants.Util.log(4, null, "DisplayNode: " + this.sqlDisplayNode.getClass() + "generated null result at index " + index);
        }
        return node;
    }

    public DisplayNode getCommandDisplayNodeAtIndex(int index) {
        QueryDisplayNode child;
        DisplayNode result = this.getCommandDisplayNodeAtIndexIncludingSetQueries(index);
        if (result instanceof SetQueryDisplayNode && (child = ((SetQueryDisplayNode)result).getQueryAtIndex(index)) != null) {
            result = child;
        }
        return result;
    }

    private DisplayNode getCommandDisplayNodeAtIndexIncludingSetQueries(int index) {
        DisplayNode commandDisplayNode = null;
        List nodes = this.getDisplayNodesAtIndex(index);
        if (nodes.size() == 2) {
            DisplayNode node1 = (DisplayNode)nodes.get(0);
            DisplayNode node2 = (DisplayNode)nodes.get(1);
            commandDisplayNode = DisplayNodeUtils.getCommandForNode(node2);
            if (commandDisplayNode == null) {
                commandDisplayNode = DisplayNodeUtils.getCommandForNode(node1);
            }
        } else if (nodes.size() == 1) {
            commandDisplayNode = DisplayNodeUtils.getCommandForNode((DisplayNode)nodes.get(0));
        }
        return commandDisplayNode;
    }

    public int getQueryIndex(int index) {
        QueryDisplayNode queryDisplayNode = null;
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode) {
            queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
            if (queryDisplayNode.isAnywhereWithin(index)) {
                return 0;
            }
        } else if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof SetQueryDisplayNode) {
            SetQueryDisplayNode setQueryDisplayNode = (SetQueryDisplayNode)this.sqlDisplayNode;
            return setQueryDisplayNode.getQueryIndex(index);
        }
        return -1;
    }

    public QueryDisplayNode getQueryDisplayNode(int queryIndex) {
        QueryDisplayNode queryDisplayNode = null;
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode && queryIndex == 0) {
            queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
        } else if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof SetQueryDisplayNode) {
            SetQueryDisplayNode setQueryDisplayNode = (SetQueryDisplayNode)this.sqlDisplayNode;
            queryDisplayNode = setQueryDisplayNode.getQueryDisplayNode(queryIndex);
        }
        return queryDisplayNode;
    }

    public List getDisplayNodesAtIndex(int index) {
        List allNodes = this.getDisplayNodeList();
        return DisplayNodeUtils.getDisplayNodesAtIndex(allNodes, index);
    }

    public SelectDisplayNode getSelectDisplayNode() {
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode) {
            QueryDisplayNode queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
            return (SelectDisplayNode)queryDisplayNode.getClauseDisplayNode(6);
        }
        return null;
    }

    public SelectDisplayNode getSelectDisplayNode(int queryIndex) {
        QueryDisplayNode queryDisplayNode = this.getQueryDisplayNode(queryIndex);
        if (queryDisplayNode != null) {
            return (SelectDisplayNode)queryDisplayNode.getClauseDisplayNode(6);
        }
        return null;
    }

    public FromDisplayNode getFromDisplayNode() {
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode) {
            QueryDisplayNode queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
            return (FromDisplayNode)queryDisplayNode.getClauseDisplayNode(8);
        }
        return null;
    }

    public FromDisplayNode getFromDisplayNode(int queryIndex) {
        QueryDisplayNode queryDisplayNode = this.getQueryDisplayNode(queryIndex);
        if (queryDisplayNode != null) {
            return (FromDisplayNode)queryDisplayNode.getClauseDisplayNode(8);
        }
        return null;
    }

    public WhereDisplayNode getWhereDisplayNode() {
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode) {
            QueryDisplayNode queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
            return (WhereDisplayNode)queryDisplayNode.getClauseDisplayNode(9);
        }
        return null;
    }

    public WhereDisplayNode getWhereDisplayNode(int queryIndex) {
        QueryDisplayNode queryDisplayNode = this.getQueryDisplayNode(queryIndex);
        if (queryDisplayNode != null) {
            return (WhereDisplayNode)queryDisplayNode.getClauseDisplayNode(9);
        }
        return null;
    }

    public List getSelectSymbolDisplayNodes() {
        SelectDisplayNode selectNode = this.getSelectDisplayNode();
        if (selectNode != null) {
            return selectNode.getChildren();
        }
        return Collections.EMPTY_LIST;
    }

    public List getSelectSymbolDisplayNodes(int queryIndex) {
        SelectDisplayNode selectNode = this.getSelectDisplayNode(queryIndex);
        if (selectNode != null) {
            return selectNode.getChildren();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isIndexWithin(int index, int type) {
        boolean result = false;
        if (this.isParsable()) {
            result = DisplayNodeUtils.isIndexWithin(this.getDisplayNodeList(), index, type);
        }
        return result;
    }

    public boolean isInsertAllowed(int index, int type) {
        boolean result = false;
        if (this.isParsable()) {
            result = DisplayNodeUtils.isInsertAllowed(this.getDisplayNodeList(), index, type);
        }
        return result;
    }

    public boolean isSupportedAtIndex(int itemType, int index) {
        if (this.isDefaultQuery()) {
            String currentQuery = this.toDisplayString().toUpperCase();
            int endIndexOfSelect = currentQuery.indexOf("SELECT") + "SELECT".length();
            int startIndexOfFrom = currentQuery.indexOf("FROM");
            int endIndexOfFrom = currentQuery.indexOf("FROM") + "FROM".length();
            if (itemType == 0 && index >= endIndexOfSelect && index <= startIndexOfFrom) {
                return true;
            }
            return itemType == 1 && index >= endIndexOfFrom;
        }
        if (!this.isParsable()) {
            return false;
        }
        DisplayNode node = this.getQueryClauseAtIndex(index);
        if (node != null) {
            switch (itemType) {
                case 0: {
                    return node.supportsElement();
                }
                case 1: {
                    return node.supportsGroup();
                }
                case 3: {
                    return node.supportsExpression();
                }
                case 2: {
                    return node.supportsCriteria();
                }
            }
        }
        return false;
    }

    public void insertGroup(String groupName, int index) {
        if (this.isDefaultQuery()) {
            this.setText(String.valueOf(DEFAULT_QUERY) + groupName);
            return;
        }
        if (!this.isSupportedAtIndex(1, index)) {
            return;
        }
        DisplayNode clauseNode = this.getQueryClauseAtIndex(index);
        if (clauseNode instanceof FromDisplayNode) {
            if (!this.containsGroup((FromDisplayNode)clauseNode, groupName)) {
                int nodeIndex = this.getDisplayNodeInsertIndex(index);
                this.insertSymbolNameAtNodeIndex(groupName, nodeIndex);
            }
        } else {
            int nodeIndex = this.getDisplayNodeInsertIndex(index);
            this.insertSymbolNameAtNodeIndex(groupName, nodeIndex);
        }
    }

    public void insertElement(String elementName, String parentName, int index) {
        if (this.isDefaultQuery()) {
            this.setText("SELECT " + elementName + " " + "FROM" + " " + parentName);
            return;
        }
        if (!this.isSupportedAtIndex(0, index)) {
            return;
        }
        boolean insertAtEndOfSelect = false;
        if (this.isSelectStar()) {
            int starIndex = 0;
            for (DisplayNode node : this.getSelectSymbolDisplayNodes()) {
                ILanguageObject langObj;
                if (!(node.getLanguageObject() instanceof ISymbol) || !((langObj = node.getLanguageObject()) instanceof IMultipleElementSymbol)) continue;
                starIndex = node.getStartIndex();
                break;
            }
            if (index > starIndex) {
                insertAtEndOfSelect = true;
            }
            this.expandSelect();
        }
        int nodeIndex = this.getDisplayNodeInsertIndex(index);
        this.insertGroupAtEndOfFrom(parentName);
        if (insertAtEndOfSelect) {
            index = this.getSelectDisplayNode().getEndIndex();
            nodeIndex = this.getDisplayNodeInsertIndex(index);
        }
        this.insertSymbolNameAtNodeIndex(elementName, nodeIndex);
    }

    public void insertElements(List elementNames, List parentNames, int index) {
        if (this.isDefaultQuery()) {
            StringBuffer elementSB = new StringBuffer();
            int nNames = elementNames.size();
            int i = 0;
            while (i < nNames) {
                if (i == 0) {
                    elementSB.append((String)elementNames.get(i));
                } else {
                    elementSB.append(", " + (String)elementNames.get(i));
                }
                ++i;
            }
            ArrayList<String> uniqueGroups = new ArrayList<String>();
            for (String grp : parentNames) {
                if (uniqueGroups.contains(grp)) continue;
                uniqueGroups.add(grp);
            }
            StringBuffer groupSB = new StringBuffer();
            int nGrps = uniqueGroups.size();
            int i2 = 0;
            while (i2 < nGrps) {
                if (i2 == 0) {
                    groupSB.append((String)uniqueGroups.get(i2));
                } else {
                    groupSB.append(", " + (String)uniqueGroups.get(i2));
                }
                ++i2;
            }
            this.setText("SELECT " + elementSB.toString() + " FROM " + groupSB.toString());
            return;
        }
        int nElems = elementNames.size();
        int nParents = parentNames.size();
        if (nParents != nElems || nElems == 0) {
            return;
        }
        int i = nElems - 1;
        while (i >= 0) {
            this.insertElement((String)elementNames.get(i), (String)parentNames.get(i), index);
            --i;
        }
    }

    public String toDisplayString() {
        if (this.sqlText != null) {
            return this.sqlText;
        }
        return "";
    }

    public String toString() {
        return this.toDisplayString();
    }

    private int getDisplayNodeInsertIndex(int cursorIndex) {
        List allNodes = this.getDisplayNodeList();
        int i = 0;
        while (i < allNodes.size()) {
            DisplayNode node = (DisplayNode)allNodes.get(i);
            if (node.isAnywhereWithin(cursorIndex)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private boolean canExpand(IQuery query) {
        boolean canExpand = false;
        if (query != null) {
            List symbols;
            ISelect select = query.getSelect();
            boolean hasMultiSymbol = false;
            if (select != null) {
                List syms = select.getSymbols();
                int i = 0;
                while (i < syms.size()) {
                    if (syms.get(i) instanceof IMultipleElementSymbol) {
                        hasMultiSymbol = true;
                        break;
                    }
                    ++i;
                }
            }
            if (hasMultiSymbol && (symbols = CommandHelper.getProjectedSymbols((ICommand)query)).size() > 0) {
                canExpand = true;
            }
        }
        return canExpand;
    }

    private void replace(int startIndex, int endIndex, String str) {
        StringBuffer sb = new StringBuffer(this.toDisplayString());
        sb.replace(startIndex, endIndex, str);
        this.setText(sb.toString());
    }

    private void replaceSelect(String selectStr) {
        if (this.sqlDisplayNode != null && this.sqlDisplayNode instanceof QueryDisplayNode) {
            StringBuffer sb = new StringBuffer("");
            QueryDisplayNode queryDisplayNode = (QueryDisplayNode)this.sqlDisplayNode;
            for (DisplayNode clauseNode : queryDisplayNode.getChildren()) {
                if (clauseNode.getLanguageObject() instanceof ISelect) {
                    sb.append(selectStr);
                    continue;
                }
                sb.append(clauseNode.toString());
            }
            this.setText(sb.toString());
        }
    }

    private void insertGroupAtEndOfFrom(String groupName) {
        FromDisplayNode fromNode = this.getFromDisplayNode();
        if (fromNode != null) {
            int fromEndIndex = fromNode.getEndIndex();
            this.insertGroup(groupName, fromEndIndex - 1);
        }
    }

    private boolean containsGroup(FromDisplayNode fromClause, String groupName) {
        if (fromClause != null) {
            IFrom from = (IFrom)fromClause.getLanguageObject();
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            IQueryFactory factory = queryService.createQueryFactory();
            return from.getGroups().contains(factory.createGroupSymbol(groupName));
        }
        return false;
    }

    private void insertSymbolName(String symbolName, int index) {
        DisplayNode clauseNode = this.getQueryClauseAtIndex(index);
        List displayNodes = this.getDisplayNodesAtIndex(index);
        int nNodes = displayNodes.size();
        DisplayNode displayNode = null;
        if (nNodes == 2) {
            displayNode = (DisplayNode)displayNodes.get(0);
            if (displayNode.getLanguageObject() instanceof ISymbol || displayNode.getLanguageObject() instanceof IUnaryFromClause) {
                displayNode = (DisplayNode)displayNodes.get(1);
            }
        } else if (nNodes == 1) {
            displayNode = (DisplayNode)displayNodes.get(0);
        } else {
            return;
        }
        if (clauseNode != null && !DisplayNodeUtils.hasSymbol(clauseNode) && !DisplayNodeUtils.hasExpression(clauseNode)) {
            this.insertString("," + symbolName + " ", displayNode.getEndIndex() + 1);
        } else if (displayNode.isInExpression()) {
            DisplayNode expressionNode = DisplayNodeUtils.getExpressionForNode(displayNode);
            int startIndex = expressionNode.getStartIndex();
            if (index == startIndex) {
                this.insertString(" " + symbolName + ",", expressionNode.getStartIndex());
            } else {
                this.insertString("," + symbolName + " ", expressionNode.getEndIndex() + 1);
            }
        } else if (displayNode.getLanguageObject() instanceof ISymbol || displayNode.getLanguageObject() instanceof IUnaryFromClause) {
            int startIndex = displayNode.getStartIndex();
            if (index == startIndex) {
                this.insertString(" " + symbolName + ",", displayNode.getStartIndex());
            } else {
                this.insertString("," + symbolName + " ", displayNode.getEndIndex() + 1);
            }
        } else if (clauseNode != null) {
            int startOfNextSymbol = DisplayNodeUtils.getStartIndexOfNextSymbol(clauseNode, index);
            int endOfPrevSymbol = DisplayNodeUtils.getEndIndexOfPreviousSymbol(clauseNode, index);
            int startOfNextExpr = DisplayNodeUtils.getStartIndexOfNextExpression(clauseNode, index);
            int endOfPrevExpr = DisplayNodeUtils.getEndIndexOfPreviousExpression(clauseNode, index);
            int startOfNext = this.getSmallestNonNegative(startOfNextSymbol, startOfNextExpr);
            int endOfPrev = this.getLargestNonNegative(endOfPrevSymbol, endOfPrevExpr);
            if (startOfNext != -1 && endOfPrev != -1) {
                this.insertString(" " + symbolName + ",", startOfNext);
            } else if (startOfNext != -1) {
                this.insertString(" " + symbolName + ",", startOfNext);
            } else if (endOfPrev != -1) {
                this.insertString("," + symbolName + " ", endOfPrev);
            }
        }
    }

    private int getSmallestNonNegative(int intOne, int intTwo) {
        if (intOne < 0 && intTwo < 0) {
            return -1;
        }
        int minimum = Math.min(intOne, intTwo);
        if (minimum < 0) {
            return Math.max(intOne, intTwo);
        }
        return minimum;
    }

    private int getLargestNonNegative(int intOne, int intTwo) {
        if (intOne < 0 && intTwo < 0) {
            return -1;
        }
        return Math.max(intOne, intTwo);
    }

    private void insertSymbolNameAtNodeIndex(String symbolName, int nodeIndex) {
        List allNodes = this.getDisplayNodeList();
        if (nodeIndex < 0 || nodeIndex > allNodes.size()) {
            return;
        }
        int index = 0;
        if (nodeIndex == allNodes.size()) {
            DisplayNode node = (DisplayNode)allNodes.get(nodeIndex - 1);
            index = node.getEndIndex() - 1;
        } else {
            DisplayNode node = (DisplayNode)allNodes.get(nodeIndex);
            index = node.getStartIndex();
        }
        this.insertSymbolName(symbolName, index);
    }

    private void insertString(String str, int index) {
        StringBuffer currentSQL = new StringBuffer(this.toDisplayString());
        currentSQL.insert(index, str);
        this.setText(currentSQL.toString());
    }

    public int getCorrectedIndex(int visibleCursorIndex) {
        int theIndex = visibleCursorIndex;
        if (this.sqlDisplayNode != null) {
            for (DisplayNode node : this.sqlDisplayNode.getDisplayNodeList()) {
                if (!node.isVisible()) continue;
                theIndex = visibleCursorIndex + node.getStartIndex();
                break;
            }
        }
        return theIndex;
    }

    public DisplayNode getFirstVisibleNode() {
        for (DisplayNode node : this.sqlDisplayNode.getDisplayNodeList()) {
            if (!node.isVisible()) continue;
            return node;
        }
        return null;
    }

    public EObject getMappingRoot() {
        if (this.queryValidator != null) {
            return this.queryValidator.getTransformationRoot();
        }
        return null;
    }

    public int getQueryType() {
        return this.queryType;
    }
}

