/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.sql;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.teiid.query.ui.UiConstants;
import org.teiid.query.ui.UiPlugin;
import org.teiid.query.ui.sqleditor.sql.SqlFormattingConstants;

public class SqlAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy
implements SqlFormattingConstants,
UiConstants {
    private String sLastKeywordFound = null;

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length > 0 && c.text.equals("")) {
            return;
        }
        if (c.text != null && this.endsWithClauseKeyword(d, c)) {
            this.smartInsertAfterKeyword(d, c);
        }
    }

    private boolean endsWithClauseKeyword(IDocument d, DocumentCommand c) {
        String sDocTextUpcased = d.get();
        int iLastCharIndex = sDocTextUpcased.length() - 1;
        if (sDocTextUpcased.length() > 0 && sDocTextUpcased.charAt(iLastCharIndex) == '\n') {
            sDocTextUpcased = sDocTextUpcased.trim();
        }
        boolean rv = c.text != null && this.isAllWhitespace(c.text) ? this.endsWithClauseKeyword(sDocTextUpcased) : false;
        return rv;
    }

    private boolean isAllWhitespace(String text) {
        int i = 0;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean endsWithClauseKeyword(String sDocTextUpcased) {
        sDocTextUpcased = sDocTextUpcased.toUpperCase();
        int i = 0;
        while (i < KEYWORDS.length) {
            if (sDocTextUpcased.endsWith(KEYWORDS[i])) {
                this.sLastKeywordFound = KEYWORDS[i];
                StringBuffer sb = new StringBuffer(sDocTextUpcased);
                int iIndex = sb.length() - this.sLastKeywordFound.length() - 1;
                if (iIndex > -1) {
                    char cPrecedingChar = sb.charAt(iIndex);
                    if (cPrecedingChar == ' ' || cPrecedingChar == '\n' || cPrecedingChar == '\t') {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected void smartInsertAfterKeyword(IDocument document, DocumentCommand command) {
        if (command.offset == -1 || document.getLength() == 0) {
            this.sLastKeywordFound = null;
            return;
        }
        try {
            int p = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            int start = document.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
            String sKeyword = this.getEndingKeyword(document, command);
            String sNewCommandText = "";
            int iBefore = p - (sKeyword.length() - 1);
            int chCharOneBeforeKeyword = 32;
            int chCharTwoBeforeKeyword = 32;
            if (iBefore > 0) {
                chCharOneBeforeKeyword = document.getChar(iBefore);
                chCharTwoBeforeKeyword = document.getChar(iBefore - 1);
            }
            if (whiteend > 0 && chCharOneBeforeKeyword != 10 && chCharTwoBeforeKeyword != 10 && this.startClausesOnNewLine()) {
                sNewCommandText = "\n";
            }
            sNewCommandText = String.valueOf(sNewCommandText) + sKeyword + "\n";
            if (this.startClausesOnNewLine() && this.indentClauseContent()) {
                sNewCommandText = String.valueOf(sNewCommandText) + "\t";
            }
            command.length = sNewCommandText.length();
            command.offset -= sKeyword.length();
            int iOverage = sNewCommandText.length() - sKeyword.length();
            command.text = sNewCommandText;
            command.doit = true;
            String sCurrentDocText = document.get();
            int iOrigLength = sCurrentDocText.length();
            StringBuffer replaceText = new StringBuffer(iOrigLength);
            replaceText.replace(0, iOrigLength, sCurrentDocText);
            int i = 0;
            while (i < iOverage) {
                replaceText.append(' ');
                ++i;
            }
            document.set(replaceText.toString());
        }
        catch (BadLocationException badLocationException) {}
        this.sLastKeywordFound = null;
    }

    private String getEndingKeyword(IDocument d, DocumentCommand command) {
        if (this.sLastKeywordFound != null) {
            return this.sLastKeywordFound;
        }
        String sDocTextUpcased = d.get();
        if (sDocTextUpcased.length() > 0 && sDocTextUpcased.charAt(sDocTextUpcased.length() - 1) == '\n') {
            sDocTextUpcased = sDocTextUpcased.trim();
        }
        sDocTextUpcased = String.valueOf(sDocTextUpcased) + command.text;
        sDocTextUpcased = sDocTextUpcased.toUpperCase();
        int i = 0;
        while (i < KEYWORDS.length) {
            if (sDocTextUpcased.endsWith(KEYWORDS[i])) {
                return KEYWORDS[i];
            }
            ++i;
        }
        return "";
    }

    private boolean startClausesOnNewLine() {
        return UiPlugin.getDefault().getPreferenceStore().getBoolean("startClausesOnNewLine");
    }

    private boolean indentClauseContent() {
        return UiPlugin.getDefault().getPreferenceStore().getBoolean("indentClauseContent");
    }
}

