/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.sql;

import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.query.ui.sqleditor.sql.CaseInsensitiveWordRule;
import org.teiid.query.ui.sqleditor.sql.SqlSyntax;
import org.teiid.query.ui.sqleditor.sql.SqlWhiteSpaceDetector;
import org.teiid.query.ui.sqleditor.sql.SqlWordDetector;

public class SqlCodeScanner
extends RuleBasedScanner {
    public SqlCodeScanner(ColorManager colorManager) {
        Token keyword = new Token((Object)new TextAttribute(colorManager.getColor(ColorManager.KEYWORD), null, 0));
        Token datatype = new Token((Object)new TextAttribute(colorManager.getColor(ColorManager.DATATYPE), null, 0));
        Token function = new Token((Object)new TextAttribute(colorManager.getColor(ColorManager.FUNCTION), null, 0));
        Token string = new Token((Object)new TextAttribute(colorManager.getColor(ColorManager.STRING), null, 0));
        Token comment = new Token((Object)new TextAttribute(colorManager.getColor(ColorManager.SINGLE_LINE_COMMENT), null, 0));
        Token other = new Token((Object)new TextAttribute(colorManager.getColor(ColorManager.DEFAULT), null, 0));
        this.setDefaultReturnToken((IToken)other);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new SqlWhiteSpaceDetector()));
        CaseInsensitiveWordRule wordRule = new CaseInsensitiveWordRule(new SqlWordDetector(), (IToken)other);
        SqlSyntax sqlSyntax = new SqlSyntax();
        for (String word : sqlSyntax.getReservedWords()) {
            wordRule.addWord(word, (IToken)keyword);
        }
        for (String dataTypeName : sqlSyntax.getDataTypeNames()) {
            wordRule.addWord(dataTypeName, (IToken)datatype);
        }
        for (String functionName : sqlSyntax.getFunctionNames()) {
            wordRule.addWord(functionName, (IToken)function);
        }
        rules.add((Object)wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

