/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.sql;

import java.util.Vector;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.teiid.query.ui.sqleditor.sql.SqlSyntax;
import org.teiid.query.ui.sqleditor.sql.WordPartDetector;

public class SqlCompletionProcessor
implements IContentAssistProcessor {
    protected Vector proposalList = new Vector();
    protected IContextInformationValidator fValidator = new Validator();
    private SqlSyntax sqlSyntax = new SqlSyntax();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        WordPartDetector wordPart = new WordPartDetector(viewer, documentOffset);
        for (String word : this.sqlSyntax.getAllWords()) {
            if (!word.startsWith(wordPart.getString().toUpperCase())) continue;
            this.proposalList.add(word);
        }
        return this.turnProposalVectorIntoAdaptedArray(wordPart);
    }

    protected ICompletionProposal[] turnProposalVectorIntoAdaptedArray(WordPartDetector word) {
        ICompletionProposal[] result = new ICompletionProposal[this.proposalList.size()];
        int index = 0;
        for (String keyWord : this.proposalList) {
            ContextInformation info = new ContextInformation(keyWord, this.getContentInfoString(keyWord));
            result[index] = new CompletionProposal(keyWord, word.getOffset(), word.getString().length(), keyWord.length(), null, keyWord, (IContextInformation)info, this.getContentInfoString(keyWord));
            ++index;
        }
        this.proposalList.removeAllElements();
        return result;
    }

    private String getContentInfoString(String keyWord) {
        return "";
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        IContextInformation[] result = new IContextInformation[]{new ContextInformation("contextDisplayString", "informationDisplayString"), new ContextInformation("contextDisplayString2", "informationDisplayString2")};
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

