/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.sql;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class SqlDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;
    protected int fPos;
    protected int fStartPos;
    protected int fEndPos;

    public void doubleClicked(ITextViewer viewer) {
        this.fPos = viewer.getSelectedRange().x;
        if (this.fPos < 0) {
            return;
        }
        this.fText = viewer;
        this.selectWord();
    }

    protected void selectWord() {
        if (this.matchWord()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
        }
    }

    protected boolean matchWord() {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = this.fPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            this.fStartPos = pos;
            pos = this.fPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            this.fEndPos = pos;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

