/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressConstants;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.JdbcUtil;
import org.teiid.designer.jdbc.relational.CostAnalyzer;
import org.teiid.designer.jdbc.relational.CostAnalyzerFactory;
import org.teiid.designer.jdbc.relational.impl.TableStatistics;
import org.teiid.designer.jdbc.ui.InternalModelerJdbcUiPluginConstants;
import org.teiid.designer.jdbc.ui.ModelerJdbcUiPlugin;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class JdbcCostAnalysisAction
extends SortableSelectionAction {
    private IFile selectedModel;
    private List<Table> selectedTables;

    public JdbcCostAnalysisAction() {
        this.setImageDescriptor(ModelerJdbcUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/costing.gif"));
    }

    public boolean isApplicable(ISelection selection) {
        return this.isValidSelection(selection);
    }

    protected boolean isValidSelection(ISelection selection) {
        boolean isValid = true;
        this.selectedModel = null;
        this.selectedTables = null;
        if (SelectionUtilities.isEmptySelection((ISelection)selection)) {
            isValid = false;
        }
        if (isValid) {
            try {
                if (SelectionUtilities.isSingleSelection((ISelection)selection)) {
                    Object obj = SelectionUtilities.getSelectedObject((ISelection)selection);
                    ModelResource modelResource = null;
                    if (obj instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)obj))) {
                        modelResource = ModelUtil.getModelResource((IFile)((IFile)obj), (boolean)false);
                    } else if (obj instanceof Table) {
                        modelResource = ModelUtil.getModel((Object)obj);
                    } else {
                        isValid = false;
                    }
                    if (isValid) {
                        if (ModelUtilities.hasJdbcSource((ModelResource)modelResource)) {
                            this.selectedModel = (IFile)modelResource.getResource();
                            if (obj instanceof Table) {
                                this.selectedTables = new ArrayList<Table>();
                                this.selectedTables.add((Table)obj);
                            }
                        } else {
                            isValid = false;
                        }
                    }
                } else {
                    ModelResource theModel = null;
                    List objs = SelectionUtilities.getSelectedObjects((ISelection)selection);
                    ArrayList<Table> allTables = new ArrayList<Table>();
                    for (Object aObj : objs) {
                        if (aObj instanceof Table) {
                            ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource((EObject)((Table)aObj));
                            if (modelResource != null) {
                                if (theModel == null) {
                                    theModel = modelResource;
                                }
                                if (!modelResource.equals(theModel)) {
                                    isValid = false;
                                    break;
                                }
                                allTables.add((Table)aObj);
                                continue;
                            }
                            isValid = false;
                            break;
                        }
                        isValid = false;
                        break;
                    }
                    if (isValid) {
                        if (ModelUtilities.hasJdbcSource(theModel)) {
                            this.selectedModel = (IFile)theModel.getResource();
                            this.selectedTables = allTables;
                        } else {
                            isValid = false;
                        }
                    }
                }
            }
            catch (ModelWorkspaceException modelWorkspaceException) {
                isValid = false;
            }
        }
        return isValid;
    }

    public void run() {
        if (this.isEnabled()) {
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            try {
                ModelResource modelResource = ModelUtil.getModelResource((IFile)this.selectedModel, (boolean)false);
                if (modelResource != null) {
                    String allowsCostUpdate = ModelUtil.getModelAnnotationPropertyValue((ModelResource)modelResource, (String)"jdbcConnection:allowCostUpdate");
                    if (allowsCostUpdate != null && !allowsCostUpdate.isEmpty() && !Boolean.getBoolean(allowsCostUpdate)) {
                        String title = InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.costingNotAllowed.title", new Object[0]);
                        String message = InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.costingNotAllowed.msg", new Object[0]);
                        MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
                        return;
                    }
                    boolean cancelled = this.openEditorIfNeeded(modelResource);
                    if (cancelled) {
                        return;
                    }
                    Resource resource = modelResource.getEmfResource();
                    this.executeInTransaction(resource, this.selectedTables, shell);
                }
            }
            catch (Exception e) {
                InternalModelerJdbcUiPluginConstants.Util.log((Throwable)e);
                String title = InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.errorTitle", new Object[0]);
                String message = InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.errorMessage", new Object[0]);
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        }
    }

    private void executeInTransaction(Resource resource, List<Table> tables, Shell shell) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Update Cost Statistics", (Object)((Object)this));
        boolean succeeded = false;
        try {
            this.internalExecute(resource, tables, shell);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private void internalExecute(Resource resource, List<Table> tables, Shell shell) {
        JdbcSource source;
        if (resource != null && (source = JdbcUtil.findJdbcSource((Resource)resource)) != null) {
            final List<Table> emfTables = this.getTables(tables, resource);
            final CostAnalyzerFactory analyzerFactory = CostAnalyzerFactory.getCostAnalyzerFactory();
            final Map tblStats = analyzerFactory.createTableInfos(emfTables);
            if (tblStats != null && tblStats.size() > 0) {
                CostAnalysisDialog dialog = new CostAnalysisDialog(shell, InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.taskDescription", new Object[0]), InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.passwordPrompt", new Object[]{source.getUrl(), source.getUsername()}), null, null);
                dialog.open();
                final String password = dialog.getValue();
                if (password != null) {
                    Job job = new Job(InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.jobDescription", new Object[0])){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                monitor.beginTask(InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.taskDescription", new Object[0]), JdbcCostAnalysisAction.this.calculateNumberOfWorkIncrements(tblStats.values()));
                                CostAnalyzer costAnalyzer = analyzerFactory.getCostAnalyzer(source, password);
                                costAnalyzer.collectStatistics(tblStats, monitor);
                                if (!monitor.isCanceled()) {
                                    analyzerFactory.populateEmfColumnStatistics(emfTables, tblStats);
                                }
                                monitor.done();
                                if (monitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                return new Status(0, "org.teiid.designer.jdbc.ui", 0, InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.statusFinished", (Object)emfTables.size()), null);
                            }
                            catch (Exception e) {
                                InternalModelerJdbcUiPluginConstants.Util.log((Throwable)e);
                                return new Status(4, "org.teiid.designer.jdbc.ui", 4, InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.errorMessage", new Object[0]), (Throwable)e);
                            }
                        }
                    };
                    job.setSystem(false);
                    job.setUser(true);
                    job.setProperty(IProgressConstants.KEEP_PROPERTY, (Object)Boolean.TRUE);
                    job.schedule();
                }
            } else {
                MessageDialog.openInformation((Shell)shell, (String)InternalModelerJdbcUiPluginConstants.Util.getString("JdbcCostAnalysisAction.taskDescription", new Object[0]), (String)InternalModelerJdbcUiPluginConstants.Util.getString("CostAnalysisAction.noValidTablesMessage", new Object[0]));
            }
        }
    }

    int calculateNumberOfWorkIncrements(Collection tblStats) {
        int numWorkInc = tblStats.size() * 2;
        for (TableStatistics tblStat : tblStats) {
            numWorkInc += tblStat.getColumnStats().size();
        }
        return numWorkInc;
    }

    private List<Table> getTables(List<Table> selectedTables, Resource resource) {
        List<Table> resultTables = null;
        resultTables = selectedTables != null && !selectedTables.isEmpty() ? selectedTables : RelationalUtil.findTables((Object)resource);
        return resultTables;
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    private boolean openEditorIfNeeded(ModelResource currentModel) {
        boolean openEditorCancelled = false;
        if (currentModel != null && !this.isEditorOpen(currentModel) && !currentModel.getResource().getResourceAttributes().isReadOnly()) {
            IFile modelFile = (IFile)currentModel.getResource();
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)ModelEditorManager.OPEN_EDITOR_TITLE, (String)ModelEditorManager.OPEN_EDITOR_MESSAGE)) {
                ModelEditorManager.openInEditMode((Object)modelFile, (boolean)true, (int)0);
            } else {
                openEditorCancelled = true;
            }
        }
        return openEditorCancelled;
    }

    private boolean isEditorOpen(ModelResource currentModel) {
        if (currentModel != null) {
            IFile modelFile = (IFile)currentModel.getResource();
            return ModelEditorManager.isOpen((IFile)modelFile);
        }
        return false;
    }

    class CostAnalysisDialog
    extends InputDialog {
        private static final char ECHO_CHAR = '*';

        public CostAnalysisDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            this.getText().setEchoChar('*');
            return control;
        }
    }
}

