/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.data.Request;
import org.teiid.designer.jdbc.data.Results;
import org.teiid.designer.jdbc.data.ResultsMetadata;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcSchema;
import org.teiid.designer.jdbc.metadata.impl.ItemFilter;
import org.teiid.designer.jdbc.relational.JdbcImporter;
import org.teiid.designer.jdbc.ui.InternalModelerJdbcUiPluginConstants;
import org.teiid.designer.jdbc.ui.ModelerJdbcUiConstants;
import org.teiid.designer.jdbc.ui.ModelerJdbcUiPlugin;
import org.teiid.designer.jdbc.ui.util.JdbcUiUtil;
import org.teiid.designer.jdbc.ui.wizards.JdbcImportWizard;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.AbstractTableLabelProvider;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;

public class JdbcImportObjectsPage
extends WizardPage
implements InternalUiConstants.Widgets,
ModelerJdbcUiConstants.Images,
PluginConstants.Images,
CoreStringUtil.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(JdbcImportObjectsPage.class);
    private static final String TITLE = JdbcImportObjectsPage.getString("title");
    private static final String TITLE_WITH_VDB_SOURCE = String.valueOf(TITLE) + " (VDB source model)";
    private static final int COLUMN_COUNT = 1;
    private static final String INITIAL_MESSAGE_ID = "initialMessage";
    private static final String STATUS_LABEL_ID = "statusLabel";
    private static final String SHOW_ALL_SCHEMAS_ID = "showAllSchemasValue";
    private static final String SHOW_SELECTED_SCHEMAS_ID = "showSelectedSchemasValue";
    private static final String SHOW_FILTERED_SCHEMAS_ID = "showFilteredSchemasValue";
    private static final String INVALID_PAGE_MESSAGE = JdbcImportObjectsPage.getString("invalidPageMessage");
    private static final String TOO_MANY_SCHEMA_MESSAGE = JdbcImportObjectsPage.getString("tooManySchemaSelectedMessage");
    private static final String NO_OBJECTS = JdbcImportObjectsPage.getString("noObjects");
    private static final String AND = "and";
    private static final String REFRESH_TOOLTIP = JdbcImportObjectsPage.getString("refreshTooltip");
    private static final int[] SPLITTER_WEIGHTS = new int[]{30, 70};
    private static final String NA = JdbcImportObjectsPage.getString("na");
    private static final String REQUEST_ERROR_MESSAGE_ID = "requestErrorMessage";
    private static final String UNKNOWN_COLUMN_LABEL = "Col_";
    private static final String CHECK_SELECTED = JdbcImportObjectsPage.getString("checkSelected");
    private static final String UNCHECK_SELECTED = JdbcImportObjectsPage.getString("uncheckSelected");
    private static final String RADIO_SHOW_ALL_SCHEMA_TXT = JdbcImportObjectsPage.getInternalString("radioShowAllSchemaText");
    private static final String RADIO_SHOW_SELECTED_SCHEMA_TXT = JdbcImportObjectsPage.getInternalString("radioShowSelectedSchemaText");
    private static final String RADIO_SHOW_FILTERED_SCHEMA_TXT = JdbcImportObjectsPage.getInternalString("radioShowFilteredSchemaText");
    private static final String RADIO_SHOW_ALL_SCHEMA_TIP = JdbcImportObjectsPage.getInternalString("radioShowAllSchemaTooltip");
    private static final String RADIO_SHOW_SELECTED_SCHEMA_TIP = JdbcImportObjectsPage.getInternalString("radioShowSelectedSchemaTooltip");
    private static final String RADIO_SHOW_FILTERED_SCHEMA_TIP = JdbcImportObjectsPage.getInternalString("radioShowFilteredSchemaTooltip");
    private static final String TYPE_NAME_SCHEMA = "schema";
    private static final String TYPE_NAME_TABLE = "table";
    private static final String TYPE_NAME_STORED_PROC = "storedproc";
    JdbcDatabase db;
    private SashForm splitter;
    private ViewForm objsView;
    TreeViewer treeViewer;
    private CTabFolder tabFolder;
    private SelectionAdapter tabListener;
    private CLabel dbLabel;
    private CLabel statusLabel;
    Button showAllSchemaButton;
    Button showSelectedSchemaButton;
    Button showFilteredSchemaButton;
    private JdbcNode selectedNode;
    private Map counts = new HashMap(0);
    private IAction checkSelectedAction;
    private IAction uncheckSelectedAction;
    private JdbcImporter importer;
    boolean refreshing;

    private static String getString(String id) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, String parameter) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, (Object)parameter);
    }

    private static String getInternalString(String id) {
        return InternalModelerJdbcUiPluginConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    protected JdbcImportObjectsPage() {
        super(JdbcImportObjectsPage.class.getSimpleName(), TITLE, null);
    }

    public void createControl(Composite parent) {
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(768));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridLayoutFactory.fillDefaults().equalWidth(false).applyTo((Composite)scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, false);
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(768));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        this.splitter = WidgetFactory.createSplitter((Composite)mainPanel);
        this.objsView = new ViewForm((Composite)this.splitter, 2048);
        this.dbLabel = WidgetFactory.createLabel((Composite)this.objsView, (Image)ModelerJdbcUiPlugin.getDefault().getImage("icons/full/obj16/database.gif"));
        this.objsView.setTopLeft((Control)this.dbLabel);
        ToolBar bar = new ToolBar((Composite)this.objsView, 0x800000);
        ToolBarManager mgr = new ToolBarManager(bar);
        Action action = new Action(){

            public void run() {
                JdbcImportObjectsPage.this.refresh();
            }
        };
        action.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/refresh.gif"));
        action.setToolTipText(REFRESH_TOOLTIP);
        mgr.add((IAction)action);
        mgr.update(true);
        this.objsView.setTopRight((Control)bar);
        this.treeViewer = new TreeViewer((Composite)this.objsView, 2850);
        Tree tree = this.treeViewer.getTree();
        GridDataFactory.fillDefaults().hint(120, 120).applyTo((Control)tree);
        this.objsView.setContent((Control)tree);
        this.treeViewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        MenuManager menuMgr = this.createContextMenu();
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.treeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TreeItem treeItem = (TreeItem)e.item;
                    JdbcNode jdbcNode = (JdbcNode)treeItem.getData();
                    JdbcImportObjectsPage.this.treeViewer.getTree().setSelection(new TreeItem[]{treeItem});
                    JdbcImportObjectsPage.this.nodeSelected(jdbcNode);
                    JdbcImportObjectsPage.this.setNodeSelected(jdbcNode, treeItem, jdbcNode.getSelectionMode() != 1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object node) {
                return ((JdbcNode)node).getName();
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!SelectionUtilities.isMultiSelection((ISelection)event.getSelection())) {
                    JdbcNode node = (JdbcNode)((IStructuredSelection)event.getSelection()).getFirstElement();
                    JdbcImportObjectsPage.this.nodeSelected(node);
                } else {
                    JdbcImportObjectsPage.this.nodeSelected(null);
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JdbcImportObjectsPage.this.nodeDoubleClicked(event);
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                JdbcImportObjectsPage.this.nodeExpanded(event);
            }
        });
        ViewForm tabView = new ViewForm((Composite)this.splitter, 2048);
        this.tabFolder = WidgetFactory.createTabFolder((Composite)tabView);
        tabView.setContent((Control)this.tabFolder);
        this.tabListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportObjectsPage.this.tabSelected();
            }
        };
        this.splitter.setWeights(SPLITTER_WEIGHTS);
        this.statusLabel = WidgetFactory.createLabel((Composite)mainPanel, (int)256);
        Button deselectAllButton = WidgetFactory.createButton((Composite)mainPanel, (String)DESELECT_ALL_BUTTON);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JdbcImportObjectsPage.this.deselectAllButtonSelected();
            }
        });
        Group showGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)"Show", (int)256, (int)1, (int)3);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 5).applyTo((Composite)showGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)showGroup);
        this.showAllSchemaButton = WidgetFactory.createRadioButton((Composite)showGroup, (String)"All schema");
        this.showAllSchemaButton.setToolTipText(RADIO_SHOW_ALL_SCHEMA_TIP);
        this.showAllSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!JdbcImportObjectsPage.this.refreshing) {
                    JdbcImportObjectsPage.this.refresh();
                }
                JdbcImportObjectsPage.this.saveWidgetValues();
            }
        });
        this.showSelectedSchemaButton = WidgetFactory.createRadioButton((Composite)showGroup, (String)"Only selected schema");
        this.showSelectedSchemaButton.setToolTipText(RADIO_SHOW_SELECTED_SCHEMA_TIP);
        this.showSelectedSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!JdbcImportObjectsPage.this.refreshing) {
                    JdbcImportObjectsPage.this.refresh();
                }
                JdbcImportObjectsPage.this.saveWidgetValues();
            }
        });
        this.showFilteredSchemaButton = WidgetFactory.createRadioButton((Composite)showGroup, (String)"Selected and connection filtered schema");
        this.showFilteredSchemaButton.setToolTipText(RADIO_SHOW_FILTERED_SCHEMA_TIP);
        this.showFilteredSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!JdbcImportObjectsPage.this.refreshing) {
                    JdbcImportObjectsPage.this.refresh();
                }
                JdbcImportObjectsPage.this.saveWidgetValues();
            }
        });
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)hostPanel);
        this.restoreWidgetValues();
    }

    private MenuManager createContextMenu() {
        MenuManager mgr = new MenuManager();
        this.checkSelectedAction = new Action(CHECK_SELECTED, 2048){

            public void run() {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = JdbcImportObjectsPage.this.treeViewer.getTree().getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    JdbcNode jdbcNode = (JdbcNode)item.getData();
                    item.setChecked(true);
                    JdbcImportObjectsPage.this.nodeSelected(jdbcNode);
                    JdbcImportObjectsPage.this.setNodeSelected(jdbcNode, item, true);
                    ++n2;
                }
            }
        };
        this.uncheckSelectedAction = new Action(UNCHECK_SELECTED, 2048){

            public void run() {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = JdbcImportObjectsPage.this.treeViewer.getTree().getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    JdbcNode jdbcNode = (JdbcNode)item.getData();
                    item.setChecked(false);
                    JdbcImportObjectsPage.this.nodeSelected(jdbcNode);
                    JdbcImportObjectsPage.this.setNodeSelected(jdbcNode, item, false);
                    ++n2;
                }
            }
        };
        mgr.add(this.checkSelectedAction);
        mgr.add(this.uncheckSelectedAction);
        return mgr;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.db = ((JdbcImportWizard)this.getWizard()).getDatabase();
            this.refresh();
            this.importer.setReachedObjectsPage(true);
        }
        super.setVisible(visible);
        if (this.importer.isVdbSourceModel()) {
            this.setTitle(TITLE_WITH_VDB_SOURCE);
        } else {
            this.setTitle(TITLE);
        }
    }

    protected void deselectAllButtonSelected() {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        int ndx = items.length;
        while (--ndx >= 0) {
            TreeItem item = items[ndx];
            JdbcNode node = (JdbcNode)item.getData();
            this.setNodeSelected(node, item, false);
        }
    }

    void nodeDoubleClicked(DoubleClickEvent event) {
        Object node;
        this.treeViewer.setExpandedState(node, !this.treeViewer.getExpandedState(node = ((IStructuredSelection)event.getSelection()).getFirstElement()));
    }

    void nodeExpanded(TreeExpansionEvent event) {
        this.updateCheckBoxes(WidgetUtil.findTreeItem((Object)event.getElement(), (TreeViewer)this.treeViewer).getItems());
    }

    void nodeSelected(JdbcNode node) {
        if (node == null || node == this.selectedNode) {
            return;
        }
        this.selectedNode = node;
        this.tabFolder.removeSelectionListener((SelectionListener)this.tabListener);
        CTabItem[] items = this.tabFolder.getItems();
        int ndx = items.length;
        while (--ndx >= 0) {
            items[ndx].dispose();
        }
        try {
            String[] names = node.getNamesOfResults();
            if (names.length == 0) {
                WidgetFactory.createTab((CTabFolder)this.tabFolder, (String)NA);
                return;
            }
            int ndx2 = 0;
            while (ndx2 < names.length) {
                WidgetFactory.createTab((CTabFolder)this.tabFolder, (String)names[ndx2]);
                ++ndx2;
            }
            this.tabFolder.addSelectionListener((SelectionListener)this.tabListener);
            if (names.length > 0) {
                this.tabFolder.setSelection(this.tabFolder.getItem(0));
                this.tabFolder.notifyListeners(13, new Event());
            }
        }
        catch (JdbcException err) {
            JdbcUiUtil.showAccessError(err);
        }
    }

    protected void refresh() {
        this.refreshing = true;
        this.db.refresh();
        JdbcNode[] selectedNodes = this.getSelectedChildren();
        if (selectedNodes == null || selectedNodes.length == 0) {
            if (this.showSelectedSchemaButton.getSelection()) {
                this.showAllSchemaButton.setSelection(true);
                if (!this.refreshing) {
                    this.refresh();
                }
                this.showSelectedSchemaButton.setEnabled(false);
            }
        } else {
            this.showSelectedSchemaButton.setEnabled(true);
        }
        String name = this.db.getName();
        this.dbLabel.setText(name);
        this.treeViewer.setInput((Object)this.db);
        this.validatePage(this.treeViewer.getTree().getItems());
        if (this.isPageComplete()) {
            this.setMessage(JdbcImportObjectsPage.getString(INITIAL_MESSAGE_ID, name));
        }
        try {
            JdbcNode[] nodes = this.db.getChildren();
            int ndx = 0;
            while (ndx < nodes.length) {
                JdbcNode node = nodes[ndx];
                if (node.getSelectionMode() != 0) {
                    this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
                    break;
                }
                ++ndx;
            }
        }
        catch (JdbcException err) {
            JdbcUiUtil.showAccessError(err);
        }
        this.refreshing = false;
    }

    void tabSelected() {
        CTabFolder tabFolder = this.tabFolder;
        CTabItem tab = tabFolder.getSelection();
        if (tab.getControl() != null) {
            return;
        }
        try {
            Request rqst = this.selectedNode.getRequest(this.selectedNode.getNamesOfResults()[tabFolder.getSelectionIndex()]);
            final Results results = rqst.getResults();
            List metadatas = results.getMetadata().getColumnMetadata();
            if (metadatas.isEmpty()) {
                Object obj;
                Object[] row = results.getRows();
                if (row.length > 0 && (obj = row[0]) != null) {
                    WidgetFactory.createLabel((Composite)this.tabFolder, (String)obj.toString(), (int)64);
                }
            } else {
                TableViewer viewer = new TableViewer((Composite)this.tabFolder, 2816);
                tab.setControl((Control)viewer.getTable());
                viewer.setLabelProvider((IBaseLabelProvider)new AbstractTableLabelProvider(){

                    public String getColumnText(Object row, int column) {
                        Object obj = ((List)row).get(column);
                        return obj == null ? "" : obj.toString();
                    }
                });
                viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        return results.getRows();
                    }

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                });
                Table table = viewer.getTable();
                table.setHeaderVisible(true);
                int nUnknownColumns = 0;
                Iterator iter = metadatas.iterator();
                while (iter.hasNext()) {
                    TableColumn col = new TableColumn(table, 0);
                    ResultsMetadata.ColumnMetadata metadata = (ResultsMetadata.ColumnMetadata)iter.next();
                    if (metadata.getLabel() != null) {
                        col.setText(metadata.getLabel());
                    } else {
                        col.setText(UNKNOWN_COLUMN_LABEL + nUnknownColumns);
                        ++nUnknownColumns;
                    }
                    switch (metadata.getType()) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            col.setAlignment(131072);
                        }
                    }
                }
                viewer.setInput((Object)this);
                TableColumn[] cols = table.getColumns();
                int ndx = 0;
                while (ndx < cols.length) {
                    cols[ndx].pack();
                    ++ndx;
                }
            }
        }
        catch (JdbcException err) {
            JdbcUiUtil.showAccessError(err);
        }
    }

    protected void setNodeSelected(JdbcNode node, TreeItem item, boolean selected) {
        node.setSelected(selected);
        this.updateCheckBox(item);
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            this.updateCheckBox(parent);
            parent = parent.getParentItem();
        }
        this.validatePage(item.getItems());
    }

    protected JdbcNode[] getSelectedChildren() {
        try {
            return this.getDatabase().getSelectedChildren();
        }
        catch (JdbcException err) {
            JdbcUiUtil.showAccessError(err);
            return null;
        }
    }

    protected JdbcNode[] getSelectedPlusFilteredChildren() {
        ArrayList<JdbcNode> filteredList = new ArrayList<JdbcNode>();
        JdbcNode[] selectedChildren = this.getSelectedChildren();
        if (selectedChildren != null) {
            int i = 0;
            while (i < selectedChildren.length) {
                filteredList.add(selectedChildren[i]);
                ++i;
            }
        }
        try {
            String schemaFilterStr = this.importer.getSchemaFilter();
            String tableFilterStr = this.importer.getTableFilter();
            String storedProcFilterStr = this.importer.getStoredProcFilter();
            ItemFilter schemaFilter = null;
            ItemFilter tableFilter = null;
            ItemFilter storedProcFilter = null;
            if (!CoreStringUtil.isEmpty((String)schemaFilterStr)) {
                schemaFilter = new ItemFilter(schemaFilterStr);
            }
            if (!CoreStringUtil.isEmpty((String)tableFilterStr)) {
                tableFilter = new ItemFilter(tableFilterStr);
            }
            if (!CoreStringUtil.isEmpty((String)storedProcFilterStr)) {
                storedProcFilter = new ItemFilter(storedProcFilterStr);
            }
            JdbcNode[] allChildren = this.getDatabase().getChildren();
            int i = 0;
            while (i < allChildren.length) {
                JdbcNode node = allChildren[i];
                String typeName = node.getTypeName();
                if (typeName.equals(TYPE_NAME_SCHEMA)) {
                    if (schemaFilter != null) {
                        if (schemaFilter.isMatch(node.getName())) {
                            filteredList.add(node);
                        }
                    } else {
                        filteredList.add(node);
                    }
                } else if (typeName.equals(TYPE_NAME_TABLE)) {
                    if (tableFilter != null) {
                        if (tableFilter.isMatch(node.getName())) {
                            filteredList.add(node);
                        }
                    } else {
                        filteredList.add(node);
                    }
                } else if (typeName.equals(TYPE_NAME_STORED_PROC)) {
                    if (storedProcFilter != null) {
                        if (storedProcFilter.isMatch(node.getName())) {
                            filteredList.add(node);
                        }
                    } else {
                        filteredList.add(node);
                    }
                }
                ++i;
            }
            JdbcNode[] resultArr = new JdbcNode[filteredList.size()];
            resultArr = filteredList.toArray(resultArr);
            return resultArr;
        }
        catch (JdbcException err) {
            JdbcUiUtil.showAccessError(err);
            return null;
        }
    }

    protected void updateCheckBox(TreeItem item) {
        JdbcNode node = (JdbcNode)item.getData();
        if (node == null) {
            return;
        }
        int selection = node.getSelectionMode();
        item.setChecked(selection != 0);
        item.setGrayed(selection == 2);
    }

    private void updateCheckBoxes(TreeItem[] items) {
        int ndx = items.length;
        while (--ndx >= 0) {
            TreeItem item = items[ndx];
            this.updateCheckBoxes(item.getItems());
            this.updateCheckBox(item);
        }
    }

    private void updateCounts(JdbcNode[] nodes) throws JdbcException {
        int ndx = nodes.length;
        while (--ndx >= 0) {
            JdbcNode node = nodes[ndx];
            int selection = node.getSelectionMode();
            if (selection == 0) continue;
            if (node.allowsChildren()) {
                this.updateCounts(node.getChildren());
                continue;
            }
            if (selection != 1) continue;
            String name = node.getTypeName();
            Integer count = (Integer)this.counts.get(name);
            if (count == null) {
                this.counts.put(name, new Integer(1));
                continue;
            }
            this.counts.put(name, new Integer(count + 1));
        }
    }

    protected void validatePage(TreeItem[] items) {
        JdbcNode[] selectedNodes;
        boolean isOK = true;
        try {
            boolean valid;
            this.counts.clear();
            this.updateCounts(this.db.getChildren());
            this.updateCheckBoxes(items);
            boolean bl = valid = this.counts.size() > 0;
            if (valid) {
                StringBuffer msg = new StringBuffer();
                Set set = this.counts.entrySet();
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (msg.length() > 0) {
                        if (set.size() > 2) {
                            msg.append(',');
                        }
                        msg.append(' ');
                        if (!iter.hasNext()) {
                            msg.append(Util.keyExists(AND) ? Util.getString(AND, new Object[0]) : AND);
                            msg.append(' ');
                        }
                    }
                    msg.append(entry.getValue());
                    msg.append(' ');
                    msg.append(entry.getKey().toString().toLowerCase());
                    this.statusLabel.setText(JdbcImportObjectsPage.getString(STATUS_LABEL_ID, msg.toString()));
                    WizardUtil.setPageComplete((WizardPage)this);
                }
            } else {
                this.statusLabel.setText(JdbcImportObjectsPage.getString(STATUS_LABEL_ID, NO_OBJECTS));
                WizardUtil.setPageComplete((WizardPage)this, (String)INVALID_PAGE_MESSAGE, (int)3);
                isOK = false;
            }
        }
        catch (JdbcException err) {
            JdbcUiUtil.showAccessError(err);
        }
        if (isOK && this.importer.isVdbSourceModel() && (selectedNodes = this.getSelectedChildren()) != null && selectedNodes.length > 0) {
            int nSchema = 0;
            String schemaName = null;
            JdbcNode[] jdbcNodeArray = selectedNodes;
            int n = selectedNodes.length;
            int n2 = 0;
            while (n2 < n) {
                JdbcNode node = jdbcNodeArray[n2];
                if (node instanceof JdbcSchema) {
                    ++nSchema;
                    schemaName = node.getName();
                }
                if (nSchema > 1) {
                    WizardUtil.setPageComplete((WizardPage)this, (String)TOO_MANY_SCHEMA_MESSAGE, (int)3);
                    break;
                }
                ++n2;
            }
            if (nSchema == 1) {
                this.importer.setVdbSourceModelName(schemaName);
            }
        }
        if (this.getSelectedChildren().length == 0) {
            this.showSelectedSchemaButton.setEnabled(false);
        } else {
            this.showSelectedSchemaButton.setEnabled(true);
        }
    }

    public final JdbcDatabase getDatabase() {
        return this.db;
    }

    protected void saveWidgetValues() {
        IDialogSettings dlgSettings = this.getDialogSettings();
        dlgSettings.put(SHOW_ALL_SCHEMAS_ID, this.showAllSchemaButton.getSelection());
        dlgSettings.put(SHOW_SELECTED_SCHEMAS_ID, this.showSelectedSchemaButton.getSelection());
        dlgSettings.put(SHOW_FILTERED_SCHEMAS_ID, this.showFilteredSchemaButton.getSelection());
    }

    protected void restoreWidgetValues() {
        IDialogSettings dlgSettings = this.getDialogSettings();
        boolean showAllSchemas = dlgSettings.getBoolean(SHOW_ALL_SCHEMAS_ID);
        boolean showSelectedSchemas = dlgSettings.getBoolean(SHOW_SELECTED_SCHEMAS_ID);
        boolean showFilteredSchemas = dlgSettings.getBoolean(SHOW_FILTERED_SCHEMAS_ID);
        if (!(showAllSchemas || showSelectedSchemas || showFilteredSchemas)) {
            showAllSchemas = true;
        }
        if (showAllSchemas) {
            this.showAllSchemaButton.setSelection(showAllSchemas);
        } else if (showSelectedSchemas) {
            this.showSelectedSchemaButton.setSelection(showSelectedSchemas);
        } else if (showFilteredSchemas) {
            this.showFilteredSchemaButton.setSelection(showFilteredSchemas);
        }
    }

    public void setImporter(JdbcImporter importer) {
        this.importer = importer;
    }

    protected ITreeContentProvider createTreeContentProvider() {
        return new TreeContentProvider();
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object node) {
            try {
                if (JdbcImportObjectsPage.this.showSelectedSchemaButton.getSelection()) {
                    if (node instanceof JdbcDatabase) {
                        return JdbcImportObjectsPage.this.getSelectedChildren();
                    }
                } else if (JdbcImportObjectsPage.this.showFilteredSchemaButton.getSelection() && node instanceof JdbcDatabase) {
                    return JdbcImportObjectsPage.this.getSelectedPlusFilteredChildren();
                }
                return ((JdbcNode)node).getChildren();
            }
            catch (JdbcException err) {
                JdbcUiUtil.showAccessError(err);
                return null;
            }
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (JdbcImportObjectsPage.this.showSelectedSchemaButton.getSelection()) {
                    return JdbcImportObjectsPage.this.getSelectedChildren();
                }
                if (JdbcImportObjectsPage.this.showFilteredSchemaButton.getSelection()) {
                    return JdbcImportObjectsPage.this.getSelectedPlusFilteredChildren();
                }
                return JdbcImportObjectsPage.this.db.getChildren();
            }
            catch (JdbcException err) {
                JdbcUiUtil.showAccessError(err);
                return null;
            }
        }

        public Object getParent(Object node) {
            return ((JdbcNode)node).getParent();
        }

        public boolean hasChildren(Object node) {
            try {
                return ((JdbcNode)node).getChildren().length > 0;
            }
            catch (JdbcException err) {
                JdbcUiUtil.showAccessError(err);
                return false;
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

