/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.model;

import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.esb.core.model.SpecificActionLoader;
import org.jboss.tools.esb.core.model.SpecificPropertyConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESBLoaderUtil
extends XModelObjectLoaderUtil {
    protected String getChildEntity(XModelEntity entity, Element e) {
        String result = super.getChildEntity(entity, e);
        if (result != null && result.startsWith("ESBPreAction")) {
            if (entity.getChild("ESBAction101") != null) {
                return "ESBAction101";
            }
            if (entity.getChild("ESBAction120") != null) {
                return "ESBAction120";
            }
        }
        return result;
    }

    protected boolean isSaveable(XModelEntity entity, String n, String v, String dv) {
        if (v == null) {
            return false;
        }
        if (v.length() == 0 || v.equals(dv)) {
            XAttribute attr = entity.getAttribute(n);
            return attr != null && "always".equals(attr.getProperty("save"));
        }
        return super.isSaveable(entity, n, v, dv);
    }

    public void loadChildren(Element element, XModelObject o) {
        super.loadChildren(element, o);
        String entity = o.getModelEntity().getName();
        if (SpecificActionLoader.instance.isActionsFolder(entity)) {
            SpecificActionLoader.instance.convertChildrenToSpecific(o);
        } else if ("true".equals(o.getModelEntity().getProperty("hasConvertedProperties")) || o.getModelEntity().getAttribute("message flow priority") != null) {
            SpecificPropertyConverter.instance.convertBasicToSpecific(o);
        }
    }

    public boolean save(Element parent, XModelObject o) {
        if (!this.needToSave(o)) {
            return true;
        }
        if (SpecificActionLoader.instance.isPreActionEntity(o)) {
            o = SpecificActionLoader.instance.convertSpecificActionToBasic(o);
        } else if ("true".equals(o.getModelEntity().getProperty("hasConvertedProperties")) || o.getModelEntity().getAttribute("message flow priority") != null) {
            o = SpecificPropertyConverter.instance.convertSpecificToBasic(o);
        }
        return super.save(parent, o);
    }

    protected boolean needToSave(XModelObject o) {
        String s = o.getModelEntity().getProperty("saveDefault");
        if (!"false".equals(s)) {
            return true;
        }
        if (this.hasSetAttributes(o)) {
            return true;
        }
        XModelObject[] cs = o.getChildren();
        if (o.getChildren().length > 2) {
            return true;
        }
        int i = 0;
        while (i < cs.length) {
            if (this.needToSave(cs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasSetAttributes(XModelObject o) {
        XAttribute[] as = o.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String v;
            String xml = as[i].getXMLName();
            if (xml != null && xml.length() != 0 && !"NAME".equals(xml) && (v = o.getAttributeValue(as[i].getName())) != null && v.length() > 0 && !v.equals(as[i].getDefaultValue())) {
                return true;
            }
            ++i;
        }
        String finalComment = o.get("#final-comment");
        return finalComment != null && finalComment.length() > 0;
    }

    public void saveAttribute(Element element, String xmlname, String value) {
        if ("protected-methods".equals(xmlname)) {
            StringTokenizer st = new StringTokenizer(value, ",");
            Element c = XMLUtilities.createElement((Element)element, (String)xmlname);
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                Element m = XMLUtilities.createElement((Element)c, (String)"method");
                m.setAttribute("name", t);
            }
        } else {
            super.saveAttribute(element, xmlname, value);
        }
    }

    public String getAttribute(Element element, String xmlname, XAttribute attr) {
        if ("protected-methods".equals(xmlname)) {
            Element c = XMLUtilities.getUniqueChild((Element)element, (String)xmlname);
            if (c == null) {
                return "";
            }
            Element[] ms = XMLUtilities.getChildren((Element)c, (String)"method");
            StringBuffer sb = new StringBuffer();
            Element[] elementArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                Element m = elementArray[n2];
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(m.getAttribute("name"));
                ++n2;
            }
            return sb.toString();
        }
        return super.getAttribute(element, xmlname, attr);
    }

    protected Set<String> getAllowedChildren(XModelEntity entity) {
        Set children = super.getAllowedChildren(entity);
        if (entity.getName().equals("ESBHTTPBus120")) {
            children.add("protected-methods");
        }
        return children;
    }

    public boolean saveChildren(Element element, XModelObject o) {
        boolean b = super.saveChildren(element, o);
        if (o.getModelEntity().getName().equals("ESBHTTPBus120")) {
            this.checkHTTPBusDTD(element);
        }
        return b;
    }

    private void checkHTTPBusDTD(Element element) {
        Element pm = XMLUtilities.getUniqueChild((Element)element, (String)"protected-methods");
        if (pm == null) {
            return;
        }
        NodeList list = element.getChildNodes();
        Element reference = null;
        boolean hasProperties = false;
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (n instanceof Element) {
                Element e = (Element)n;
                if ("property".equals(e.getNodeName())) {
                    hasProperties = true;
                    reference = null;
                } else if (hasProperties) {
                    reference = e;
                    hasProperties = false;
                }
            }
            ++i;
        }
        if (reference != null) {
            element.insertBefore(pm, reference);
        } else if (hasProperties) {
            element.appendChild(pm);
        }
    }
}

