/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESBUtil {
    private static final IContainer[] EMPTY_ARRAY = new IContainer[0];
    static String WEB_ROOT = "WEB-ROOT";

    @Deprecated
    public static XModelObject getESBRoot(XModel model) {
        return model.getByPath("FileSystems/ESB-ROOT");
    }

    public static void updateModel(XModel model) {
        XModelObject fs = FileSystemsHelper.getFileSystems((XModel)model);
        IProject project = EclipseResourceUtil.getProject((XModelObject)model.getRoot());
        IContainer[] roots = ESBUtil.getESBRootFolders(project, true);
        if (roots.length == 0) {
            return;
        }
        List<XModelObject> existingRoots = ESBUtil.getExistingWebRoots(fs);
        boolean rootsChanged = ESBUtil.rootsChanged(roots, existingRoots);
        if (rootsChanged) {
            for (XModelObject c : existingRoots) {
                c.removeFromParent();
            }
            int i = 0;
            IContainer[] iContainerArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer root = iContainerArray[n2];
                String webRootLocation = root.getLocation().toString().replace('\\', '/');
                String name = WEB_ROOT;
                if (i > 0) {
                    name = String.valueOf(name) + "-" + i;
                }
                XModelObject webroot = ESBUtil.createFileSystemFolder(model, name, webRootLocation);
                fs.addChild(webroot);
                ++i;
                ++n2;
            }
        }
    }

    static XModelObject createFileSystemFolder(XModel model, String name, String location) {
        XModelObject f = model.createModelObject("FileSystemFolder", null);
        f.setAttributeValue("name", name);
        f.setAttributeValue("location", location);
        return f;
    }

    public static IContainer[] getESBRootFolders(IProject project, boolean ignoreDerived) {
        IVirtualComponent component;
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            CommonPlugin.getDefault().logError((Throwable)e);
        }
        Set srcs = EclipseResourceUtil.getSourceFolders((IProject)project);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jboss.esb");
        if (facet != null && facetedProject != null && facetedProject.getProjectFacetVersion(facet) != null && (component = ComponentCore.createComponent((IProject)project)) != null) {
            IVirtualFolder webRootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
            IContainer[] folders = webRootVirtFolder.getUnderlyingFolders();
            if (folders.length > 1) {
                ArrayList<IContainer> containers = new ArrayList<IContainer>();
                IContainer[] iContainerArray = folders;
                int n = folders.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer container = iContainerArray[n2];
                    if (!(srcs.contains(container) || ignoreDerived && container.isDerived(512))) {
                        containers.add(container);
                    }
                    ++n2;
                }
                return containers.toArray(new IContainer[containers.size()]);
            }
            return folders;
        }
        return EMPTY_ARRAY;
    }

    static List<XModelObject> getExistingWebRoots(XModelObject fs) {
        XModelObject[] cs;
        ArrayList<XModelObject> result = new ArrayList<XModelObject>();
        XModelObject[] xModelObjectArray = cs = fs.getChildren("FileSystemFolder");
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject c = xModelObjectArray[n2];
            if (c.getAttributeValue("name").startsWith(WEB_ROOT)) {
                result.add(c);
            }
            ++n2;
        }
        return result;
    }

    static boolean rootsChanged(IContainer[] webRoots, List<XModelObject> rs) {
        if (webRoots.length != rs.size()) {
            return true;
        }
        int i = 0;
        while (i < webRoots.length) {
            XModelObject o = rs.get(i);
            IResource r = (IResource)o.getAdapter(IResource.class);
            if (r == null || !r.equals((Object)webRoots[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

