/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.model.converters;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.AnyElementObjectImpl;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.esb.core.model.converters.IPropertyConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListConverter
implements IPropertyConverter {
    protected abstract String getPropertyName();

    protected abstract String getItemEntityName();

    @Override
    public void toSpecific(XModelObject basicAction, XModelObject specificAction) {
        XModelObject p = this.getBasicProperty(basicAction);
        if (p == null) {
            return;
        }
        XModelObject[] as = p.getChildren();
        int i = 0;
        while (i < as.length) {
            XModelObject a;
            if (as[i] instanceof AnyElementObjectImpl && (a = this.fromAnyElement(as[i], this.getItemEntityName())) != null) {
                specificAction.addChild(a);
            }
            ++i;
        }
        p.removeFromParent();
    }

    protected XModelObject getBasicProperty(XModelObject basicAction) {
        return basicAction.getChildByPath(this.getPropertyName());
    }

    @Override
    public void toBasic(XModelObject basicAction, XModelObject specificAction) {
        XModelObject[] as = specificAction.getChildren(this.getItemEntityName());
        if (as.length == 0) {
            return;
        }
        XModelObject p = basicAction.getModel().createModelObject("ESBProperty", null);
        p.setAttributeValue("name", this.getPropertyName());
        int i = 0;
        while (i < as.length) {
            XModelObject t = this.toAnyElement(as[i], i);
            p.addChild(t);
            ++i;
        }
        basicAction.addChild(p);
    }

    public XModelObject fromAnyElement(XModelObject any, String toEntity) {
        XModelObject a;
        block13: {
            XModelObject[] cs;
            String tag = any.getAttributeValue("tag");
            Map<String, String> attr = this.toMap(((AnyElementObjectImpl)any).getAttributes());
            attr.put("#text", any.getAttributeValue("text"));
            a = any.getModel().createModelObject(toEntity, null);
            if (!this.isRelevantTag(tag, a)) {
                return null;
            }
            XModelEntity entity = a.getModelEntity();
            XAttribute[] attrs = entity.getAttributes();
            int j = 0;
            while (j < attrs.length) {
                String name = attrs[j].getName();
                String xml = attrs[j].getXMLName();
                if (xml != null && xml.length() != 0) {
                    String value = attr.remove(xml);
                    if (value == null || value.length() == 0) {
                        value = attrs[j].getDefaultValue();
                    }
                    if (value != null) {
                        a.setAttributeValue(name, value);
                    }
                }
                ++j;
            }
            if (entity.getAttribute("attributes") != null) {
                attr.remove("#text");
                StringBuffer sb = new StringBuffer();
                for (String n : attr.keySet()) {
                    String v = attr.get(n);
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(n).append('=').append(v);
                }
                a.setAttributeValue("attributes", sb.toString());
            }
            if ((cs = any.getChildren()).length <= 0 || a.getModelEntity().getChildren().length <= 0) break block13;
            if (a.getModelEntity().getChild("AnyElement") != null) {
                int j2 = 0;
                while (j2 < cs.length) {
                    a.addChild(cs[j2].copy());
                    ++j2;
                }
            } else {
                int j3 = 0;
                while (j3 < cs.length) {
                    String toChildEntity = this.getToChildEntity(cs[j3], a.getModelEntity());
                    XModelObject c = this.fromAnyElement(cs[j3], toChildEntity);
                    if (c != null) {
                        a.addChild(c);
                    }
                    ++j3;
                }
            }
        }
        return a;
    }

    protected String getToChildEntity(XModelObject any, XModelEntity parent) {
        String tag;
        XChild[] cs = parent.getChildren();
        if (cs.length > 1 && (tag = any.getAttributeValue("tag")) != null) {
            XChild[] xChildArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                XChild c = xChildArray[n2];
                XModelEntity e = c.getMetaModel().getEntity(c.getName());
                if (e != null && tag.equals(e.getXMLSubPath())) {
                    return e.getName();
                }
                ++n2;
            }
        }
        return cs[0].getName();
    }

    protected boolean isRelevantTag(String tag, XModelObject object) {
        return object != null && tag != null && tag.equals(object.getModelEntity().getXMLSubPath());
    }

    public XModelObject toAnyElement(XModelObject specific, int index) {
        String as;
        XModelObject t = specific.getModel().createModelObject("AnyElement", null);
        t.setAttributeValue("tag", this.getTagName(specific, index));
        StringBuffer sb = new StringBuffer();
        XModelEntity entity = specific.getModelEntity();
        XAttribute[] attrs = entity.getAttributes();
        int j = 0;
        while (j < attrs.length) {
            String value;
            String name = attrs[j].getName();
            String xml = attrs[j].getXMLName();
            if (xml != null && xml.length() != 0 && ((value = specific.getAttributeValue(name)) != null && value.length() != 0 && !value.equals(attrs[j].getDefaultValue()) || "always".equals(attrs[j].getProperty("save")))) {
                if ("#text".equals(xml)) {
                    t.setAttributeValue("text", value);
                } else {
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(xml).append('=').append(value);
                }
            }
            ++j;
        }
        if (entity.getAttribute("attributes") != null && (as = specific.getAttributeValue("attributes")).length() > 0) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(as);
        }
        String attributes = sb.toString();
        t.setAttributeValue("attributes", attributes);
        t.setAttributeValue(XModelObjectLoaderUtil.ATTR_ID_NAME, "" + (index + 1));
        XModelObject[] cs = specific.getChildren();
        if (cs.length > 0) {
            int j2 = 0;
            while (j2 < cs.length) {
                XModelObject c = null;
                if (cs[j2].getModelEntity().getName().equals("AnyElement")) {
                    c = cs[j2].copy();
                    c.setAttributeValue(XModelObjectLoaderUtil.ATTR_ID_NAME, "" + (j2 + 1));
                } else {
                    c = this.toAnyElement(cs[j2], j2);
                }
                if (c != null) {
                    t.addChild(c);
                }
                ++j2;
            }
        }
        return t;
    }

    protected String getTagName(XModelObject specific, int index) {
        return specific.getModelEntity().getXMLSubPath();
    }

    protected Map<String, String> toMap(String[][] attributes) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < attributes.length) {
            map.put(attributes[i][0], attributes[i][1]);
            ++i;
        }
        return map;
    }
}

