/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.model.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.refactoring.RenameModelObjectChange;
import org.jboss.tools.common.model.refactoring.RenameProcessorRunner;
import org.jboss.tools.esb.core.ESBCoreMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameScheduleIDParticipant
extends RenameParticipant
implements ISharableParticipant {
    public static final String PARTICIPANT_NAME = "esb-RenameScheduleIDParticipant";
    private XModelObject object;

    protected boolean initialize(Object element) {
        if (element instanceof XModelObject) {
            this.object = (XModelObject)element;
            if (this.object.getModelEntity().getAttribute("schedule id") == null) {
                this.object = null;
            }
        }
        return this.object != null;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
    }

    public String getName() {
        return PARTICIPANT_NAME;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!pm.isCanceled()) {
            if (!this.updateReferences() && this.object == null) {
                return null;
            }
            String newName = this.getArguments().getNewName();
            XModelObject f = FileSystemsHelper.getFile((XModelObject)this.object);
            if (f != null) {
                RenameModelObjectChange c1 = RenameModelObjectChange.createChange((XModelObject)f, (String)newName);
                if (c1 != null) {
                    String oldName;
                    XModelObject[] rs;
                    c1.addEdits(new XModelObject[]{this.object}, "schedule id", ESBCoreMessages.SCHEDULE_ID);
                    if (this.updateReferences() && (rs = this.getRefs(oldName = this.object.getAttributeValue("schedule id"))).length > 0) {
                        c1.addEdits(rs, "schedule id ref", ESBCoreMessages.SCHEDULE_ID_REF);
                    }
                }
                return c1;
            }
        }
        return null;
    }

    protected boolean updateReferences() {
        return RenameProcessorRunner.updateReferences((RefactoringProcessor)this.getProcessor());
    }

    private XModelObject[] getRefs(String oldName) {
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        this.collectRefs(list, FileSystemsHelper.getFile((XModelObject)this.object), oldName);
        return list.toArray(new XModelObject[list.size()]);
    }

    private void collectRefs(List<XModelObject> list, XModelObject o, String oldName) {
        XModelObject[] cs;
        if (oldName.equals(o.getAttributeValue("schedule id ref"))) {
            list.add(o);
        }
        XModelObject[] xModelObjectArray = cs = o.getChildren();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject c = xModelObjectArray[n2];
            this.collectRefs(list, c, oldName);
            ++n2;
        }
    }
}

