/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd;

import java.util.Collection;

public class XsdBuilderOptions {
    private static final String XSD_EXT = ".xsd";
    private final boolean genOutput;
    private final boolean genXml;
    private final boolean doFlat;
    private final Collection roots;
    private final String modelName;
    private final boolean genSql;
    private final boolean genInput;
    private final String inputModelName;
    private final boolean genWs;
    private final String wsModelName;
    private final String rootModelName;
    private String parentPath;

    public XsdBuilderOptions(boolean genOutput, boolean genXml, boolean doFlat, Collection roots, String modelName, boolean genSQL, boolean genInput, String inputModelName, boolean genWs, String wsModelName, String rootModelName) {
        this.genOutput = genOutput;
        this.genXml = genXml;
        this.doFlat = doFlat;
        this.genSql = genSQL;
        this.roots = roots;
        this.genInput = genInput;
        this.genWs = genWs;
        this.rootModelName = rootModelName;
        this.modelName = modelName.endsWith(XSD_EXT) ? modelName : String.valueOf(modelName) + XSD_EXT;
        this.inputModelName = inputModelName.endsWith(XSD_EXT) ? inputModelName : String.valueOf(inputModelName) + XSD_EXT;
        this.wsModelName = wsModelName;
    }

    public boolean genSql() {
        return this.genSql;
    }

    public boolean genWs() {
        return this.genWs;
    }

    public boolean genInput() {
        return this.genInput;
    }

    public boolean genXml() {
        return this.genXml;
    }

    public boolean isFlat() {
        return this.doFlat;
    }

    public String getInputModelName() {
        return this.inputModelName;
    }

    public String getWsModelName() {
        return this.wsModelName;
    }

    public String getOutputModelName() {
        return this.modelName;
    }

    public boolean genOutput() {
        return this.genOutput;
    }

    public Collection getRoots() {
        return this.roots;
    }

    public String getRootModelName() {
        return this.rootModelName;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }
}

