/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd.aspects.imports;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AbstractMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.ImportsAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.xsd.XsdPlugin;

public class XsdSchemaDerivativeAspect
extends AbstractMetamodelAspect
implements ImportsAspect,
FileUtils.Constants {
    public static final String ASPECT_ID = "importAspect";

    protected XsdSchemaDerivativeAspect(MetamodelEntity entity) {
        super.setMetamodelEntity(entity);
        super.setID(ASPECT_ID);
    }

    public String getModelLocation(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSchemaDirective.class, (Object)eObject);
        XSDSchemaDirective xsdDerivative = (XSDSchemaDirective)eObject;
        return xsdDerivative.getSchemaLocation();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPath getModelPath(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSchemaDirective.class, (Object)eObject);
        XSDSchemaDirective xsdDerivative = (XSDSchemaDirective)eObject;
        XSDSchema schema = xsdDerivative.getResolvedSchema();
        if (schema == null) return this.findModelPathBySchemaLocation(xsdDerivative);
        Resource schemaResource = schema.eResource();
        if (schemaResource == null) return this.findModelPathBySchemaLocation(xsdDerivative);
        ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(schemaResource);
        if (modelResource == null) return null;
        return modelResource.getPath();
    }

    private IPath findModelPathBySchemaLocation(XSDSchemaDirective xsdDerivative) {
        Path schemaPath;
        String resourceName;
        IResource iResource;
        String schemaLocation = xsdDerivative.getSchemaLocation();
        if (schemaLocation != null && (iResource = this.findResourceInProjectByName(resourceName = (schemaPath = new Path(schemaLocation)).lastSegment(), xsdDerivative)) != null) {
            return iResource.getFullPath();
        }
        return null;
    }

    private IResource findResourceInProjectByName(String name, XSDSchemaDirective xsdDerivative) {
        if (name == null) {
            return null;
        }
        IResource iResource = null;
        Collection iResources = WorkspaceResourceFinderUtil.findIResourceByName((String)name);
        if (iResources.size() == 0) {
            return null;
        }
        if (iResources.size() == 1) {
            iResource = (IResource)iResources.iterator().next();
        } else {
            IResource iRes = WorkspaceResourceFinderUtil.findIResource((URI)xsdDerivative.eResource().getURI());
            IProject project = iRes.getProject();
            for (IFile fileResource : iResources) {
                if (!fileResource.getProject().equals((Object)project)) continue;
                iResource = fileResource;
                break;
            }
            if (iResource == null) {
                iResource = (IResource)iResources.iterator().next();
            }
        }
        return iResource;
    }

    public String getModelType(EObject eObject) {
        return ModelType.TYPE_LITERAL.getName();
    }

    public String getModelUuid(EObject eObject) {
        ModelResource modelResource;
        Resource schemaResource;
        CoreArgCheck.isInstanceOf(XSDSchemaDirective.class, (Object)eObject);
        XSDSchemaDirective xsdDerivative = (XSDSchemaDirective)eObject;
        XSDSchema schema = xsdDerivative.getResolvedSchema();
        if (schema != null && (schemaResource = schema.eResource()) != null && (modelResource = ModelerCore.getModelWorkspace().findModelResource(schemaResource)) != null) {
            try {
                return modelResource.getUuid();
            }
            catch (Exception e) {
                XsdPlugin.Util.log((Throwable)e);
            }
        }
        return null;
    }

    public String getPrimaryMetaModelUri(EObject eObject) {
        return "http://www.eclipse.org/xsd/2002/XSD";
    }

    public void setModelLocation(EObject eObject, URI uri) {
        CoreArgCheck.isInstanceOf(XSDSchemaDirective.class, (Object)eObject);
        CoreArgCheck.isNotNull((Object)uri);
        XSDSchemaDirective derivative = (XSDSchemaDirective)eObject;
        Resource eResource = derivative.eResource();
        if (eResource != null) {
            URI eResourceURI = eResource.getURI();
            URI importURI = uri;
            String uriString = URI.decode((String)importURI.toString());
            if (uri.isFile()) {
                URI deresolvedURI;
                boolean deresolve;
                boolean bl = deresolve = eResourceURI != null && !eResourceURI.isRelative() && eResourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(eResourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                derivative.setSchemaLocation(importURI.toString());
            } else {
                derivative.setSchemaLocation(uriString);
            }
        }
    }
}

