/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd.aspects.sql;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDSchema;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.metamodel.aspect.AbstractMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlModelAspect;
import org.teiid.designer.metamodels.core.ModelType;

public class XsdSchemaAspect
extends AbstractMetamodelAspect
implements SqlModelAspect {
    public static final String ASPECT_ID = "sqlAspect";
    private static final int MAX_SET_SIZE_EDEFAULT = 100;

    protected XsdSchemaAspect(MetamodelEntity entity) {
        super.setMetamodelEntity(entity);
        super.setID(ASPECT_ID);
    }

    public String getName(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSchema.class, (Object)eObject);
        Resource resource = eObject.eResource();
        if (resource != null && resource.getURI() != null) {
            URI resourceURI = resource.getURI();
            if (resourceURI.isFile()) {
                String extension = resourceURI.fileExtension();
                String modelNameWithExtension = resourceURI.lastSegment();
                if (extension != null && extension.length() > 0) {
                    int endIndex = modelNameWithExtension.indexOf(extension) - 1;
                    return endIndex > 0 ? modelNameWithExtension.substring(0, endIndex) : modelNameWithExtension;
                }
            } else {
                String uriString = URI.decode((String)resourceURI.toString());
                if ("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance".equals(uriString)) {
                    return "builtInDataTypes";
                }
                if ("http://www.w3.org/2001/XMLSchema".equals(uriString)) {
                    return "builtInDataTypes";
                }
            }
        }
        return "";
    }

    public String getNameInSource(EObject eObject) {
        return this.getName(eObject);
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'A';
    }

    public boolean isQueryable(EObject eObject) {
        return false;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    public String getFullName(EObject eObject) {
        return this.getName(eObject);
    }

    public Object getObjectID(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSchema.class, (Object)eObject);
        Object object = super.getObjectID(eObject);
        return object;
    }

    public Object getParentObjectID(EObject eObject) {
        return null;
    }

    public IPath getPath(EObject eObject) {
        return new Path(this.getName(eObject));
    }

    public int getMaxSetSize(EObject eObject) {
        return 100;
    }

    public int getModelType(EObject eObject) {
        return ModelType.TYPE;
    }

    public String getPrimaryMetamodelUri(EObject eObject) {
        return "http://www.eclipse.org/xsd/2002/XSD";
    }

    public boolean isVisible(EObject eObject) {
        return false;
    }

    public boolean supportsDistinct(EObject eObject) {
        return false;
    }

    public boolean supportsJoin(EObject eObject) {
        return false;
    }

    public boolean supportsOrderBy(EObject eObject) {
        return false;
    }

    public boolean supportsOuterJoin(EObject eObject) {
        return false;
    }

    public boolean supportsWhereAll(EObject eObject) {
        return false;
    }
}

