/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd.aspects.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AbstractMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.types.DatatypeConstants;
import org.teiid.designer.core.types.EnterpriseDatatypeInfo;
import org.teiid.designer.metamodels.xsd.XsdPlugin;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.type.IDataTypeManagerService;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XsdSimpleTypeDefinitionAspect
extends AbstractMetamodelAspect
implements SqlDatatypeAspect {
    public static final String ASPECT_ID = "sqlAspect";
    public static final URI BUILTIN_DATATYPES_URI = URI.createURI((String)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
    public static final String UUID_ATTRIBUTE_NAME = "UUID";
    public static final String RUNTIME_TYPE_ATTRIBUTE_NAME = "runtimeDataType";
    public static final String RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME = "runtimeDataTypeFixed";
    protected static final String ANY_SIMPLE_TYPE_URI_STRING = String.valueOf(ModelerCore.XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI) + "#//anySimpleType;XSDSimpleTypeDefinition=1";
    protected static final URI ANY_SIMPLE_TYPE_URI = URI.createURI((String)ANY_SIMPLE_TYPE_URI_STRING);
    private Map mmDatatypeMap;
    private EObject anySimpleType;

    public XsdSimpleTypeDefinitionAspect(MetamodelEntity entity) {
        super.setMetamodelEntity(entity);
        super.setID(ASPECT_ID);
        this.init();
    }

    private void init() {
        this.mmDatatypeMap = new HashMap();
        this.initializeMmDatatypeMap();
    }

    public String getName(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        return entity.getName();
    }

    public String getNameInSource(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        return entity.getName();
    }

    public Object getObjectID(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        EObject type = this.getMmType(eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
        XsdUtil.checkForEnterpriseConversion(entity);
        String uuidString = null;
        if (this.isEnterpriseDataType((EObject)entity)) {
            uuidString = this.getEnterpriseAttributeValue(entity, UUID_ATTRIBUTE_NAME);
        }
        if (!CoreStringUtil.isEmpty(uuidString)) {
            try {
                return IDGenerator.getInstance().stringToObject(uuidString, "mmuuid");
            }
            catch (InvalidIDException e) {
                String msg = XsdPlugin.Util.getString("XsdSimpleTypeDefinitionAspect.error_parsing_objectid", (Object)uuidString);
                XsdPlugin.Util.log(4, (Throwable)e, msg);
            }
        }
        return super.getObjectID(eObject);
    }

    public Object getParentObjectID(EObject eObject) {
        return null;
    }

    public IPath getPath(EObject eObject) {
        return null;
    }

    public String getFullName(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        return this.getURI(entity);
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'M';
    }

    public boolean isQueryable(EObject eObject) {
        return !(eObject instanceof XSDSimpleTypeDefinition) || eObject.eContainer() instanceof XSDSchema;
    }

    public int getLength(EObject eObject) {
        return 0;
    }

    public int getPrecisionLength(EObject eObject) {
        return 0;
    }

    public int getRadix(EObject eObject) {
        return 0;
    }

    public int getScale(EObject eObject) {
        return 0;
    }

    public boolean isAutoIncrement(EObject eObject) {
        return false;
    }

    public boolean isCaseSensitive(EObject eObject) {
        return false;
    }

    public boolean isSigned(EObject eObject) {
        return false;
    }

    public short getType(EObject eObject) {
        return 1;
    }

    public short getSearchType(EObject eObject) {
        return 0;
    }

    public short getNullType(EObject eObject) {
        return 0;
    }

    public String getUuidString(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        EObject type = this.getMmType(eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
        XsdUtil.checkForEnterpriseConversion(entity);
        String uuid = null;
        if (this.isEnterpriseDataType((EObject)entity)) {
            uuid = this.getEnterpriseAttributeValue(entity, UUID_ATTRIBUTE_NAME);
        }
        return uuid;
    }

    public String getJavaClassName(EObject eObject) {
        IDataTypeManagerService service;
        Class javaClassName;
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        String runtimeTypeName = this.getRuntimeTypeName((EObject)entity);
        if (runtimeTypeName != null && (javaClassName = (service = ModelerCore.getTeiidDataTypeManagerService()).getDataTypeClass(runtimeTypeName)) != null) {
            return javaClassName.getName();
        }
        return Object.class.getName();
    }

    public String getRuntimeTypeName(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        if (this.isURType(eObject)) {
            return "object";
        }
        EObject type = this.getMmType(eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
        XsdUtil.checkForEnterpriseConversion(entity);
        String runtimeType = null;
        if (this.isEnterpriseDataType((EObject)entity)) {
            runtimeType = this.getEnterpriseAttributeValue(entity, RUNTIME_TYPE_ATTRIBUTE_NAME);
        }
        if (runtimeType == null || runtimeType.length() == 0) {
            entity = (XSDSimpleTypeDefinition)this.getBasetype(eObject);
            runtimeType = entity == null ? "object" : this.getRuntimeTypeName((EObject)entity);
        }
        return runtimeType;
    }

    public Boolean getRuntimeTypeFixed(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        Boolean fixed = Boolean.FALSE;
        if (!this.isURType(eObject)) {
            EObject type = this.getMmType(eObject);
            XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
            XsdUtil.checkForEnterpriseConversion(entity);
            String runtimeTypeFixedValue = null;
            if (this.isEnterpriseDataType((EObject)entity)) {
                runtimeTypeFixedValue = this.getEnterpriseAttributeValue(entity, RUNTIME_TYPE_ATTRIBUTE_NAME);
            }
            if (runtimeTypeFixedValue == null && (entity = (XSDSimpleTypeDefinition)this.getBasetype(eObject)) != null) {
                fixed = this.getRuntimeTypeFixed((EObject)entity);
            }
        }
        return fixed;
    }

    public String getDatatypeID(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        return this.getURI(entity);
    }

    public String getBasetypeID(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition basetype = (XSDSimpleTypeDefinition)this.getBasetype(eObject);
        if (basetype != null) {
            return this.getURI(basetype);
        }
        return null;
    }

    public Object getBasetype(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)eObject;
        XSDSimpleTypeDefinition basetype = null;
        XSDVariety variety = type.getVariety();
        if (variety == XSDVariety.LIST_LITERAL) {
            basetype = type.getItemTypeDefinition();
        } else if (variety == XSDVariety.UNION_LITERAL) {
            basetype = (XSDSimpleTypeDefinition)this.getAnySimpleType();
        } else {
            basetype = type.getBaseTypeDefinition();
            if (basetype != null && this.isPrimitiveType((EObject)type) && this.isPrimitiveType((EObject)basetype) && "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance".equals(type.getTargetNamespace())) {
                basetype = (XSDSimpleTypeDefinition)this.getAnySimpleType();
            }
        }
        if (basetype != null && basetype.getName() == null) {
            basetype = (XSDSimpleTypeDefinition)this.getAnySimpleType();
        }
        return basetype;
    }

    private boolean isPrimitiveType(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)eObject;
        return this.isBuiltInDatatype((EObject)type) && DatatypeConstants.getPrimitivedBuiltInTypeNames().contains(type.getName());
    }

    public Object getPrimitiveType(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        EObject simpleType = eObject;
        EObject baseType = null;
        while (simpleType != null) {
            baseType = (EObject)this.getBasetype(simpleType);
            if (baseType == null) break;
            if (XSDConstants.isURType((XSDTypeDefinition)((XSDSimpleTypeDefinition)baseType))) {
                return simpleType;
            }
            if (simpleType == baseType) break;
            simpleType = baseType;
        }
        return null;
    }

    public String getPrimitiveTypeID(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition primitiveType = (XSDSimpleTypeDefinition)this.getPrimitiveType(eObject);
        if (primitiveType != null) {
            return this.getURI(primitiveType);
        }
        return null;
    }

    public Map getEnterpriseExtensionsMap(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        EObject type = this.getMmType(eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
        XsdUtil.checkForEnterpriseConversion(entity);
        return this.getEnterpriseAttributes(entity);
    }

    public String getDescription(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        EObject type = this.getMmType(eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
        XSDAnnotation annotation = entity.getAnnotation();
        if (annotation != null) {
            for (Element userInfo : annotation.getUserInformation()) {
                String value = XsdUtil.getChildText(userInfo);
                if (value == null) continue;
                return value;
            }
        }
        return "";
    }

    public boolean isBuiltInDatatype(EObject eObject) {
        URI eProxyURI;
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        if (XSDConstants.isURType((XSDTypeDefinition)entity)) {
            return true;
        }
        if (entity.eIsProxy() && (eProxyURI = ((InternalEObject)eObject).eProxyURI()) != null) {
            String proxyURIString = eProxyURI.toString();
            return proxyURIString.startsWith("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance") || proxyURIString.startsWith("http://www.w3.org/2001/XMLSchema") || proxyURIString.startsWith("http://www.w3.org/2000/10/XMLSchema") || proxyURIString.startsWith("http://www.w3.org/1999/XMLSchema");
        }
        String typeName = entity.getName();
        if (typeName == null || this.mmDatatypeMap.get(typeName.toLowerCase()) == null) {
            return false;
        }
        String namespaceUri = entity.getTargetNamespace();
        if ("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance".equals(namespaceUri)) {
            return true;
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(namespaceUri)) {
            return true;
        }
        if ("http://www.w3.org/2000/10/XMLSchema".equals(namespaceUri)) {
            return true;
        }
        return "http://www.w3.org/1999/XMLSchema".equals(namespaceUri);
    }

    public boolean isComplexDatatype(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        return false;
    }

    public boolean isSimpleDatatype(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        return true;
    }

    public boolean isURType(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        return XSDConstants.isURType((XSDTypeDefinition)entity);
    }

    public short getVarietyType(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        XSDVariety variety = entity.getVariety();
        if (variety.getValue() == 0) {
            return 0;
        }
        if (variety.getValue() == 1) {
            return 1;
        }
        if (variety.getValue() == 2) {
            return 2;
        }
        return 0;
    }

    public List getVarietyProps(EObject eObject) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        XSDVariety variety = entity.getVariety();
        ArrayList<String> varietyProps = new ArrayList<String>();
        if (variety.getValue() == 0) {
            XSDSimpleTypeDefinition primitiveType = entity.getPrimitiveTypeDefinition();
            if (primitiveType != null) {
                varietyProps.add(this.getURI(primitiveType));
            }
        } else if (variety.getValue() == 1) {
            XSDSimpleTypeDefinition itemType = entity.getItemTypeDefinition();
            if (itemType != null) {
                varietyProps.add(this.getURI(itemType));
            }
        } else if (variety.getValue() == 2) {
            for (XSDSimpleTypeDefinition memberType : entity.getMemberTypeDefinitions()) {
                if (memberType == null) continue;
                varietyProps.add(this.getURI(memberType));
            }
        }
        return varietyProps;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    public boolean isDatatypeFeature(EObject eObject, EStructuralFeature eFeature) {
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)eObject);
        EObjectImpl eObjectImpl = super.getEObjectImpl(eObject);
        if (eObjectImpl != null) {
            switch (eObjectImpl.eDerivedStructuralFeatureID(eFeature)) {
                case 26: {
                    return true;
                }
                case 28: {
                    return true;
                }
                case 29: {
                    return true;
                }
                case 30: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEnterpriseDataType(EObject type) {
        Map enterpriseAttributes;
        CoreArgCheck.isNotNull((Object)type);
        this.CoreArgCheckIsResolved(type);
        boolean success = false;
        if (type instanceof XSDSimpleTypeDefinition && !(enterpriseAttributes = this.getEnterpriseAttributes((XSDSimpleTypeDefinition)type)).isEmpty()) {
            success = enterpriseAttributes.get(UUID_ATTRIBUTE_NAME) != null && enterpriseAttributes.get(RUNTIME_TYPE_ATTRIBUTE_NAME) != null && enterpriseAttributes.get(RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME) != null;
        }
        return success;
    }

    public void setEnterpriseDataAttributes(XSDSimpleTypeDefinition type, EnterpriseDatatypeInfo edtInfo) {
        CoreArgCheck.isNotNull((Object)type);
        this.CoreArgCheckIsResolved((EObject)type);
        if (edtInfo.isValid()) {
            Boolean runtimeTypeFixed;
            String runtimeType;
            Attr attribute;
            XsdUtil.setAsEnterpriseSchema(type.getSchema());
            Element element = type.getElement();
            Document doc = element.getOwnerDocument();
            boolean isModified = false;
            String uuid = edtInfo.getUuid();
            if (uuid != null) {
                attribute = doc.createAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", UUID_ATTRIBUTE_NAME);
                attribute.setValue(uuid);
                attribute.setPrefix("mmedt");
                type.getElement().setAttributeNode(attribute);
                isModified = true;
            }
            if ((runtimeType = edtInfo.getRuntimeType()) != null) {
                attribute = doc.createAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", RUNTIME_TYPE_ATTRIBUTE_NAME);
                attribute.setValue(runtimeType);
                attribute.setPrefix("mmedt");
                type.getElement().setAttributeNode(attribute);
                isModified = true;
            }
            if ((runtimeTypeFixed = edtInfo.getRuntimeTypeFixed()) != null) {
                attribute = doc.createAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME);
                attribute.setValue(runtimeTypeFixed.toString());
                attribute.setPrefix("mmedt");
                type.getElement().setAttributeNode(attribute);
                isModified = true;
            }
            type.eResource().setModified(isModified);
        }
    }

    public void unSetEnterpriseDataAttributes(XSDSimpleTypeDefinition type) {
        CoreArgCheck.isNotNull((Object)type);
        this.CoreArgCheckIsResolved((EObject)type);
        Element element = type.getElement();
        element.removeAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", UUID_ATTRIBUTE_NAME);
        element.removeAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", RUNTIME_TYPE_ATTRIBUTE_NAME);
        element.removeAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME);
        if (!this.containsEnterpriseDatatypes(type.getSchema())) {
            XsdUtil.unsetAsEnterpriseSchema(type.getSchema());
        }
        type.eResource().setModified(true);
    }

    public EnterpriseDatatypeInfo getEnterpriseDatatypeInfo(XSDSimpleTypeDefinition type) {
        CoreArgCheck.isNotNull((Object)type);
        this.CoreArgCheckIsResolved((EObject)type);
        XsdUtil.checkForEnterpriseConversion(type);
        EnterpriseDatatypeInfo edtInfo = new EnterpriseDatatypeInfo();
        if (XsdUtil.isEnterpriseSchema(type.getSchema()) && this.isEnterpriseDataType((EObject)type)) {
            Map attributes = this.getEnterpriseAttributes(type);
            edtInfo.setUuid((String)attributes.get(UUID_ATTRIBUTE_NAME));
            edtInfo.setRuntimeType((String)attributes.get(RUNTIME_TYPE_ATTRIBUTE_NAME));
            String runtimeTypeFixed = (String)attributes.get(RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME);
            edtInfo.setRuntimeTypeFixed(Boolean.valueOf(runtimeTypeFixed));
        }
        return edtInfo;
    }

    public void convertEnterpriseDatatype(XSDSimpleTypeDefinition type) {
        EnterpriseDatatypeInfo edtInfo;
        CoreArgCheck.isNotNull((Object)type);
        this.CoreArgCheckIsResolved((EObject)type);
        if (!this.isEnterpriseDataType((EObject)type) && (edtInfo = this.getEnterpriseAttributesFromAppInfo(type)).isValid()) {
            this.setEnterpriseDataAttributes(type, edtInfo);
            this.removeEnterpriseAttributesFromAppInfo(type);
            type.eNotify((Notification)new ENotificationImpl((InternalEObject)type, 3, null, null, (Object)type));
        }
    }

    public void setBasetype(XSDSimpleTypeDefinition simpleType, XSDSimpleTypeDefinition baseType) {
        CoreArgCheck.isNotNull((Object)simpleType);
        CoreArgCheck.isNotNull((Object)baseType);
        this.CoreArgCheckIsResolved((EObject)simpleType);
        this.CoreArgCheckIsResolved((EObject)baseType);
        XSDSchema schema = simpleType.getSchema();
        if (simpleType.eResource() != baseType.eResource() && !XSDConstants.isSchemaForSchemaNamespace((String)baseType.getTargetNamespace()) && !XsdUtil.containsImport(schema, baseType.getTargetNamespace())) {
            XsdUtil.addImport(simpleType, baseType);
        }
        String oldReferencedNamespace = simpleType.getBaseTypeDefinition().getTargetNamespace();
        simpleType.setBaseTypeDefinition(baseType);
        if (oldReferencedNamespace != null && !oldReferencedNamespace.equals(schema.getTargetNamespace()) && !XsdUtil.containsReferenceToNamespace(schema, oldReferencedNamespace)) {
            XsdUtil.removeNamespaceRef(schema, oldReferencedNamespace);
            if (XsdUtil.containsImport(schema, oldReferencedNamespace)) {
                XsdUtil.removeImport(schema, oldReferencedNamespace);
            }
        }
    }

    private void CoreArgCheckIsResolved(EObject e) {
        if (e.eIsProxy()) {
            throw new IllegalArgumentException(XsdPlugin.Util.getString("XsdSimpleTypeDefinitionAspect.Error_EObject_can_not_be_a_proxy", (Object)e.toString()));
        }
    }

    private void initializeMmDatatypeMap() {
        try {
            Resource resource = null;
            List resourceSets = ModelerCore.getExternalResourceSets();
            for (ResourceSet resourceSet : resourceSets) {
                resource = resourceSet.getResource(BUILTIN_DATATYPES_URI, false);
                if (resource != null) break;
            }
            if (resource == null) {
                Object[] params = new Object[]{BUILTIN_DATATYPES_URI};
                String msg = XsdPlugin.Util.getString("XsdSimpleTypeDefinitionAspect.Error_obtain_the_built-in_datatypes_resource_from_the_container_using_URI_1", params);
                XsdPlugin.Util.log(4, msg);
            }
            if (resource != null) {
                for (EObject eObject2 : resource.getContents()) {
                    if (eObject2 == null || !(eObject2 instanceof XSDSchema)) continue;
                    for (EObject eObject2 : eObject2.eContents()) {
                        if (eObject2 == null || !(eObject2 instanceof XSDSimpleTypeDefinition)) continue;
                        XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)eObject2;
                        String typeName = type.getName();
                        this.mmDatatypeMap.put(typeName.toLowerCase(), type);
                    }
                }
            }
        }
        catch (Throwable e) {
            Object[] params = new Object[]{BUILTIN_DATATYPES_URI};
            String msg = XsdPlugin.Util.getString("XsdSimpleTypeDefinitionAspect.Error_obtain_the_built-in_datatypes_resource_from_the_container_using_URI_1", params);
            XsdPlugin.Util.log(4, e, msg);
        }
    }

    private EObject getAnySimpleType() {
        if (this.anySimpleType == null) {
            this.anySimpleType = XSDSchemaImpl.getGlobalResourceSet().getEObject(ANY_SIMPLE_TYPE_URI, true);
        }
        return this.anySimpleType;
    }

    private EObject getMmType(EObject eObject) {
        if (this.isURType(eObject)) {
            return eObject;
        }
        if (this.isBuiltInDatatype(eObject)) {
            XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)eObject;
            String typeName = type.getName();
            EObject mmdt = (EObject)this.mmDatatypeMap.get(typeName.toLowerCase());
            return mmdt;
        }
        return eObject;
    }

    private boolean containsEnterpriseDatatypes(XSDSchema schema) {
        boolean success = false;
        EList contents = schema.getContents();
        for (Object o : new ArrayList(contents)) {
            XSDSimpleTypeDefinition sdt;
            if (!(o instanceof XSDSimpleTypeDefinition) || !this.isEnterpriseDataType((EObject)(sdt = (XSDSimpleTypeDefinition)o))) continue;
            success = true;
            break;
        }
        return success;
    }

    public EnterpriseDatatypeInfo getEnterpriseAttributesFromAppInfo(XSDSimpleTypeDefinition type) {
        CoreArgCheck.isNotNull((Object)type);
        EnterpriseDatatypeInfo edtInfo = new EnterpriseDatatypeInfo();
        XSDAnnotation annotation = type.getAnnotation();
        if (annotation != null) {
            for (Element appInfo : annotation.getApplicationInformation()) {
                if (appInfo.getAttributes() == null || appInfo.getAttributes().getLength() <= 0) continue;
                edtInfo.setUuid(appInfo.getAttribute(UUID_ATTRIBUTE_NAME));
                edtInfo.setRuntimeType(appInfo.getAttribute(RUNTIME_TYPE_ATTRIBUTE_NAME));
                edtInfo.setRuntimeTypeFixed(Boolean.FALSE);
            }
        }
        return edtInfo;
    }

    private void removeEnterpriseAttributesFromAppInfo(XSDSimpleTypeDefinition type) {
        CoreArgCheck.isNotNull((Object)type);
        XSDAnnotation annotation = type.getAnnotation();
        if (annotation != null) {
            Iterator it = annotation.getApplicationInformation().iterator();
            while (it.hasNext()) {
                Element appInfo = (Element)it.next();
                if (appInfo == null || appInfo.getAttributes() == null || appInfo.getAttributes().getLength() <= 0) continue;
                appInfo.removeAttribute(UUID_ATTRIBUTE_NAME);
                appInfo.removeAttribute(RUNTIME_TYPE_ATTRIBUTE_NAME);
                if (appInfo.getAttributes().getLength() != 0) continue;
                it.remove();
            }
            if (annotation.getApplicationInformation().size() == 0) {
                annotation.getApplicationInformation().clear();
            }
        }
    }

    private Map getEnterpriseAttributes(XSDSimpleTypeDefinition type) {
        CoreArgCheck.isNotNull((Object)type);
        HashMap<String, String> results = new HashMap<String, String>();
        Element typeElement = type.getElement();
        if (typeElement != null) {
            if (typeElement.getAttributes() == null || typeElement.getAttributes().getLength() == 0) {
                return Collections.EMPTY_MAP;
            }
            results.put(UUID_ATTRIBUTE_NAME, this.getEnterpriseAttributeValue(type, UUID_ATTRIBUTE_NAME));
            results.put(RUNTIME_TYPE_ATTRIBUTE_NAME, this.getEnterpriseAttributeValue(type, RUNTIME_TYPE_ATTRIBUTE_NAME));
            results.put(RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME, this.getEnterpriseAttributeValue(type, RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME));
        }
        return results;
    }

    private String getEnterpriseAttributeValue(XSDSimpleTypeDefinition type, String name) {
        Attr attrNS = type.getElement().getAttributeNodeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", name);
        return attrNS != null ? attrNS.getValue() : null;
    }

    private String getURI(XSDSimpleTypeDefinition type) {
        String theName;
        String theTargetNamespace;
        CoreArgCheck.isNotNull((Object)type);
        XSDSchema xsdSchema = type.getSchema();
        String string = theTargetNamespace = xsdSchema == null ? type.getTargetNamespace() : xsdSchema.getTargetNamespace();
        if (theTargetNamespace == null) {
            theTargetNamespace = "";
        }
        if (theTargetNamespace.equals("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance")) {
            String typeName = type.getName();
            if (!DatatypeConstants.getMetaMatrixExtendedBuiltInTypeNames().contains(typeName)) {
                theTargetNamespace = "http://www.w3.org/2001/XMLSchema";
            }
        }
        if ((theName = type.getName()) == null) {
            theName = type.getAliasName();
        }
        return String.valueOf(theTargetNamespace) + "#" + theName;
    }
}

