/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd.aspects.validation.rules;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDConstants;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.xsd.XsdPlugin;

public class BaseTypeRule
implements StructuralFeatureValidationRule {
    private int featureID;

    public BaseTypeRule(int featureID) {
        this.featureID = featureID;
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (eObject == null || !(eObject instanceof XSDSimpleTypeDefinition)) {
            return;
        }
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        if (value == null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, XsdPlugin.Util.getString("BaseTypeRule.The_basetype_may_not_be_null_1", new Object[0]));
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        if (!(value instanceof XSDSimpleTypeDefinition)) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, XsdPlugin.Util.getString("BaseTypeRule.The_basetype_must_be_a_simple_type_definition_2", new Object[0]));
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        if (eObject == value) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, XsdPlugin.Util.getString("BaseTypeRule.The_datatype_cannot_have_itself_as_its_basetype_1", new Object[0]));
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        XSDSimpleTypeDefinition datatype = (XSDSimpleTypeDefinition)eObject;
        if (this.hasCircularDependency(datatype)) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, XsdPlugin.Util.getString("BaseTypeRule.Cannot_have_a_circular_dependency_in_the_datatype_hierarchy_2", new Object[0]));
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        context.addResult((ValidationResult)result);
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasCircularDependency(XSDSimpleTypeDefinition datatype) {
        if (datatype == null) {
            return false;
        }
        typesInHierarchy = new ArrayList<BaseTypeRule>();
        typesInHierarchy.add(this);
        baseTypeDefn = datatype.getBaseTypeDefinition();
        if (!this.equals(baseTypeDefn)) ** GOTO lbl16
        return true;
lbl-1000:
        // 1 sources

        {
            if (XSDConstants.isURType((XSDTypeDefinition)baseTypeDefn)) {
                return false;
            }
            if (typesInHierarchy.contains(baseTypeDefn)) {
                return true;
            }
            typesInHierarchy.add((BaseTypeRule)baseTypeDefn);
            baseTypeDefn = baseTypeDefn.getBaseTypeDefinition();
lbl16:
            // 2 sources

            ** while (baseTypeDefn != null && baseTypeDefn.getName() != null)
        }
lbl17:
        // 1 sources

        return false;
    }
}

