/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xsd.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.common.xsd.XsdHeader;
import org.teiid.designer.common.xsd.XsdHeaderReader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ResourceValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.xsd.XsdPlugin;

public class XsdResourceValidationRule
implements ResourceValidationRule {
    public void validate(Resource resource, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)context);
        if (!(resource instanceof XSDResourceImpl)) {
            return;
        }
        XSDSchema schema = ((XSDResourceImpl)resource).getSchema();
        if (schema != null) {
            File f;
            ValidationResultImpl result = new ValidationResultImpl((Object)schema);
            URI uri = resource.getURI();
            if (uri.isFile() && (f = new File(uri.toFileString())).exists()) {
                try {
                    XsdHeader header = XsdHeaderReader.readHeader((File)f);
                    ArrayList<String> declarations = new ArrayList<String>();
                    if (header != null) {
                        declarations.addAll(Arrays.asList(header.getImportSchemaLocations()));
                        declarations.addAll(Arrays.asList(header.getIncludeSchemaLocations()));
                        for (String location : declarations) {
                            String uriString;
                            File importFile;
                            if (CoreStringUtil.isEmpty((String)location) || location.startsWith("http")) continue;
                            URI baseUri = URI.createFileURI((String)f.getAbsolutePath());
                            URI locationUri = URI.createURI((String)location);
                            if (baseUri.isHierarchical() && !baseUri.isRelative() && locationUri.isRelative()) {
                                locationUri = locationUri.resolve(baseUri);
                            }
                            if ((importFile = new File(uriString = locationUri.isFile() ? locationUri.toFileString() : URI.decode((String)locationUri.toString()))).exists()) continue;
                            String msg = XsdPlugin.Util.getString("XsdResourceValidationRule.Schema_directive_resolves_to_nonexistent_file", (Object)location);
                            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                            result.addProblem((ValidationProblem)problem);
                        }
                    }
                }
                catch (Throwable e) {
                    ModelerCore.Util.log(e);
                }
            }
            if (result.hasProblems()) {
                context.addResult((ValidationResult)result);
            }
        }
    }
}

