/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.udf.ui;

import java.util.EventObject;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.udf.UdfManager;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public final class UdfUiPlugin
extends AbstractUiPlugin
implements EventObjectListener {
    public static final String PLUGIN_ID = UdfUiPlugin.class.getPackage().getName();
    private static final String I18N_NAME = String.valueOf(PLUGIN_ID) + ".i18n";
    static final PluginUtil UTIL = new PluginUtilImpl(PLUGIN_ID, I18N_NAME, ResourceBundle.getBundle(I18N_NAME));
    private static UdfUiPlugin plugin;

    static UdfUiPlugin getInstance() {
        return plugin;
    }

    protected ActionService createActionService(IWorkbenchPage page) {
        return null;
    }

    public PluginUtil getPluginUtil() {
        return UTIL;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ((PluginUtilImpl)UTIL).initializePlatformLogger((Plugin)this);
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, (EventObjectListener)this);
        }
        catch (EventSourceException e) {
            ((PluginUtilImpl)UTIL).log(4, (Throwable)e, e.getMessage());
        }
    }

    public void stop(BundleContext context) throws Exception {
        UiPlugin.getDefault().getEventBroker().removeListener(ModelResourceEvent.class, (EventObjectListener)this);
        super.stop(context);
    }

    public void processEvent(EventObject obj) {
        block22: {
            ModelResourceEvent event = (ModelResourceEvent)obj;
            if (ModelIdentifier.isFunctionModel((ModelResource)event.getModelResource())) {
                try {
                    IFile file = (IFile)event.getModelResource().getCorrespondingResource();
                    IPath path = ModelUtil.getLocation((IResource)file);
                    if (path != null) {
                        if (event.getType() == 6 || event.getType() == 7) {
                            if (!event.getModelResource().isOpen()) {
                                event.getModelResource().open((IProgressMonitor)new NullProgressMonitor());
                            }
                            this.registerFunctionModel(event.getModelResource(), false);
                        } else if (event.getType() == 8) {
                            this.registerFunctionModel(event.getModelResource(), true);
                        } else if (event.getType() == 4) {
                            this.registerFunctionModel(event.getModelResource(), true);
                            this.registerFunctionModel(event.getModelResource(), false);
                        }
                        break block22;
                    }
                    UTIL.log(4, "Error registering function model: " + event.getModelResource().getItemName());
                }
                catch (Exception ex) {
                    UTIL.log((Throwable)ex);
                }
            } else if (ModelIdentifier.isRelationalSourceModel((ModelResource)event.getModelResource()) || ModelIdentifier.isRelationalViewModel((ModelResource)event.getModelResource())) {
                try {
                    IFile file = (IFile)event.getModelResource().getCorrespondingResource();
                    IPath path = ModelUtil.getLocation((IResource)file);
                    if (path != null) {
                        if (event.getType() == 6 || event.getType() == 7) {
                            if (!event.getModelResource().isOpen()) {
                                event.getModelResource().open((IProgressMonitor)new NullProgressMonitor());
                            }
                            this.notifySourceModelChanged(event.getModelResource(), false);
                        } else if (event.getType() == 8) {
                            this.notifySourceModelChanged(event.getModelResource(), true);
                        } else if (event.getType() == 4) {
                            this.notifySourceModelChanged(event.getModelResource(), false);
                        }
                    } else {
                        UTIL.log(4, "Error registering function model: " + event.getModelResource().getItemName());
                    }
                }
                catch (Exception ex) {
                    UTIL.log((Throwable)ex);
                }
            }
        }
    }

    private void registerFunctionModel(final ModelResource modelResource, final boolean isDelete) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    UdfManager.getInstance().registerFunctionModel(modelResource, isDelete);
                }
                catch (Exception e) {
                    UTIL.log((Throwable)e);
                }
            }
        });
    }

    private void notifySourceModelChanged(final ModelResource modelResource, final boolean isDelete) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    UdfManager.getInstance().notifySourceModelChanged(modelResource, isDelete);
                }
                catch (Exception e) {
                    UTIL.log((Throwable)e);
                }
            }
        });
    }
}

