/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.udf.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.function.FunctionParameter;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.DatatypeSelectionDialog;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class SetFunctionParameterTypeModelingAction
extends SortableSelectionAction {
    public SetFunctionParameterTypeModelingAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/BuiltinDatatype.gif"));
    }

    public boolean isValidSelection(ISelection selection) {
        boolean isValid = false;
        if (SelectionUtilities.isAllEObjects((ISelection)selection)) {
            if (!isValid) {
                isValid = this.allSelectedAreFunctionParameters(selection);
            }
            if (isValid) {
                isValid = this.allSelectedHaveEditorsOpen(selection);
            }
        }
        return isValid;
    }

    public void run() {
        ArrayList selectedEObjects = new ArrayList(SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()));
        if (!selectedEObjects.isEmpty()) {
            this.showDialog(selectedEObjects);
        }
    }

    public boolean isApplicable(ISelection selection) {
        return this.isValidSelection(selection);
    }

    private boolean allSelectedAreFunctionParameters(ISelection selection) {
        boolean result = true;
        Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)selection).iterator();
        EObject nextEObj = null;
        while (iter.hasNext() && result) {
            nextEObj = (EObject)iter.next();
            if (ModelObjectUtilities.isReadOnly((EObject)nextEObj)) {
                result = false;
            }
            if (!result || nextEObj instanceof FunctionParameter) continue;
            result = false;
        }
        return result;
    }

    private boolean allSelectedHaveEditorsOpen(ISelection selection) {
        boolean result = true;
        Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)selection).iterator();
        EObject nextEObj = null;
        while (iter.hasNext() && result) {
            nextEObj = (EObject)iter.next();
            result = ModelEditorManager.isOpen((EObject)nextEObj);
        }
        return result;
    }

    protected void showDialog(Collection theEObjects) {
        int length = 0;
        EObject eObj = (EObject)theEObjects.iterator().next();
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        DatatypeSelectionDialog dialog = new DatatypeSelectionDialog(shell, eObj);
        if (theEObjects.size() > 1) {
            dialog.setMultipleObjects(true);
        } else {
            dialog.setMultipleObjects(false);
        }
        FunctionParameter param = (FunctionParameter)eObj;
        String originalValue = param.getType();
        Object[] selection = new Object[]{originalValue};
        dialog.setInitialSelections(selection);
        dialog.setEditLength(false);
        int status = dialog.open();
        if (status == 0) {
            Object newType = null;
            Object[] result = dialog.getResult();
            if (result.length > 0) {
                newType = result[0];
            }
            this.setDatatypesForFunctionParameters(theEObjects, (EObject)newType, length, dialog.overrideAllLengths());
        }
    }

    private void setDatatypesForFunctionParameters(Collection params, EObject datatype, int length, boolean overrideAllLengths) {
        FunctionParameter nextParam = null;
        Iterator iter = params.iterator();
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Set Datatype For Function Parameters", (Object)((Object)this));
        boolean succeeded = false;
        try {
            while (iter.hasNext()) {
                nextParam = (FunctionParameter)iter.next();
                nextParam.setType(ModelerCore.getModelEditor().getName(datatype));
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }
}

