/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.adopters;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.fusesource.ide.projecttemplates.adopters.configurators.TemplateConfiguratorSupport;
import org.fusesource.ide.projecttemplates.adopters.creators.TemplateCreatorSupport;
import org.fusesource.ide.projecttemplates.adopters.util.CamelDSLType;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.NewProjectMetaData;

public abstract class AbstractProjectTemplate {
    public boolean supportsDSL(CamelDSLType type) {
        return true;
    }

    public final boolean create(IProject project, NewProjectMetaData projectMetaData, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean ok = this.getCreator(projectMetaData).create(project, projectMetaData, (IProgressMonitor)subMonitor.newChild(30));
        if (ok) {
            this.refreshProjectSync(project, monitor);
            ok = this.getConfigurator().configure(project, projectMetaData, (IProgressMonitor)subMonitor.newChild(30));
            this.refreshProjectSync(project, (IProgressMonitor)subMonitor.newChild(15));
            project.getFolder("bin").delete(true, (IProgressMonitor)subMonitor.newChild(5));
            project.getFolder("build").delete(true, (IProgressMonitor)subMonitor.newChild(5));
            this.refreshProjectSync(project, (IProgressMonitor)subMonitor.newChild(15));
        }
        return ok;
    }

    private void refreshProjectSync(IProject project, IProgressMonitor monitor) throws CoreException {
        project.refreshLocal(2, monitor);
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, monitor);
        }
        catch (InterruptedException | OperationCanceledException e) {
            ProjectTemplatesActivator.pluginLog().logError(e);
        }
    }

    public abstract TemplateConfiguratorSupport getConfigurator();

    public abstract TemplateCreatorSupport getCreator(NewProjectMetaData var1);
}

