/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.adopters.configurators;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.fusesource.ide.projecttemplates.adopters.configurators.TemplateConfiguratorSupport;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.NewProjectMetaData;
import org.fusesource.ide.projecttemplates.util.camel.CamelFacetDataModelProvider;

public class DefaultTemplateConfigurator
implements TemplateConfiguratorSupport {
    @Override
    public boolean configure(IProject project, NewProjectMetaData metadata, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DefaultTemplateConfigurator_ConfiguringJavaProjectMonitorMessage, (int)8);
        IProjectFacetVersion javaFacet = ProjectFacetsManager.getProjectFacet((String)"jst.java").getDefaultVersion();
        try {
            this.installFacet(project, "jst.java", javaFacet.getVersionString(), null, (IProgressMonitor)subMonitor.newChild(1));
            project.refreshLocal(2, (IProgressMonitor)subMonitor.newChild(1));
            this.installFacet(project, "jboss.m2", null, null, (IProgressMonitor)subMonitor.newChild(1));
            project.refreshLocal(2, (IProgressMonitor)subMonitor.newChild(1));
            this.installFacet(project, "jst.utility", null, null, (IProgressMonitor)subMonitor.newChild(1));
            project.refreshLocal(2, (IProgressMonitor)subMonitor.newChild(1));
            project.getFile(".classpath").delete(true, (IProgressMonitor)subMonitor.newChild(1));
            project.refreshLocal(2, (IProgressMonitor)subMonitor.newChild(1));
        }
        catch (CoreException ex) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            return false;
        }
        return true;
    }

    protected IDataModel getCamelFacetDataModel(NewProjectMetaData projectMetaData) {
        CamelFacetDataModelProvider dmProv = new CamelFacetDataModelProvider();
        dmProv.create();
        IDataModel dm = dmProv.getDataModel();
        dm.setStringProperty("ICamelFacetDataModelProperties.Content_Folder", "camelcontent");
        dm.setStringProperty("ICamelFacetDataModelProperties.Project.CamelDSL", projectMetaData.getDslType().toString());
        dm.setStringProperty("ICamelFacetDataModelProperties.Project.Version", projectMetaData.getCamelVersion());
        dm.setBooleanProperty("camel.project.structure.update", true);
        dm.setProperty("ICamelFacetDataModelProperties.Project.MetaData", (Object)projectMetaData);
        return dm;
    }

    protected void installFacet(IProject project, String facetName, String facetVersion, IDataModel config, IProgressMonitor monitor) throws CoreException {
        IFacetedProject fp = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)monitor);
        if (facetVersion != null) {
            fp.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)facetName).getVersion(facetVersion), (Object)config, monitor);
        } else {
            fp.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)facetName).getDefaultVersion(), (Object)config, monitor);
        }
    }
}

