/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.adopters.configurators;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.fusesource.ide.projecttemplates.adopters.configurators.DefaultTemplateConfigurator;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.NewProjectMetaData;
import org.fusesource.ide.projecttemplates.util.maven.MavenUtils;

public class MavenTemplateConfigurator
extends DefaultTemplateConfigurator {
    @Override
    public boolean configure(IProject project, NewProjectMetaData metadata, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MavenTemplateConfigurator_ConfiguringTemplatesMonitorMessage, (int)3);
        boolean ok = super.configure(project, metadata, (IProgressMonitor)subMonitor.newChild(1));
        if (ok) {
            ok = this.configureMavenNature(project, (IProgressMonitor)subMonitor.newChild(1));
        }
        if (ok) {
            ok = this.configurePomCamelVersion(project, metadata, (IProgressMonitor)subMonitor.newChild(1));
        }
        return ok;
    }

    protected boolean configureMavenNature(IProject project, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MavenTemplateConfigurator_ConfiguringMavenNatureMonitorMessage, (int)3);
        try {
            ResolverConfiguration configuration = new ResolverConfiguration();
            configuration.setResolveWorkspaceProjects(true);
            configuration.setSelectedProfiles("");
            this.waitAllJobsComplete((IProgressMonitor)subMonitor.newChild(1));
            IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
            configurationManager.enableMavenNature(project, configuration, (IProgressMonitor)subMonitor.newChild(1));
            configurationManager.updateProjectConfiguration(project, (IProgressMonitor)subMonitor.newChild(1));
        }
        catch (CoreException ex) {
            ProjectTemplatesActivator.pluginLog().logError(ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    private void waitAllJobsComplete(IProgressMonitor monitor) {
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
        }
        catch (InterruptedException | OperationCanceledException e) {
            ProjectTemplatesActivator.pluginLog().logError(e);
        }
    }

    protected boolean configurePomCamelVersion(IProject project, NewProjectMetaData projectMetaData, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MavenTemplateConfigurator_AdaptingprojectToCamelVersionMonitorMessage, (int)6);
        try {
            File pomFile = new File(project.getFile("pom.xml").getLocation().toOSString());
            Model m2m = MavenPlugin.getMaven().readModel(pomFile);
            subMonitor.worked(1);
            String camelVersion = projectMetaData.getCamelVersion();
            if (m2m.getDependencyManagement() != null) {
                MavenUtils.updateCamelVersionDependencies(m2m.getDependencyManagement().getDependencies(), camelVersion);
            }
            subMonitor.worked(1);
            MavenUtils.updateCamelVersionDependencies(m2m.getDependencies(), camelVersion);
            if (m2m.getBuild().getPluginManagement() != null) {
                MavenUtils.updateCamelVersionPlugins(m2m.getBuild().getPluginManagement().getPlugins(), camelVersion);
            }
            subMonitor.worked(1);
            MavenUtils.updateCamelVersionPlugins(m2m.getBuild().getPlugins(), camelVersion);
            subMonitor.worked(1);
            if (projectMetaData.getTargetRuntime() == null) {
                MavenUtils.alignFuseRuntimeVersion(m2m, camelVersion);
            } else {
                MavenUtils.alignFuseRuntimeVersion(m2m, camelVersion);
            }
            subMonitor.worked(1);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(pomFile));
            MavenPlugin.getMaven().writeModel(m2m, (OutputStream)os);
            IFile pomIFile2 = project.getProject().getFile("pom.xml");
            if (pomIFile2 != null) {
                pomIFile2.refreshLocal(2, (IProgressMonitor)subMonitor.newChild(1));
            }
            ((OutputStream)os).close();
        }
        catch (Exception ex) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            return false;
        }
        return true;
    }
}

