/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.adopters.creators;

import org.apache.maven.archetype.catalog.Archetype;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.fusesource.ide.projecttemplates.adopters.creators.TemplateCreatorSupport;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.NewProjectMetaData;

public abstract class ArchetypeTemplateCreator
implements TemplateCreatorSupport {
    @Override
    public boolean create(IProject project, NewProjectMetaData metadata, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ArchetypeTemplateCreator_CreatingTemplateFromArchetypeMonitorMessage, (int)2);
        Archetype archetype = this.getArchetype(metadata, (IProgressMonitor)subMonitor.newChild(1));
        ProjectImportConfiguration config = null;
        IProjectConfigurationManager manager = MavenPlugin.getProjectConfigurationManager();
        try {
            manager.createArchetypeProjects(project.getLocation(), archetype, archetype.getGroupId(), archetype.getArtifactId(), archetype.getVersion(), this.getJavaPackage(), archetype.getProperties(), config, (IProgressMonitor)subMonitor.newChild(1));
        }
        catch (CoreException ex) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            return false;
        }
        return true;
    }

    protected abstract Archetype getArchetype(NewProjectMetaData var1, IProgressMonitor var2);

    protected abstract String getJavaPackage();
}

