/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.adopters.creators;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.fusesource.ide.projecttemplates.adopters.creators.InputStreamCreator;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.NewProjectMetaData;

public abstract class UnzipStreamCreator
extends InputStreamCreator {
    @Override
    public boolean create(IProject project, NewProjectMetaData metadata, IProgressMonitor monitor) {
        return this.unzipStream(project, metadata, monitor);
    }

    protected boolean unzipStream(IProject project, NewProjectMetaData metadata, IProgressMonitor monitor) {
        block7: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UnzipStreamCreator_UnzippingTemplateFileMonitorMessage, (int)2);
            try {
                File folder = new File(project.getLocation().toOSString());
                if (!folder.exists()) {
                    folder.mkdir();
                }
                InputStream is = this.getTemplateStream(metadata);
                subMonitor.worked(1);
                if (is instanceof ZipInputStream) {
                    ZipInputStream zis = (ZipInputStream)this.getTemplateStream(metadata);
                    ZipEntry ze = zis.getNextEntry();
                    while (ze != null) {
                        String fileName = ze.getName();
                        File newFile = new File(folder + File.separator + fileName);
                        if (ze.isDirectory()) {
                            newFile.mkdirs();
                        } else {
                            Path newFilePath = newFile.toPath();
                            Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
                            Files.copy(zis, newFilePath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        ze = zis.getNextEntry();
                    }
                    zis.closeEntry();
                    zis.close();
                    subMonitor.worked(1);
                    break block7;
                }
                ProjectTemplatesActivator.pluginLog().logError("Unable to unzip stream of type " + is.getClass().getName());
                return false;
            }
            catch (IOException ex) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
                return false;
            }
        }
        return true;
    }
}

