/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.impl.simple;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipInputStream;
import org.fusesource.ide.projecttemplates.adopters.AbstractProjectTemplate;
import org.fusesource.ide.projecttemplates.adopters.configurators.MavenTemplateConfigurator;
import org.fusesource.ide.projecttemplates.adopters.configurators.TemplateConfiguratorSupport;
import org.fusesource.ide.projecttemplates.adopters.creators.TemplateCreatorSupport;
import org.fusesource.ide.projecttemplates.adopters.creators.UnzipStreamCreator;
import org.fusesource.ide.projecttemplates.adopters.util.CamelDSLType;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.NewProjectMetaData;

public class EAPSpringTemplate
extends AbstractProjectTemplate {
    @Override
    public boolean supportsDSL(CamelDSLType type) {
        switch (type) {
            case BLUEPRINT: {
                return false;
            }
            case SPRING: {
                return true;
            }
            case JAVA: {
                return false;
            }
        }
        return false;
    }

    @Override
    public TemplateCreatorSupport getCreator(NewProjectMetaData projectMetaData) {
        return new EAPSpringUnzipTemplateCreator();
    }

    @Override
    public TemplateConfiguratorSupport getConfigurator() {
        return new MavenTemplateConfigurator();
    }

    private class EAPSpringUnzipTemplateCreator
    extends UnzipStreamCreator {
        private static final String TEMPLATE_FOLDER = "templates/";
        private static final String TEMPLATE_SPRING = "template-medium-eap-wildfly-spring.zip";

        private EAPSpringUnzipTemplateCreator() {
        }

        @Override
        public InputStream getTemplateStream(NewProjectMetaData metadata) throws IOException {
            String bundleEntry = null;
            switch (metadata.getDslType()) {
                case SPRING: {
                    bundleEntry = String.format("%s%s", TEMPLATE_FOLDER, TEMPLATE_SPRING);
                }
            }
            URL archiveUrl = ProjectTemplatesActivator.getBundleContext().getBundle().getEntry(bundleEntry);
            if (archiveUrl != null) {
                InputStream is = null;
                try {
                    is = archiveUrl.openStream();
                    return new ZipInputStream(is, StandardCharsets.UTF_8);
                }
                catch (IOException ex) {
                    ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
                }
            }
            return null;
        }
    }
}

