/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.impl.simple;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipInputStream;
import org.fusesource.ide.projecttemplates.adopters.AbstractProjectTemplate;
import org.fusesource.ide.projecttemplates.adopters.configurators.MavenTemplateConfigurator;
import org.fusesource.ide.projecttemplates.adopters.configurators.TemplateConfiguratorSupport;
import org.fusesource.ide.projecttemplates.adopters.creators.TemplateCreatorSupport;
import org.fusesource.ide.projecttemplates.adopters.creators.UnzipStreamCreator;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.NewProjectMetaData;

public class EmptyProjectTemplate
extends AbstractProjectTemplate {
    @Override
    public TemplateConfiguratorSupport getConfigurator() {
        return new MavenTemplateConfigurator();
    }

    @Override
    public TemplateCreatorSupport getCreator(NewProjectMetaData projectMetaData) {
        return new BlankProjectCreator();
    }

    private class BlankProjectCreator
    extends UnzipStreamCreator {
        private static final String TEMPLATE_FOLDER = "templates/";
        private static final String TEMPLATE_BLUEPRINT = "template-blank-blueprint.zip";
        private static final String TEMPLATE_SPRING = "template-blank-spring.zip";
        private static final String TEMPLATE_JAVA = "template-blank-java.zip";

        private BlankProjectCreator() {
        }

        @Override
        public InputStream getTemplateStream(NewProjectMetaData metadata) throws IOException {
            String bundleEntry = null;
            switch (metadata.getDslType()) {
                case BLUEPRINT: {
                    bundleEntry = String.format("%s%s", TEMPLATE_FOLDER, TEMPLATE_BLUEPRINT);
                    break;
                }
                case SPRING: {
                    bundleEntry = String.format("%s%s", TEMPLATE_FOLDER, TEMPLATE_SPRING);
                    break;
                }
                case JAVA: {
                    bundleEntry = String.format("%s%s", TEMPLATE_FOLDER, TEMPLATE_JAVA);
                }
            }
            URL archiveUrl = ProjectTemplatesActivator.getBundleContext().getBundle().getEntry(bundleEntry);
            if (archiveUrl != null) {
                InputStream is = null;
                try {
                    is = archiveUrl.openStream();
                    return new ZipInputStream(is, StandardCharsets.UTF_8);
                }
                catch (IOException ex) {
                    ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
                }
            }
            return null;
        }
    }
}

