/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.maven;

import java.util.Arrays;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.service.core.util.CamelFilesFinder;
import org.fusesource.ide.camel.model.service.core.util.JavaCamelFilesFinder;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.camel.CamelFacetDataModelProvider;
import org.fusesource.ide.projecttemplates.util.camel.CamelFacetVersionChangeDelegate;

public class CamelProjectConfigurator
extends AbstractProjectConfigurator {
    private static final String ARTFIFACT_ID_CAMEL_PREFIX = "camel-";
    private static final String GROUP_ID_ORG_APACHE_CAMEL = "org.apache.camel";
    public static final String WAR_PACKAGE = "WAR";
    public static final String BUNDLE_PACKAGE = "BUNDLE";
    public static final String JAR_PACKAGE = "JAR";
    public static IProjectFacet camelFacet = ProjectFacetsManager.getProjectFacet((String)"jst.camel");
    public static IProjectFacet javaFacet = ProjectFacetsManager.getProjectFacet((String)"java");
    public static IProjectFacet m2eFacet = ProjectFacetsManager.getProjectFacet((String)"jboss.m2");
    public static IProjectFacet utilFacet = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
    public static IProjectFacet webFacet = WebFacetUtils.WEB_FACET;

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = event.getMavenProject();
        if (event.getFlags() == 1 && facade != null) {
            IProject project = facade.getProject();
            MavenProject mavenProject = facade.getMavenProject(monitor);
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj != null && this.checkCamelContextsExist(project, monitor)) {
                this.installDefaultFacets(project, mavenProject, fproj, monitor);
            }
        }
        super.mavenProjectChanged(event, monitor);
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        if (this.checkCamelContextsExist(request.getProject(), monitor)) {
            if (!this.isCamelFacetEnabled(request)) {
                this.configureFacet(request.getMavenProject(), request.getProject(), monitor);
            }
            if (!this.isCamelNatureEnabled(request.getProject())) {
                this.configureNature(request.getProject(), request.getMavenProject(), monitor);
            }
            if (this.isWARProject(request.getProject(), monitor)) {
                this.configureWARStructureMapping(request.getProject(), monitor);
            }
        }
    }

    private void configureWARStructureMapping(IProject project, IProgressMonitor monitor) throws CoreException {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)false);
        c.create(0, monitor);
        IVirtualFolder webroot = c.getRootFolder();
        IVirtualFolder classesFolder = webroot.getFolder("/WEB-INF/classes");
        IMavenProjectFacade m2prj = MavenPlugin.getMavenProjectRegistry().create(project, monitor);
        this.updateMappings(m2prj.getCompileSourceLocations(), project, classesFolder, monitor);
        this.updateMappings(m2prj.getTestCompileSourceLocations(), project, classesFolder, monitor);
    }

    private void updateMappings(IPath[] paths, IProject project, IVirtualFolder vFolder, IProgressMonitor monitor) throws CoreException {
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath sourceLoc = iPathArray[n2];
            IFolder srcFolder = project.getFolder(sourceLoc);
            IPath absSourcePath = srcFolder.getProjectRelativePath().makeAbsolute();
            IVirtualResource[] mappings = ComponentCore.createResources((IResource)srcFolder);
            boolean found = false;
            IVirtualResource[] iVirtualResourceArray = mappings;
            int n3 = mappings.length;
            int n4 = 0;
            while (n4 < n3) {
                IVirtualResource mapping = iVirtualResourceArray[n4];
                if (mapping.getProjectRelativePath().equals((Object)absSourcePath)) {
                    mapping.createLink(absSourcePath, 0, monitor);
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                vFolder.createLink(absSourcePath, 0, monitor);
            } else {
                this.removeRedundantMappingToRootRuntimePath(monitor, absSourcePath, mappings);
            }
            ++n2;
        }
    }

    private void removeRedundantMappingToRootRuntimePath(IProgressMonitor monitor, IPath absSourcePath, IVirtualResource[] mappings) {
        Arrays.stream(mappings).filter(mapping -> mapping.getProjectRelativePath().equals((Object)absSourcePath)).filter(mapping -> "/".equals(mapping.getRuntimePath().toPortableString())).forEach(mapping -> {
            try {
                mapping.delete(1024, monitor);
            }
            catch (CoreException e) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)e);
            }
        });
    }

    private boolean isWARProject(IProject project, IProgressMonitor monitor) {
        IMavenProjectFacade m2prj = MavenPlugin.getMavenProjectRegistry().create(project, monitor);
        return WAR_PACKAGE.equalsIgnoreCase(m2prj.getPackaging());
    }

    private boolean isCamelFacetEnabled(ProjectConfigurationRequest request) throws CoreException {
        IProject project = request.getProject();
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj != null) {
            Set facets = fproj.getProjectFacets();
            for (IProjectFacetVersion f : facets) {
                if (!"jst.camel".equals(f.getProjectFacet().getId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCamelNatureEnabled(IProject project) throws CoreException {
        IProjectDescription projectDescription = project.getDescription();
        String[] ids = projectDescription.getNatureIds();
        return Arrays.stream(ids).anyMatch("org.fusesource.ide.project.RiderProjectNature"::equals);
    }

    private void configureNature(IProject project, MavenProject m2Project, IProgressMonitor monitor) throws CoreException {
        boolean hasCamelDeps = this.checkCamelDependencies(m2Project);
        boolean hasCamelContextXML = false;
        if (!hasCamelDeps) {
            hasCamelContextXML = this.checkCamelContextsExist(project, monitor);
        }
        if (hasCamelDeps || hasCamelContextXML) {
            CamelProjectConfigurator.addNature((IProject)project, (String)"org.fusesource.ide.project.RiderProjectNature", (IProgressMonitor)monitor);
        }
    }

    private void configureFacet(MavenProject mavenProject, IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.checkCamelContextsExist(project, monitor)) {
            return;
        }
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj == null) {
            WtpUtils.addNatures((IProject)project);
            CamelProjectConfigurator.addNature((IProject)project, (String)"org.eclipse.wst.common.project.facet.core.nature", (IProgressMonitor)monitor);
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        if (fproj != null) {
            this.installDefaultFacets(project, mavenProject, fproj, monitor);
        }
    }

    private void installDefaultFacets(IProject project, MavenProject mavenProject, IFacetedProject fproj, IProgressMonitor monitor) throws CoreException {
        String camelVersion = this.getCamelVersion(mavenProject);
        if (camelVersion != null) {
            IFacetedProjectWorkingCopy fpwc = fproj.createWorkingCopy();
            this.installFacet(fproj, fpwc, javaFacet, javaFacet.getLatestVersion());
            this.installFacet(fproj, fpwc, m2eFacet, m2eFacet.getLatestVersion());
            if (mavenProject.getPackaging() != null) {
                String packaging = mavenProject.getPackaging();
                if (WAR_PACKAGE.equalsIgnoreCase(packaging)) {
                    this.installFacet(fproj, fpwc, webFacet, javaFacet.getLatestVersion());
                } else if (BUNDLE_PACKAGE.equalsIgnoreCase(packaging) || JAR_PACKAGE.equalsIgnoreCase(packaging)) {
                    this.installFacet(fproj, fpwc, utilFacet, utilFacet.getLatestVersion());
                }
            }
            this.installCamelFacet(fproj, fpwc, camelVersion, monitor);
            fpwc.commitChanges(monitor);
            this.configureNature(project, mavenProject, monitor);
            this.updateMavenProject(project, monitor);
        }
    }

    private void updateMavenProject(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project != null) {
            try {
                CamelProjectConfigurator.waitJob(100, monitor);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            UpdateMavenProjectJob updateJob = new UpdateMavenProjectJob(new IProject[]{project});
            updateJob.schedule();
        }
    }

    private static void waitJob(int decreasingCounter, IProgressMonitor monitor) throws InterruptedException {
        if (decreasingCounter > 0) {
            return;
        }
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
        }
        catch (InterruptedException interruptedException) {
            CamelProjectConfigurator.waitJob(decreasingCounter--, monitor);
        }
    }

    private String getCamelVersion(MavenProject mavenProject) throws CoreException {
        for (Dependency dep : mavenProject.getDependencies()) {
            if (!this.isCamelDependency(dep)) continue;
            return dep.getVersion();
        }
        return CamelModelFactory.getLatestCamelVersion();
    }

    private void installCamelFacet(IFacetedProject fproj, IFacetedProjectWorkingCopy fpwc, String camelVersionString, IProgressMonitor monitor) throws CoreException {
        IDataModel config = (IDataModel)new CamelFacetDataModelProvider().create();
        config.setBooleanProperty("camel.project.structure.update", false);
        IProjectFacetVersion camelFacetVersion = this.getCamelFacetVersion(camelVersionString);
        this.installFacet(fproj, fpwc, camelFacet, camelFacetVersion == null ? camelFacet.getLatestVersion() : camelFacetVersion);
        if (camelFacetVersion == null) {
            CamelFacetVersionChangeDelegate del = new CamelFacetVersionChangeDelegate();
            del.execute(fproj.getProject(), camelFacet.getLatestVersion(), config, monitor);
        }
    }

    private IProjectFacetVersion getCamelFacetVersion(String camelVersionString) throws CoreException {
        try {
            IProjectFacetVersion facetVersion = camelFacet.getVersion(CamelModelFactory.getCompatibleCamelVersion((String)camelVersionString));
            if (facetVersion != null) {
                return facetVersion;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return camelFacet.getLatestVersion();
        }
        return camelFacet.getLatestVersion();
    }

    private boolean checkCamelContextsExist(IProject project, IProgressMonitor monitor) throws CoreException {
        return !new CamelFilesFinder().findFiles((IResource)project).isEmpty() || new JavaCamelFilesFinder().findJavaDSLRouteBuilderClass(project, monitor) != null;
    }

    private void installFacet(IFacetedProject fproj, IFacetedProjectWorkingCopy fpwc, IProjectFacet facet, IProjectFacetVersion facetVersion) throws CoreException {
        if (facet != null && !fproj.hasProjectFacet(facet)) {
            fpwc.addProjectFacet(facetVersion);
        } else {
            IProjectFacetVersion f = fproj.getProjectFacetVersion(facet);
            if (!f.getVersionString().equals(facetVersion.getVersionString())) {
                fpwc.changeProjectFacetVersion(facetVersion);
            }
        }
    }

    private boolean checkCamelDependencies(MavenProject m2Project) {
        return m2Project.getDependencies().stream().anyMatch(this::isCamelDependency);
    }

    private boolean isCamelDependency(Dependency dep) {
        return GROUP_ID_ORG_APACHE_CAMEL.equals(dep.getGroupId()) && dep.getArtifactId().startsWith(ARTFIFACT_ID_CAMEL_PREFIX);
    }
}

