/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.util.camel;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.maven.MavenUtils;

public class CamelFacetVersionChangeDelegate
implements IDelegate {
    private static final String PRODUCT_STAGING_REPO_URI = "http://download.eng.brq.redhat.com/brewroot/repos/jb-fuse-6.2-build/latest/maven";
    private static final String THIRD_PARTY_STAGING_REPO_URI = "https://maven.repository.redhat.com/earlyaccess/all";
    private static final String REDHAT_GA_PUBLIC_REPO = "https://maven.repository.redhat.com/ga";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        String newVersion = this.getCamelVersionForFacetVersion(fv);
        this.updateCamelVersion(project, newVersion);
    }

    private String getCamelVersionForFacetVersion(IProjectFacetVersion fv) {
        String facetVersion = fv.getVersionString();
        String camelVersion = CamelModelFactory.getCompatibleCamelVersion((String)facetVersion);
        if (camelVersion == null) {
            camelVersion = CamelModelFactory.getLatestCamelVersion();
        }
        return camelVersion;
    }

    private void updateCamelVersion(IProject project, String camelVersion) throws CoreException {
        Object pluginManagement;
        File pomFile = new File(project.getFile("pom.xml").getLocation().toOSString());
        Model m2m = MavenPlugin.getMaven().readModel(pomFile);
        if (m2m.getDependencyManagement() != null) {
            List dependencies = m2m.getDependencyManagement().getDependencies();
            MavenUtils.updateCamelVersionDependencies(dependencies, camelVersion);
            MavenUtils.updateContributedDependencies(dependencies, camelVersion);
        }
        MavenUtils.updateCamelVersionDependencies(m2m.getDependencies(), camelVersion);
        MavenUtils.updateContributedDependencies(m2m.getDependencies(), camelVersion);
        Build m2Build = m2m.getBuild();
        if (m2Build != null) {
            pluginManagement = m2Build.getPluginManagement();
            if (pluginManagement != null) {
                List pluginManagementPlugins = pluginManagement.getPlugins();
                MavenUtils.updateCamelVersionPlugins(pluginManagementPlugins, camelVersion);
                MavenUtils.updateContributedPlugins(pluginManagementPlugins, camelVersion);
            }
            MavenUtils.updateCamelVersionPlugins(m2Build.getPlugins(), camelVersion);
            MavenUtils.updateContributedPlugins(m2Build.getPlugins(), camelVersion);
        }
        MavenUtils.ensureRepositoryExists(m2m.getRepositories(), PRODUCT_STAGING_REPO_URI, "fuse-ea");
        MavenUtils.ensureRepositoryExists(m2m.getPluginRepositories(), PRODUCT_STAGING_REPO_URI, "fuse-ea");
        MavenUtils.ensureRepositoryExists(m2m.getRepositories(), THIRD_PARTY_STAGING_REPO_URI, "redhat-ea-repository");
        MavenUtils.ensureRepositoryExists(m2m.getPluginRepositories(), THIRD_PARTY_STAGING_REPO_URI, "redhat-ea-repository");
        MavenUtils.ensureRepositoryExists(m2m.getRepositories(), REDHAT_GA_PUBLIC_REPO, "redhat-ga-repository");
        MavenUtils.ensureRepositoryExists(m2m.getPluginRepositories(), REDHAT_GA_PUBLIC_REPO, "redhat-ga-repository");
        try {
            try {
                pluginManagement = null;
                Object var7_9 = null;
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(pomFile));){
                    MavenPlugin.getMaven().writeModel(m2m, (OutputStream)os);
                }
                catch (Throwable throwable) {
                    if (pluginManagement == null) {
                        pluginManagement = throwable;
                    } else if (pluginManagement != throwable) {
                        ((Throwable)pluginManagement).addSuppressed(throwable);
                    }
                    throw pluginManagement;
                }
            }
            catch (Exception ex) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
                IFile pomIFile2 = project.getProject().getFile("pom.xml");
                if (pomIFile2 != null) {
                    pomIFile2.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        finally {
            IFile pomIFile2 = project.getProject().getFile("pom.xml");
            if (pomIFile2 != null) {
                pomIFile2.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

