/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.util.maven;

import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.fusesource.ide.camel.editor.provider.ext.IDependenciesManager;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;

public class MavenUtils {
    private static final String JBOSS_FUSE_PARENT = "jboss-fuse-parent";
    private static final String ORG_JBOSS_FUSE_BOM = "org.jboss.fuse.bom";
    private static final String MAVEN_PROPERTY_JBOSS_FUSE_BOM_VERSION = "jboss.fuse.bom.version";

    public static void updateCamelVersionPlugins(List<Plugin> plugins, String camelVersion) {
        for (Plugin p : plugins) {
            if (!"org.apache.camel".equalsIgnoreCase(p.getGroupId()) || !p.getArtifactId().startsWith("camel-")) continue;
            p.setVersion(camelVersion);
        }
    }

    public static void updateContributedPlugins(List<Plugin> plugins, String camelVersion) {
        IConfigurationElement[] iConfigurationElementArray = MavenUtils.getExtensionPoints();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o;
                if (e.getAttribute("dependenciesManager") != null && (o = e.createExecutableExtension("dependenciesManager")) instanceof IDependenciesManager) {
                    IDependenciesManager dm = (IDependenciesManager)o;
                    dm.updatePluginDependencies(plugins, camelVersion);
                }
            }
            catch (CoreException e1) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)e1);
            }
            ++n2;
        }
    }

    private static IConfigurationElement[] getExtensionPoints() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.fusesource.ide.editor.paletteContributor");
    }

    public static void updateCamelVersionDependencies(List<Dependency> dependencies, String camelVersion) {
        for (Dependency dep : dependencies) {
            if (!"org.apache.camel".equalsIgnoreCase(dep.getGroupId()) || !dep.getArtifactId().startsWith("camel-")) continue;
            dep.setVersion(camelVersion);
        }
    }

    public static void updateContributedDependencies(List<Dependency> dependencies, String camelVersion) {
        IConfigurationElement[] iConfigurationElementArray = MavenUtils.getExtensionPoints();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o;
                if (e.getAttribute("dependenciesManager") != null && (o = e.createExecutableExtension("dependenciesManager")) instanceof IDependenciesManager) {
                    IDependenciesManager dm = (IDependenciesManager)o;
                    dm.updateDependencies(dependencies, camelVersion);
                }
            }
            catch (CoreException e1) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)e1);
            }
            ++n2;
        }
    }

    public static void ensureRepositoryExists(List<Repository> repositories, String repoURI, String newId) {
        boolean exists = false;
        for (Repository rep : repositories) {
            if (!rep.getUrl().equalsIgnoreCase(repoURI)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            Repository repo = new Repository();
            repo.setId(newId);
            repo.setUrl(repoURI);
            repositories.add(repo);
        }
    }

    public static void alignFuseRuntimeVersion(Model mavenModel, String camelVersion) {
        Properties properties = mavenModel.getProperties();
        if (properties != null && properties.getProperty(MAVEN_PROPERTY_JBOSS_FUSE_BOM_VERSION) != null) {
            properties.setProperty(MAVEN_PROPERTY_JBOSS_FUSE_BOM_VERSION, CamelModelFactory.getFuseVersionForCamelVersion((String)camelVersion));
        } else if (mavenModel.getDependencyManagement() != null) {
            for (Dependency dependency : mavenModel.getDependencyManagement().getDependencies()) {
                if (!ORG_JBOSS_FUSE_BOM.equals(dependency.getGroupId()) || !JBOSS_FUSE_PARENT.equals(dependency.getArtifactId())) continue;
                dependency.setVersion(CamelModelFactory.getFuseVersionForCamelVersion((String)camelVersion));
                return;
            }
        }
    }
}

