/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.fusesource.ide.camel.model.service.core.util.JavaCamelFilesFinder;
import org.fusesource.ide.projecttemplates.adopters.AbstractProjectTemplate;
import org.fusesource.ide.projecttemplates.impl.simple.EmptyProjectTemplate;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.BasicProjectCreator;
import org.fusesource.ide.projecttemplates.util.NewProjectMetaData;

public final class FuseIntegrationProjectCreatorRunnable
implements IRunnableWithProgress {
    public static final String FUSE_PERSPECTIVE_ID = "org.fusesource.ide.branding.perspective";
    private final NewProjectMetaData metadata;

    public FuseIntegrationProjectCreatorRunnable(NewProjectMetaData metadata) {
        this.metadata = metadata;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        boolean switchPerspective;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.FuseIntegrationProjectCreatorRunnable_CreatingTheProjectMonitorMessage, (int)7);
        BasicProjectCreator c = new BasicProjectCreator(this.metadata);
        boolean ok = c.create((IProgressMonitor)subMonitor.newChild(1));
        IProject prj = c.getProject();
        if (ok) {
            AbstractProjectTemplate template = this.metadata.getTemplate();
            if (this.metadata.isBlankProject()) {
                template = new EmptyProjectTemplate();
            }
            try {
                template.create(prj, this.metadata, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (CoreException ex) {
                ProjectTemplatesActivator.pluginLog().logError("Unable to create project...", (Throwable)ex);
            }
        }
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IPerspectiveDescriptor finalPersp = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(FUSE_PERSPECTIVE_ID);
        IPerspectiveDescriptor currentPersp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
        boolean bl = switchPerspective = currentPersp.getId().equals(finalPersp.getId()) ? false : this.confirmPerspectiveSwitch(workbenchWindow, finalPersp);
        if (switchPerspective) {
            this.switchToFusePerspective(workbenchWindow);
            subMonitor.worked(1);
        }
        try {
            prj.refreshLocal(2, (IProgressMonitor)subMonitor.newChild(1));
            this.updateBundleSymbolicName(prj, (IProgressMonitor)subMonitor.newChild(1));
        }
        catch (CoreException ex) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
        }
        IResource rs = prj.findMember("src/META-INF/");
        if (rs != null && rs.exists()) {
            try {
                rs.delete(true, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (CoreException ex) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            }
        }
        this.openCamelContextFile(prj, (IProgressMonitor)subMonitor.newChild(1));
        subMonitor.done();
    }

    protected void updateBundleSymbolicName(IProject project, IProgressMonitor monitor) throws CoreException {
        final ArrayList files = new ArrayList();
        project.getFolder("src").accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile && "manifest.mf".equalsIgnoreCase(resource.getName())) {
                    files.add((IFile)resource);
                }
                return true;
            }
        });
        for (IFile f : files) {
            try {
                InputStream is = f.getContents();
                Manifest mf = new Manifest(is);
                is.close();
                Attributes attributes = mf.getMainAttributes();
                attributes.putValue("Bundle-SymbolicName", this.getBundleSymbolicNameForProjectName(project.getName()));
                attributes.putValue("Bundle-Name", String.format("%s [%s]", attributes.getValue("Bundle-Name"), project.getName()));
                mf.write(new FileOutputStream(f.getLocation().toFile()));
                f.refreshLocal(0, monitor);
            }
            catch (IOException ioe) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ioe);
            }
        }
    }

    public String getBundleSymbolicNameForProjectName(String projectName) {
        return projectName.replaceAll("[^a-zA-Z0-9-_]", "");
    }

    void switchToFusePerspective(final IWorkbenchWindow workbenchWindow) {
        IPerspectiveDescriptor activePerspective = workbenchWindow.getActivePage().getPerspective();
        if (activePerspective == null || !activePerspective.getId().equals(FUSE_PERSPECTIVE_ID)) {
            workbenchWindow.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        workbenchWindow.getWorkbench().showPerspective(FuseIntegrationProjectCreatorRunnable.FUSE_PERSPECTIVE_ID, workbenchWindow);
                    }
                    catch (WorkbenchException e) {
                        ProjectTemplatesActivator.pluginLog().logError((Throwable)e);
                    }
                }
            });
        }
    }

    private boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    private void openCamelContextFile(IProject project, final IProgressMonitor monitor) {
        if (project != null) {
            final IFile[] holder = new IFile[1];
            this.searchCamelContextXMLFile(project, holder);
            ProjectTemplatesActivator.pluginLog().logWarning("xml file found? " + holder[0]);
            try {
                if (holder[0] == null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    this.searchCamelContextJavaFile(project, monitor, holder);
                }
            }
            catch (CoreException e1) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)e1);
            }
            if (holder[0] != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!holder[0].exists()) {
                                try {
                                    FuseIntegrationProjectCreatorRunnable.waitJob(20, monitor);
                                }
                                catch (InterruptedException | OperationCanceledException e) {
                                    ProjectTemplatesActivator.pluginLog().logError(e);
                                    return;
                                }
                            }
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)holder[0], (boolean)OpenStrategy.activateOnOpen());
                        }
                        catch (PartInitException e) {
                            ProjectTemplatesActivator.pluginLog().logError("Cannot open camel context file in editor", (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    private void searchCamelContextJavaFile(IProject project, IProgressMonitor monitor, IFile[] holder) {
        IFile f = new JavaCamelFilesFinder().findJavaDSLRouteBuilderClass(project, monitor);
        if (f != null) {
            holder[0] = f;
        }
    }

    private void searchCamelContextXMLFile(IProject project, final IFile[] holder) {
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        IContentDescription fileContentDescription = file.getContentDescription();
                        String firstSegmentPathInProject = file.getProjectRelativePath().segment(0);
                        if (!"target".equals(firstSegmentPathInProject) && !"bin".equals(firstSegmentPathInProject) && fileContentDescription != null && "org.fusesource.ide.camel.editor.camelContentType".equals(fileContentDescription.getContentType().getId())) {
                            holder[0] = file;
                        }
                    }
                    return holder[0] == null;
                }
            });
        }
        catch (CoreException e1) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)e1);
        }
    }

    private static void waitJob(int decreasingCounter, IProgressMonitor monitor) throws InterruptedException {
        if (decreasingCounter > 0) {
            return;
        }
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, monitor);
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, monitor);
        }
        catch (InterruptedException interruptedException) {
            FuseIntegrationProjectCreatorRunnable.waitJob(decreasingCounter--, monitor);
        }
    }
}

