/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.NewProjectMetaData;
import org.fusesource.ide.projecttemplates.wizards.FuseIntegrationProjectCreatorRunnable;
import org.fusesource.ide.projecttemplates.wizards.pages.FuseIntegrationProjectWizardLocationPage;
import org.fusesource.ide.projecttemplates.wizards.pages.FuseIntegrationProjectWizardRuntimeAndCamelPage;
import org.fusesource.ide.projecttemplates.wizards.pages.FuseIntegrationProjectWizardTemplatePage;

public class FuseIntegrationProjectWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection selection;
    protected FuseIntegrationProjectWizardLocationPage locationPage;
    protected FuseIntegrationProjectWizardRuntimeAndCamelPage runtimeAndCamelVersionPage;
    protected FuseIntegrationProjectWizardTemplatePage templateSelectionPage;

    public FuseIntegrationProjectWizard() {
        this.setWindowTitle(Messages.newProjectWizardTitle);
        this.setDefaultPageImageDescriptor(ProjectTemplatesActivator.imageDescriptorFromPlugin((String)"org.fusesource.ide.projecttemplates", (String)"icons/camel_project_64x64.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean canFinish() {
        return this.locationPage.isPageComplete() && this.runtimeAndCamelVersionPage.isPageComplete() && this.templateSelectionPage.isPageComplete();
    }

    public boolean performFinish() {
        NewProjectMetaData metadata = this.getProjectMetaData();
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new FuseIntegrationProjectCreatorRunnable(metadata));
        }
        catch (InterruptedException iex) {
            ProjectTemplatesActivator.pluginLog().logError("User canceled the wizard!", (Throwable)iex);
            return false;
        }
        catch (InvocationTargetException ite) {
            ProjectTemplatesActivator.pluginLog().logError("Error occured executing the wizard!", (Throwable)ite);
            return false;
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this.locationPage = new FuseIntegrationProjectWizardLocationPage();
        this.addPage((IWizardPage)this.locationPage);
        this.runtimeAndCamelVersionPage = new FuseIntegrationProjectWizardRuntimeAndCamelPage();
        this.addPage((IWizardPage)this.runtimeAndCamelVersionPage);
        this.templateSelectionPage = new FuseIntegrationProjectWizardTemplatePage();
        this.addPage((IWizardPage)this.templateSelectionPage);
    }

    private NewProjectMetaData getProjectMetaData() {
        NewProjectMetaData metadata = new NewProjectMetaData();
        metadata.setProjectName(this.locationPage.getProjectName());
        if (!this.locationPage.isInWorkspace()) {
            metadata.setLocationPath(this.locationPage.getLocationPath());
        }
        metadata.setCamelVersion(this.runtimeAndCamelVersionPage.getSelectedCamelVersion());
        metadata.setTargetRuntime(this.runtimeAndCamelVersionPage.getSelectedRuntime());
        metadata.setDslType(this.templateSelectionPage.getDSL());
        metadata.setBlankProject(this.templateSelectionPage.isEmptyProject());
        metadata.setTemplate(this.templateSelectionPage.getSelectedTemplate() != null ? this.templateSelectionPage.getSelectedTemplate().getTemplate() : null);
        return metadata;
    }
}

