/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;

public class FuseIntegrationProjectWizardLocationPage
extends WizardPage {
    private Button useDefaultWorkspaceLocationButton;
    private Label locationLabel;
    private Text locationText;
    private Label projectNameLabel;
    private Text projectNameText;
    private IPath location;

    public FuseIntegrationProjectWizardLocationPage() {
        super(Messages.newProjectWizardLocationPageName);
        this.setTitle(Messages.newProjectWizardLocationPageTitle);
        this.setDescription(Messages.newProjectWizardLocationPageDescription);
        this.setImageDescriptor(ProjectTemplatesActivator.imageDescriptorFromPlugin((String)"org.fusesource.ide.projecttemplates", (String)"icons/camel_project_64x64.png"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(4, 128, true, false, 2, 1);
        this.projectNameLabel = new Label(container, 0);
        this.projectNameLabel.setText(Messages.newProjectWizardLocationPageProjectNameLabel);
        this.projectNameText = new Text(container, 2048);
        this.projectNameText.setLayoutData((Object)gridData);
        this.projectNameText.setToolTipText(Messages.newProjectWizardLocationPageProjectNameDescription);
        this.projectNameText.addModifyListener(event -> this.validate());
        Group locationGrp = new Group(container, 0);
        GridData locationGrpData = new GridData(4, 0x1000000, true, false, 3, 1);
        locationGrp.setLayout((Layout)new GridLayout(3, false));
        locationGrp.setLayoutData((Object)locationGrpData);
        locationGrp.setText(Messages.newProjectWizardLocationPageLocationGroupLabel);
        this.locationLabel = new Label((Composite)locationGrp, 0);
        GridData locationLabelData = new GridData();
        locationLabelData.horizontalIndent = 10;
        this.locationLabel.setLayoutData((Object)locationLabelData);
        this.locationLabel.setText(Messages.newProjectWizardLocationPageLocationLabel);
        this.locationLabel.setEnabled(false);
        this.locationText = new Text((Composite)locationGrp, 2048);
        GridData locationTextData = new GridData(4, 0x1000000, true, false);
        this.locationText.setLayoutData((Object)locationTextData);
        this.locationText.setToolTipText(Messages.newProjectWizardLocationPageLocationDescription);
        this.locationText.addModifyListener(event -> this.validate());
        this.locationText.setEnabled(false);
        final Button locationBrowseButton = new Button((Composite)locationGrp, 0);
        GridData locationBrowseButtonData = new GridData(4, 0x1000000, false, false);
        locationBrowseButton.setLayoutData((Object)locationBrowseButtonData);
        locationBrowseButton.setText(Messages.newProjectWizardLocationPageLocationBrowseButtonLabel);
        locationBrowseButton.setToolTipText(Messages.newProjectWizardLocationPageLocationBrowseButtonDescription);
        locationBrowseButton.setEnabled(false);
        locationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(FuseIntegrationProjectWizardLocationPage.this.getShell());
                dialog.setText(Messages.newProjectWizardLocationPageLocationSelectionDialogTitle);
                String path = FuseIntegrationProjectWizardLocationPage.this.locationText.getText();
                if (path.length() == 0) {
                    path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString();
                }
                dialog.setFilterPath(path);
                String selectedDir = dialog.open();
                if (selectedDir != null) {
                    FuseIntegrationProjectWizardLocationPage.this.locationText.setText(selectedDir);
                    FuseIntegrationProjectWizardLocationPage.this.locationText.setEditable(true);
                    FuseIntegrationProjectWizardLocationPage.this.useDefaultWorkspaceLocationButton.setSelection(false);
                    FuseIntegrationProjectWizardLocationPage.this.validate();
                }
            }
        });
        if (this.location != null && !Platform.getLocation().equals((Object)this.location)) {
            this.locationText.setText(this.location.toOSString());
        }
        this.useDefaultWorkspaceLocationButton = new Button((Composite)locationGrp, 32);
        GridData useDefaultWorkspaceLocationButtonData = new GridData(16384, 0x1000000, false, false, 3, 1);
        this.useDefaultWorkspaceLocationButton.setLayoutData((Object)useDefaultWorkspaceLocationButtonData);
        this.useDefaultWorkspaceLocationButton.setText(Messages.newProjectWizardLocationPageLocationDefaultButtonLabel);
        this.useDefaultWorkspaceLocationButton.setToolTipText(Messages.newProjectWizardLocationPageLocationDefaultButtonDescription);
        this.useDefaultWorkspaceLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean inWorkspace = FuseIntegrationProjectWizardLocationPage.this.isInWorkspace();
                FuseIntegrationProjectWizardLocationPage.this.locationLabel.setEnabled(!inWorkspace);
                FuseIntegrationProjectWizardLocationPage.this.locationText.setEnabled(!inWorkspace);
                locationBrowseButton.setEnabled(!inWorkspace);
                FuseIntegrationProjectWizardLocationPage.this.validate();
            }
        });
        this.useDefaultWorkspaceLocationButton.setSelection(true);
        new Label((Composite)locationGrp, 0);
        this.setControl((Control)container);
        this.projectNameText.setFocus();
    }

    public boolean isInWorkspace() {
        return this.useDefaultWorkspaceLocationButton.getSelection();
    }

    protected void validate() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String name = this.getProjectName();
        if (name.trim().length() == 0) {
            this.setErrorMessage(Messages.newProjectWizardLocationPageInvalidProjectNameText);
            this.setPageComplete(false);
            return;
        }
        IStatus nameStatus = workspace.validateName(name, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            this.setPageComplete(false);
            return;
        }
        IProject handle = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        if (handle != null && handle.exists()) {
            this.setErrorMessage(Messages.newProjectWizardLocationPageDuplicateProjectNameText);
            this.setPageComplete(false);
            return;
        }
        IPath projectPath = this.getLocationPath();
        if (!this.isInWorkspace()) {
            String location = projectPath.toOSString();
            if (location.length() == 0) {
                this.setErrorMessage(Messages.newProjectWizardLocationPageInvalidProjectLocationText);
                this.setPageComplete(false);
                return;
            }
            if (!Path.ROOT.isValidPath(location)) {
                this.setErrorMessage(Messages.newProjectWizardLocationPageInvalidProjectLocationText);
                this.setPageComplete(false);
                return;
            }
            IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
            if (!locationStatus.isOK()) {
                this.setErrorMessage(locationStatus.getMessage());
                this.setPageComplete(false);
                return;
            }
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    public String getProjectName() {
        return this.projectNameText != null ? this.projectNameText.getText() : null;
    }

    public IPath getLocationPath() {
        if (this.isInWorkspace()) {
            return ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        return Path.fromOSString((String)this.locationText.getText().trim());
    }
}

