/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards.pages;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.fusesource.ide.camel.model.service.core.catalog.CamelModelFactory;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.util.Widgets;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;

public class FuseIntegrationProjectWizardRuntimeAndCamelPage
extends WizardPage {
    private static final String UNKNOWN_CAMEL_VERSION = "unknown";
    private static final String FUSE_RUNTIME_PREFIX = "org.fusesource.ide.fuseesb.runtime.";
    private static final String EAP_RUNTIME_PREFIX = "org.jboss.ide.eclipse.as.runtime.eap.";
    private static final String CAMEL_CORE_LIB_PREFIX = "camel-core-";
    private static final String CAMEL_CORE_LIB_SUFFIX = ".jar";
    private Label runtimeLabel;
    private Combo runtimeCombo;
    private Button runtimeNewButton;
    private Map<String, IRuntime> serverRuntimes;
    private IRuntimeLifecycleListener listener;
    private String lastSelectedRuntime;
    private Label camelVersionLabel;
    private Combo camelVersionCombo;
    private StyledText camelInfoText;
    private Label warningIconLabel;

    public FuseIntegrationProjectWizardRuntimeAndCamelPage() {
        super(Messages.newProjectWizardRuntimePageName);
        this.setTitle(Messages.newProjectWizardRuntimePageTitle);
        this.setDescription(Messages.newProjectWizardRuntimePageDescription);
        this.setImageDescriptor(ProjectTemplatesActivator.imageDescriptorFromPlugin((String)"org.fusesource.ide.projecttemplates", (String)"icons/camel_project_64x64.png"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Group runtimeGrp = new Group(container, 0);
        GridData runtimeGrpData = new GridData(4, 0x1000000, true, false, 3, 1);
        runtimeGrp.setLayout((Layout)new GridLayout(3, false));
        runtimeGrp.setLayoutData((Object)runtimeGrpData);
        runtimeGrp.setText(Messages.newProjectWizardRuntimePageRuntimeGroupLabel);
        this.runtimeLabel = new Label((Composite)runtimeGrp, 0);
        GridData runtimeLabelData = new GridData(4, 0x1000000, true, false, 3, 1);
        this.runtimeLabel.setLayoutData((Object)runtimeLabelData);
        this.runtimeLabel.setText(Messages.newProjectWizardRuntimePageRuntimeLabel);
        this.runtimeCombo = new Combo((Composite)runtimeGrp, 8);
        GridData runtimeComboData = new GridData(4, 4, true, false, 2, 1);
        this.runtimeCombo.setLayoutData((Object)runtimeComboData);
        this.runtimeCombo.setToolTipText(Messages.newProjectWizardRuntimePageRuntimeDescription);
        this.runtimeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.lastSelectedRuntime = FuseIntegrationProjectWizardRuntimeAndCamelPage.this.runtimeCombo.getText();
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.preselectCamelVersionForRuntime(FuseIntegrationProjectWizardRuntimeAndCamelPage.this.determineRuntimeCamelVersion(FuseIntegrationProjectWizardRuntimeAndCamelPage.this.getSelectedRuntime()));
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.validate();
            }
        });
        try {
            this.configureRuntimeCombo();
        }
        catch (CoreException ex) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
        }
        this.runtimeNewButton = new Button((Composite)runtimeGrp, 0);
        GridData runtimeNewButtonData = new GridData(4, 0x1000000, false, false);
        this.runtimeNewButton.setLayoutData((Object)runtimeNewButtonData);
        this.runtimeNewButton.setText(Messages.newProjectWizardRuntimePageRuntimeNewButtonLabel);
        this.runtimeNewButton.setToolTipText(Messages.newProjectWizardRuntimePageRuntimeNewButtonDescription);
        this.runtimeNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] oldRuntimes = FuseIntegrationProjectWizardRuntimeAndCamelPage.this.runtimeCombo.getItems();
                boolean created = ServerUIUtil.showNewRuntimeWizard((Shell)FuseIntegrationProjectWizardRuntimeAndCamelPage.this.getShell(), null, null);
                if (created) {
                    String[] newRuntimes = FuseIntegrationProjectWizardRuntimeAndCamelPage.this.runtimeCombo.getItems();
                    String newRuntime = FuseIntegrationProjectWizardRuntimeAndCamelPage.this.getNewRuntime(oldRuntimes, newRuntimes);
                    int i = 0;
                    while (i < FuseIntegrationProjectWizardRuntimeAndCamelPage.this.runtimeCombo.getItemCount()) {
                        if (FuseIntegrationProjectWizardRuntimeAndCamelPage.this.runtimeCombo.getItem(i).equalsIgnoreCase(newRuntime)) {
                            FuseIntegrationProjectWizardRuntimeAndCamelPage.this.runtimeCombo.select(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        new Label((Composite)runtimeGrp, 0);
        Group camelGrp = new Group(container, 0);
        GridData camelGrpData = new GridData(4, 4, true, true, 3, 20);
        camelGrp.setLayout((Layout)new GridLayout(3, false));
        camelGrp.setLayoutData((Object)camelGrpData);
        camelGrp.setText(Messages.newProjectWizardRuntimePageCamelGroupLabel);
        this.camelVersionLabel = new Label((Composite)camelGrp, 0);
        GridData camelLabelData = new GridData(4, 0x1000000, true, false, 3, 1);
        this.camelVersionLabel.setLayoutData((Object)camelLabelData);
        this.camelVersionLabel.setText(Messages.newProjectWizardRuntimePageCamelLabel);
        this.camelVersionCombo = new Combo((Composite)camelGrp, 131080);
        GridData camelComboData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.camelVersionCombo.setLayoutData((Object)camelComboData);
        this.camelVersionCombo.setItems(this.getSupportedCamelVersions());
        this.camelVersionCombo.select(Math.max(this.camelVersionCombo.getItemCount() - 1, 0));
        this.camelVersionCombo.setToolTipText(Messages.newProjectWizardRuntimePageCamelDescription);
        this.camelVersionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.validate();
            }
        });
        new Label((Composite)camelGrp, 0);
        this.warningIconLabel = new Label((Composite)camelGrp, 0);
        GridData camelLblData = new GridData(4, 128, false, true, 1, 20);
        camelLblData.verticalIndent = 20;
        this.warningIconLabel.setImage(this.getSWTImage(8));
        this.warningIconLabel.setLayoutData((Object)camelLblData);
        this.warningIconLabel.setVisible(false);
        this.camelInfoText = new StyledText((Composite)camelGrp, 66);
        GridData camelInfoData = new GridData(4, 128, true, true, 2, 20);
        camelInfoData.verticalIndent = 0;
        camelInfoData.heightHint = 150;
        this.camelInfoText.setLayoutData((Object)camelInfoData);
        this.camelInfoText.setEnabled(false);
        this.camelInfoText.setEditable(false);
        this.camelInfoText.setBackground(container.getBackground());
        new Label((Composite)camelGrp, 0);
        this.setControl((Control)container);
        this.listener = new IRuntimeLifecycleListener(){

            public void runtimeRemoved(IRuntime runtime) {
                this.runInUIThread();
            }

            public void runtimeChanged(IRuntime runtime) {
                this.runInUIThread();
            }

            public void runtimeAdded(IRuntime runtime) {
                this.runInUIThread();
            }

            private void runInUIThread() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FuseIntegrationProjectWizardRuntimeAndCamelPage.this.configureRuntimeCombo();
                        }
                        catch (CoreException ex) {
                            ProjectTemplatesActivator.pluginLog().logError("Unable to handle runtime change event", (Throwable)ex);
                        }
                    }
                });
            }
        };
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.listener);
        this.validate();
    }

    private String[] getSupportedCamelVersions() {
        return (String[])CamelModelFactory.getSupportedCamelVersions().stream().sorted().toArray(String[]::new);
    }

    private void configureRuntimeCombo() throws CoreException {
        if (Widgets.isDisposed((Control)this.runtimeCombo)) {
            return;
        }
        int i = 0;
        int selectedRuntimeIdx = 0;
        String lastUsedRuntime = this.lastSelectedRuntime;
        this.serverRuntimes = this.getServerRuntimes(null);
        this.runtimeCombo.removeAll();
        this.runtimeCombo.add(Messages.newProjectWizardRuntimePageNoRuntimeSelectedLabel);
        this.runtimeCombo.select(0);
        for (Map.Entry<String, IRuntime> entry : this.serverRuntimes.entrySet()) {
            this.runtimeCombo.add(entry.getKey());
            ++i;
            IRuntime runtime = entry.getValue();
            if (lastUsedRuntime == null || !lastUsedRuntime.equals(runtime.getId())) continue;
            selectedRuntimeIdx = i;
        }
        if (selectedRuntimeIdx > 0) {
            this.runtimeCombo.select(selectedRuntimeIdx);
        }
    }

    private Map<String, IRuntime> getServerRuntimes(IProjectFacetVersion facetVersion) {
        Set runtimesSet = facetVersion == null ? RuntimeManager.getRuntimes() : RuntimeManager.getRuntimes(Collections.singleton(facetVersion));
        LinkedHashMap<String, IRuntime> runtimesMap = new LinkedHashMap<String, IRuntime>();
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime r : runtimesSet) {
            IRuntime serverRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)r);
            if (serverRuntime == null) continue;
            runtimesMap.put(r.getLocalizedName(), serverRuntime);
        }
        return runtimesMap;
    }

    private String getNewRuntime(String[] oldRuntimes, String[] newRuntimes) {
        String[] stringArray = newRuntimes;
        int n = newRuntimes.length;
        int n2 = 0;
        while (n2 < n) {
            String newRuntime = stringArray[n2];
            boolean found = false;
            String[] stringArray2 = oldRuntimes;
            int n3 = oldRuntimes.length;
            int n4 = 0;
            while (n4 < n3) {
                String oldRuntime = stringArray2[n4];
                if (newRuntime.equals(oldRuntime)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                return newRuntime;
            }
            ++n2;
        }
        return Messages.newProjectWizardRuntimePageNoRuntimeSelectedLabel;
    }

    private void validate() {
        if (this.getSelectedRuntime() != null) {
            String runtimeCamelVersion = this.determineRuntimeCamelVersion(this.getSelectedRuntime());
            if (UNKNOWN_CAMEL_VERSION.equals(runtimeCamelVersion)) {
                if (!Widgets.isDisposed((Control)this.camelVersionCombo)) {
                    this.camelVersionCombo.setEnabled(true);
                }
            } else {
                if (!this.isCompatible(runtimeCamelVersion, this.getSelectedCamelVersion())) {
                    this.camelInfoText.setText(NLS.bind((String)Messages.newProjectWizardRuntimePageCamelVersionsDontMatchWarning, (Object)runtimeCamelVersion));
                } else {
                    this.camelInfoText.setText("");
                }
                if (!Widgets.isDisposed((Control)this.camelVersionCombo)) {
                    this.camelVersionCombo.setEnabled(false);
                }
            }
        } else {
            if (!Widgets.isDisposed((Control)this.camelVersionCombo)) {
                this.camelVersionCombo.setEnabled(true);
            }
            if (!Widgets.isDisposed((Control)this.camelInfoText)) {
                this.camelInfoText.setText("");
            }
        }
        if (!Widgets.isDisposed((Control)this.warningIconLabel) && !Widgets.isDisposed((Control)this.camelInfoText)) {
            this.warningIconLabel.setVisible(this.camelInfoText.getText().length() > 0);
        }
        if (!Widgets.isDisposed((Control)this.runtimeCombo) && !Widgets.isDisposed((Control)this.camelVersionCombo)) {
            this.setPageComplete(!Strings.isBlank((String)this.runtimeCombo.getText()) && !Strings.isBlank((String)this.camelVersionCombo.getText()) && !this.warningIconLabel.isVisible());
        }
    }

    private void validateCamelVersion() {
        if (this.getSelectedCamelVersion() != null && !this.isCamelVersionValid(this.getSelectedCamelVersion())) {
            if (!Widgets.isDisposed((Control)this.camelInfoText)) {
                this.camelInfoText.setText(NLS.bind((String)Messages.newProjectWizardRuntimePageCamelVersionInvalidWarning, (Object)this.getSelectedCamelVersion()));
                this.setPageComplete(false);
            }
        } else if (!Widgets.isDisposed((Control)this.camelInfoText)) {
            this.camelInfoText.setText("");
        }
        if (!Widgets.isDisposed((Control)this.warningIconLabel) && !Widgets.isDisposed((Control)this.camelInfoText)) {
            this.warningIconLabel.setVisible(this.camelInfoText.getText().length() > 0);
        }
    }

    private boolean isCamelVersionValid(String camelVersion) {
        String[] stringArray = this.camelVersionCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedVersion = stringArray[n2];
            if (supportedVersion.equals(camelVersion)) {
                return true;
            }
            ++n2;
        }
        boolean camelVersionAvailable = false;
        try {
            Artifact camelCore = MavenPlugin.getMaven().resolve("org.apache.camel", "camel-core", camelVersion, "jar", null, null, (IProgressMonitor)new NullProgressMonitor());
            camelVersionAvailable = camelCore != null;
        }
        catch (CoreException coreException) {
            camelVersionAvailable = false;
        }
        return camelVersionAvailable;
    }

    public void preselectCamelVersionForRuntime(String runtimeCamelVersion) {
        if (Widgets.isDisposed((Control)this.camelVersionCombo)) {
            return;
        }
        if (UNKNOWN_CAMEL_VERSION.equals(runtimeCamelVersion)) {
            this.camelVersionCombo.setEnabled(true);
        } else {
            List compatibleVersions = Arrays.stream(this.camelVersionCombo.getItems()).filter(camelVersion -> this.isCompatible(runtimeCamelVersion, (String)camelVersion)).collect(Collectors.toList());
            if (!compatibleVersions.isEmpty()) {
                if (compatibleVersions.contains(runtimeCamelVersion)) {
                    this.camelVersionCombo.setText(runtimeCamelVersion);
                } else {
                    Collections.sort(compatibleVersions);
                    this.camelVersionCombo.setText((String)compatibleVersions.get(compatibleVersions.size() - 1));
                }
            } else {
                this.camelVersionCombo.select(Math.max(0, this.camelVersionCombo.getItemCount() - 1));
            }
        }
    }

    private String determineRuntimeCamelVersion(IRuntime runtime) {
        if (runtime != null) {
            File camelFolder;
            String[] versions;
            if (this.isJBossFuseRuntime(runtime)) {
                File camelFolder2 = runtime.getLocation().append("system").append("org").append("apache").append("camel").append("camel-core").toFile();
                String[] versions2 = camelFolder2.list();
                if (versions2.length == 1) {
                    return versions2[0];
                }
            } else if (this.isFuseOnEAPRuntime(runtime) && (versions = (camelFolder = runtime.getLocation().append("modules").append("system").append("layers").append("fuse").append("org").append("apache").append("camel").append("core").append("main").toFile()).list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().startsWith(FuseIntegrationProjectWizardRuntimeAndCamelPage.CAMEL_CORE_LIB_PREFIX) && name.toLowerCase().endsWith(FuseIntegrationProjectWizardRuntimeAndCamelPage.CAMEL_CORE_LIB_SUFFIX);
                }
            })).length == 1) {
                String jarName = versions[0];
                String version = jarName.substring(jarName.indexOf(CAMEL_CORE_LIB_PREFIX) + CAMEL_CORE_LIB_PREFIX.length(), jarName.indexOf(CAMEL_CORE_LIB_SUFFIX));
                return version;
            }
        }
        return UNKNOWN_CAMEL_VERSION;
    }

    private boolean isFuseOnEAPRuntime(IRuntime runtime) {
        return runtime.getRuntimeType().getId().startsWith(EAP_RUNTIME_PREFIX);
    }

    private boolean isJBossFuseRuntime(IRuntime runtime) {
        return runtime.getRuntimeType().getId().startsWith(FUSE_RUNTIME_PREFIX);
    }

    private boolean isCompatible(String runtimeCamelVersion, String selectedCamelVersion) {
        boolean rh_branded_scv;
        String[] runtimeVersionParts = runtimeCamelVersion.split("\\.");
        String[] camelVersionParts = selectedCamelVersion.split("\\.");
        boolean rh_branded_rcv = runtimeCamelVersion.indexOf(".redhat-") != -1;
        boolean bl = rh_branded_scv = selectedCamelVersion.indexOf(".redhat-") != -1;
        return runtimeVersionParts.length > 1 && camelVersionParts.length > 1 && runtimeVersionParts[0].equals(camelVersionParts[0]) && runtimeVersionParts[1].equals(camelVersionParts[1]) && rh_branded_rcv == rh_branded_scv;
    }

    public IRuntime getSelectedRuntime() {
        String runtimeId;
        if (!Widgets.isDisposed((Control)this.runtimeCombo) && !(runtimeId = this.runtimeCombo.getText()).equalsIgnoreCase(Messages.newProjectWizardRuntimePageNoRuntimeSelectedLabel)) {
            return this.serverRuntimes.get(runtimeId);
        }
        return null;
    }

    public String getSelectedCamelVersion() {
        if (!Widgets.isDisposed((Control)this.camelVersionCombo)) {
            return this.camelVersionCombo.getText();
        }
        return null;
    }

    private Image getSWTImage(final int imageID) {
        Display display;
        Shell shell = this.getShell();
        if (!Widgets.isDisposed((Control)shell)) {
            shell = shell.getParent().getShell();
        }
        if (Widgets.isDisposed((Control)shell)) {
            display = Display.getCurrent();
            Assert.isNotNull((Object)display, (String)"The dialog should be created in UI thread");
        } else {
            display = shell.getDisplay();
        }
        final Image[] image = new Image[1];
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                image[0] = display.getSystemImage(imageID);
            }
        });
        return image[0];
    }
}

