/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards.pages;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.foundation.ui.util.Widgets;
import org.fusesource.ide.projecttemplates.adopters.util.CamelDSLType;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.wizards.pages.filter.ExcludeEmptyCategoriesFilter;
import org.fusesource.ide.projecttemplates.wizards.pages.filter.TemplateNameAndKeywordPatternFilter;
import org.fusesource.ide.projecttemplates.wizards.pages.model.CategoryItem;
import org.fusesource.ide.projecttemplates.wizards.pages.model.TemplateItem;
import org.fusesource.ide.projecttemplates.wizards.pages.model.TemplateModel;
import org.fusesource.ide.projecttemplates.wizards.pages.provider.TemplateContentProvider;
import org.fusesource.ide.projecttemplates.wizards.pages.provider.TemplateLabelProvider;

public class FuseIntegrationProjectWizardTemplatePage
extends WizardPage {
    private Button btn_emptyProject;
    private Button btn_templateProject;
    private Button btn_blueprintDSL;
    private Button btn_springDSL;
    private Button btn_javaDSL;
    private FilteredTree list_templates;
    private Text templateInfoText;

    public FuseIntegrationProjectWizardTemplatePage() {
        super(Messages.newProjectWizardTemplatePageName);
        this.setTitle(Messages.newProjectWizardTemplatePageTitle);
        this.setDescription(Messages.newProjectWizardTemplatePageDescription);
        this.setImageDescriptor(ProjectTemplatesActivator.imageDescriptorFromPlugin((String)"org.fusesource.ide.projecttemplates", (String)"icons/camel_project_64x64.png"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label lbl_headline = new Label(container, 0);
        lbl_headline.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        lbl_headline.setText(Messages.newProjectWizardTemplatePageHeadlineLabel);
        Composite grp_emptyVsTemplate = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        grp_emptyVsTemplate.setLayout((Layout)gridLayout);
        grp_emptyVsTemplate.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.btn_emptyProject = new Button(grp_emptyVsTemplate, 16);
        this.btn_emptyProject.setText(Messages.newProjectWizardTemplatePageEmptyProjectLabel);
        this.btn_emptyProject.setToolTipText(Messages.newProjectWizardTemplatePageEmptyProjectDescription);
        this.btn_emptyProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FuseIntegrationProjectWizardTemplatePage.this.setTemplatesActive(false);
                FuseIntegrationProjectWizardTemplatePage.this.validate();
            }
        });
        this.btn_templateProject = new Button(grp_emptyVsTemplate, 16);
        this.btn_templateProject.setText(Messages.newProjectWizardTemplatePageTemplateProjectLabel);
        this.btn_templateProject.setToolTipText(Messages.newProjectWizardTemplatePageTemplateProjectDescription);
        this.btn_templateProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FuseIntegrationProjectWizardTemplatePage.this.setTemplatesActive(true);
                FuseIntegrationProjectWizardTemplatePage.this.validate();
            }
        });
        Composite templates = new Composite(grp_emptyVsTemplate, 0);
        GridData gd = new GridData(4, 4, true, true, 3, 1);
        gd.horizontalIndent = 20;
        templates.setLayoutData((Object)gd);
        templates.setLayout((Layout)new GridLayout(2, true));
        this.list_templates = this.createFilteredTree(templates);
        this.templateInfoText = new Text(templates, 2890);
        this.templateInfoText.setLayoutData((Object)new GridData(4, 4, true, true));
        Label spacer = new Label(container, 0);
        spacer.setLayoutData((Object)new GridData(16384, 128, true, false, 3, 1));
        Label lbl_dsl = new Label(container, 0);
        lbl_dsl.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        lbl_dsl.setText(Messages.newProjectWizardTemplatePageDSLLabel);
        Composite grp_dslSelection = new Composite(container, 0);
        gridLayout = new GridLayout(1, false);
        grp_dslSelection.setLayout((Layout)gridLayout);
        gd = new GridData(16384, 128, true, false, 3, 1);
        gd.horizontalIndent = 20;
        grp_dslSelection.setLayoutData((Object)gd);
        this.btn_blueprintDSL = new Button(grp_dslSelection, 16);
        this.btn_blueprintDSL.setText(Messages.newProjectWizardTemplatePageBlueprintDSLLabel);
        this.btn_blueprintDSL.setToolTipText(Messages.newProjectWizardTemplatePageBlueprintDSLDescription);
        this.btn_blueprintDSL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FuseIntegrationProjectWizardTemplatePage.this.validate();
            }
        });
        this.btn_springDSL = new Button(grp_dslSelection, 16);
        this.btn_springDSL.setText(Messages.newProjectWizardTemplatePageSpringDSLLabel);
        this.btn_springDSL.setToolTipText(Messages.newProjectWizardTemplatePageSpringDSLDescription);
        this.btn_springDSL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FuseIntegrationProjectWizardTemplatePage.this.validate();
            }
        });
        this.btn_javaDSL = new Button(grp_dslSelection, 16);
        this.btn_javaDSL.setText(Messages.newProjectWizardTemplatePageJavaDSLLabel);
        this.btn_javaDSL.setToolTipText(Messages.newProjectWizardTemplatePageJavaDSLDescription);
        this.btn_javaDSL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FuseIntegrationProjectWizardTemplatePage.this.validate();
            }
        });
        this.btn_emptyProject.setSelection(true);
        this.btn_blueprintDSL.setSelection(true);
        this.setControl((Control)container);
        this.setTemplatesActive(false);
        this.validate();
    }

    private FilteredTree createFilteredTree(Composite parent) {
        this.list_templates = new FilteredTree(parent, 2820, (PatternFilter)new TemplateNameAndKeywordPatternFilter(), true);
        this.list_templates.getFilterControl().setMessage(Messages.newProjectWizardTemplatePageFilterBoxText);
        this.list_templates.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).create());
        this.list_templates.getViewer().setContentProvider((IContentProvider)new TemplateContentProvider());
        this.list_templates.getViewer().setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.list_templates.getViewer().addFilter((ViewerFilter)new ExcludeEmptyCategoriesFilter());
        this.list_templates.getViewer().setInput((Object)this.getTemplates());
        this.list_templates.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selObj;
                if (!event.getSelection().isEmpty() && (selObj = Selections.getFirstSelection((ISelection)event.getSelection())) instanceof TemplateItem) {
                    FuseIntegrationProjectWizardTemplatePage.this.updateTemplateInfo((TemplateItem)selObj);
                    FuseIntegrationProjectWizardTemplatePage.this.updateDSLButtonGroup((TemplateItem)selObj);
                    FuseIntegrationProjectWizardTemplatePage.this.validate();
                    return;
                }
                FuseIntegrationProjectWizardTemplatePage.this.updateTemplateInfo(null);
            }
        });
        return this.list_templates;
    }

    private void updateTemplateInfo(TemplateItem template) {
        if (template == null) {
            this.btn_blueprintDSL.setEnabled(true);
            this.btn_springDSL.setEnabled(true);
            this.btn_javaDSL.setEnabled(true);
            this.templateInfoText.setText("");
        } else {
            this.btn_blueprintDSL.setEnabled(template.getTemplate().supportsDSL(CamelDSLType.BLUEPRINT));
            this.btn_springDSL.setEnabled(template.getTemplate().supportsDSL(CamelDSLType.SPRING));
            this.btn_javaDSL.setEnabled(template.getTemplate().supportsDSL(CamelDSLType.JAVA));
            this.templateInfoText.setText(template.getDescription());
        }
        this.validate();
    }

    public TemplateModel getTemplates() {
        return new TemplateModel();
    }

    private void setTemplatesActive(boolean active) {
        this.list_templates.getViewer().getTree().setEnabled(active);
        this.list_templates.getViewer().getTree().getParent().setEnabled(active);
        this.list_templates.getFilterControl().setEnabled(active);
        this.list_templates.setEnabled(active);
        this.templateInfoText.setEnabled(active);
        if (!active) {
            this.btn_blueprintDSL.setEnabled(true);
            this.btn_springDSL.setEnabled(true);
            this.btn_javaDSL.setEnabled(true);
        } else {
            this.btn_blueprintDSL.setEnabled(this.getSelectedTemplate() != null && this.getSelectedTemplate().getTemplate().supportsDSL(CamelDSLType.BLUEPRINT));
            this.btn_springDSL.setEnabled(this.getSelectedTemplate() != null && this.getSelectedTemplate().getTemplate().supportsDSL(CamelDSLType.SPRING));
            this.btn_javaDSL.setEnabled(this.getSelectedTemplate() != null && this.getSelectedTemplate().getTemplate().supportsDSL(CamelDSLType.JAVA));
            this.updateDSLButtonGroup(this.getSelectedTemplate());
        }
    }

    private void selectFirstSupportedDSLType(TemplateItem template) {
        CamelDSLType[] camelDSLTypeArray = CamelDSLType.values();
        int n = camelDSLTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CamelDSLType dslType = camelDSLTypeArray[n2];
            if (template.getTemplate().supportsDSL(dslType)) {
                this.selectButtonForDSL(dslType);
                return;
            }
            ++n2;
        }
    }

    private void updateDSLButtonGroup(TemplateItem template) {
        if (template == null || !this.disabledDSLSelected()) {
            return;
        }
        this.selectFirstSupportedDSLType(template);
    }

    private void selectButtonForDSL(CamelDSLType dsltype) {
        if (dsltype.equals((Object)CamelDSLType.BLUEPRINT)) {
            this.btn_blueprintDSL.setSelection(true);
            this.btn_javaDSL.setSelection(false);
            this.btn_springDSL.setSelection(false);
        } else if (dsltype.equals((Object)CamelDSLType.JAVA)) {
            this.btn_blueprintDSL.setSelection(false);
            this.btn_javaDSL.setSelection(true);
            this.btn_springDSL.setSelection(false);
        } else {
            this.btn_blueprintDSL.setSelection(false);
            this.btn_javaDSL.setSelection(false);
            this.btn_springDSL.setSelection(true);
        }
    }

    private boolean isSelectedAndDisabled(Button button) {
        return button.getSelection() && !button.isEnabled();
    }

    private boolean disabledDSLSelected() {
        return this.isSelectedAndDisabled(this.btn_blueprintDSL) || this.isSelectedAndDisabled(this.btn_javaDSL) || this.isSelectedAndDisabled(this.btn_springDSL);
    }

    private void validate() {
        if (this.btn_templateProject.getSelection() && (this.list_templates.getViewer().getSelection().isEmpty() || Selections.getFirstSelection((ISelection)this.list_templates.getViewer().getSelection()) instanceof CategoryItem || !this.isSelectedDSLSupported())) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    private boolean isSelectedDSLSupported() {
        CamelDSLType dsl = null;
        if (this.btn_blueprintDSL.getSelection()) {
            dsl = CamelDSLType.BLUEPRINT;
        } else if (this.btn_springDSL.getSelection()) {
            dsl = CamelDSLType.SPRING;
        } else if (this.btn_javaDSL.getSelection()) {
            dsl = CamelDSLType.JAVA;
        }
        return dsl != null && this.getSelectedTemplate() != null && this.getSelectedTemplate().getTemplate() != null && this.getSelectedTemplate().getTemplate().supportsDSL(dsl);
    }

    public boolean isEmptyProject() {
        if (!Widgets.isDisposed((Control)this.btn_emptyProject)) {
            return this.btn_emptyProject.getSelection();
        }
        return this.getSelectedTemplate() == null;
    }

    public boolean isTemplateProject() {
        if (this.btn_templateProject != null && !this.btn_templateProject.isDisposed()) {
            return this.btn_templateProject.getSelection();
        }
        return false;
    }

    public TemplateItem getSelectedTemplate() {
        Object o;
        if (this.btn_templateProject.getSelection() && !this.list_templates.getViewer().getSelection().isEmpty() && (o = Selections.getFirstSelection((ISelection)this.list_templates.getViewer().getSelection())) instanceof TemplateItem) {
            return (TemplateItem)o;
        }
        return null;
    }

    public CamelDSLType getDSL() {
        if (this.btn_blueprintDSL.getSelection()) {
            return CamelDSLType.BLUEPRINT;
        }
        if (this.btn_springDSL.getSelection()) {
            return CamelDSLType.SPRING;
        }
        if (this.btn_javaDSL.getSelection()) {
            return CamelDSLType.JAVA;
        }
        return null;
    }

    public FilteredTree getList_templates() {
        return this.list_templates;
    }

    public Button getBtn_blueprintDSL() {
        return this.btn_blueprintDSL;
    }

    public Button getBtn_javaDSL() {
        return this.btn_javaDSL;
    }

    public Button getBtn_springDSL() {
        return this.btn_springDSL;
    }

    public Button getBtn_templateProject() {
        return this.btn_templateProject;
    }
}

