/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.aspects.uml;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.uml.UmlClassifier;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.xsd.PluginConstants;
import org.teiid.designer.xsd.aspects.uml.AbstractXsdEntityAspect;
import org.teiid.designer.xsd.util.ModelerXsdUtils;

public class EnumeratedTypeAspect
extends AbstractXsdEntityAspect
implements PluginConstants,
UmlClassifier {
    public EnumeratedTypeAspect(MetamodelEntity theEntity) {
        super(theEntity);
    }

    private XSDSimpleTypeDefinition assertEnumeratedType(Object theObject) {
        if (theObject != null && theObject instanceof EObject && ModelerXsdUtils.isEnumeratedType((EObject)theObject)) {
            return (XSDSimpleTypeDefinition)theObject;
        }
        String msg = Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(EnumeratedTypeAspect.class)) + "nullOrWrongType", new Object[0]);
        throw new IllegalArgumentException(msg);
    }

    public String getEditableSignature(Object theObject) {
        return this.getSignature(theObject, 1);
    }

    public Collection getRelationships(Object theObject) {
        return Collections.EMPTY_LIST;
    }

    public String getSignature(Object theObject, int theShowMask) {
        XSDSimpleTypeDefinition type = this.assertEnumeratedType(theObject);
        StringBuffer result = new StringBuffer();
        switch (theShowMask) {
            case 1: {
                EObject parent;
                String name = type.getName();
                if (CoreStringUtil.isEmpty((String)name) && (parent = type.eContainer()) instanceof XSDNamedComponent) {
                    name = ((XSDNamedComponent)parent).getName();
                }
                result.append(name);
                break;
            }
            case 2: {
                result.append("<<");
                result.append(this.getStereotype(theObject));
                result.append(">>");
                break;
            }
            case 3: {
                result.append("<<");
                result.append(this.getStereotype(theObject));
                result.append(">> ");
                result.append(this.getSignature(theObject, 1));
                break;
            }
            default: {
                String msg = Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(EnumeratedTypeAspect.class)) + "invalidShowMask", (Object)new Integer(theShowMask));
                throw new TeiidDesignerRuntimeException(msg);
            }
        }
        return result.toString();
    }

    public String getStereotype(Object theObject) {
        String PREFIX = I18nUtil.getPropertyPrefix(EnumeratedTypeAspect.class);
        XSDSimpleTypeDefinition type = this.assertEnumeratedType(theObject);
        DatatypeManager dm = ModelerCore.getDatatypeManager((EObject)type);
        type = (XSDSimpleTypeDefinition)dm.getBuiltInPrimitiveType((EObject)type);
        String result = null;
        XSDLengthFacet lengthFacet = type.getLengthFacet();
        result = lengthFacet == null ? Util.getString(String.valueOf(PREFIX) + "stereoType", (Object)type.getName()) : Util.getString(String.valueOf(PREFIX) + "stereoTypeWithLength", new Object[]{type.getName(), lengthFacet.getEffectiveValue()});
        return result;
    }

    public Collection getSupertypes(Object theObject) {
        return Collections.EMPTY_LIST;
    }

    public boolean isAbstract(Object theObject) {
        return false;
    }

    public IStatus setSignature(Object theObject, String theNewSignature) {
        return Status.OK_STATUS;
    }
}

