/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.aspects.uml;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.uml.UmlProperty;
import org.teiid.designer.xsd.PluginConstants;
import org.teiid.designer.xsd.aspects.uml.AbstractXsdEntityAspect;
import org.teiid.designer.xsd.util.ModelerXsdUtils;

public class EnumeratedTypeValueAspect
extends AbstractXsdEntityAspect
implements PluginConstants,
UmlProperty {
    public EnumeratedTypeValueAspect(MetamodelEntity theEntity) {
        super(theEntity);
    }

    private XSDEnumerationFacet assertEnumeratedValue(Object theObject) {
        if (theObject instanceof EObject && ModelerXsdUtils.isEnumeratedTypeValue((EObject)theObject)) {
            return (XSDEnumerationFacet)theObject;
        }
        String msg = Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(EnumeratedTypeValueAspect.class)) + "nullOrWrongType", new Object[0]);
        throw new IllegalArgumentException(msg);
    }

    public String getEditableSignature(Object theObject) {
        return this.getSignature(theObject, 1);
    }

    private Object getNormalizedValue(Object theValue) {
        Object result = theValue;
        if (theValue != null) {
            if (theValue instanceof Collection && !((Collection)theValue).isEmpty()) {
                result = ((Collection)theValue).iterator().next();
            } else if (theValue instanceof Object[] && ((Object[])theValue).length != 0) {
                result = ((Object[])theValue)[0];
            }
        }
        return result;
    }

    public String getSignature(Object theObject, int theShowMaskFlag) {
        XSDEnumerationFacet value = this.assertEnumeratedValue(theObject);
        StringBuffer result = new StringBuffer();
        switch (theShowMaskFlag) {
            case 1: 
            case 17: {
                result.append(this.getNormalizedValue(value.getEffectiveValue()));
                break;
            }
            case 2: 
            case 18: {
                result.append("<<");
                result.append(this.getStereotype(theObject));
                result.append(">>");
                break;
            }
            case 3: 
            case 19: {
                result.append("<<");
                result.append(this.getStereotype(theObject));
                result.append(">> ");
                result.append(this.getNormalizedValue(value.getEffectiveValue()));
                break;
            }
            default: {
                result.append(this.getSignature(theObject, 1));
            }
        }
        return result.toString();
    }

    public String getStereotype(Object theObject) {
        return Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(EnumeratedTypeValueAspect.class)) + "stereoType", new Object[0]);
    }

    public boolean isAssociationEnd(Object theProperty) {
        return false;
    }

    public IStatus setSignature(Object theObject, String theNewSignature) {
        return Status.OK_STATUS;
    }
}

