/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.eclipse.jface.resource.ImageDescriptor;

public class FetchOperationalAttributesAction
extends BrowserAction {
    public int getStyle() {
        return 2;
    }

    @Override
    public String getText() {
        return Messages.getString("FetchOperationalAttributesAction.FetchOperationalAttributes");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getCommandId() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        List<IEntry> entries = this.getEntries();
        return !entries.isEmpty() && !entries.iterator().next().getBrowserConnection().isFetchOperationalAttributes();
    }

    public boolean isChecked() {
        boolean checked = true;
        List<IEntry> entries = this.getEntries();
        if (entries.isEmpty()) {
            checked = false;
        } else {
            for (IEntry entry : entries) {
                if (entry.isInitOperationalAttributes()) continue;
                checked = false;
            }
        }
        return checked;
    }

    @Override
    public void run() {
        IEntry[] entries = this.getEntries().toArray(new IEntry[0]);
        boolean init = !this.isChecked();
        IEntry[] iEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IEntry entry = iEntryArray[n2];
            entry.setInitOperationalAttributes(init);
            ++n2;
        }
        new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new InitializeAttributesRunnable(entries)}).execute();
    }

    protected List<IEntry> getEntries() {
        IEntry input;
        IEntry entry;
        ArrayList<IEntry> entriesList = new ArrayList<IEntry>();
        entriesList.addAll(Arrays.asList(this.getSelectedEntries()));
        ISearchResult[] iSearchResultArray = this.getSelectedSearchResults();
        int n = iSearchResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchResult sr = iSearchResultArray[n2];
            entriesList.add(sr.getEntry());
            ++n2;
        }
        iSearchResultArray = this.getSelectedBookmarks();
        n = iSearchResultArray.length;
        n2 = 0;
        while (n2 < n) {
            ISearchResult bm = iSearchResultArray[n2];
            entriesList.add(bm.getEntry());
            ++n2;
        }
        if (this.getInput() != null && this.getInput() instanceof IEntry && (entry = (input = (IEntry)this.getInput()).getBrowserConnection().getEntryFromCache(input.getDn())) != null) {
            entriesList.add(entry);
        }
        return entriesList;
    }
}

