/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class ValuesTransfer
extends ByteArrayTransfer {
    private static final String TYPENAME = BrowserCommonConstants.DND_VALUES_TRANSFER;
    private static final int TYPEID = ValuesTransfer.registerType((String)TYPENAME);
    private static ValuesTransfer instance = new ValuesTransfer();

    public static ValuesTransfer getInstance() {
        return instance;
    }

    private ValuesTransfer() {
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof IValue[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            IValue[] values = (IValue[])object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                int i = 0;
                while (i < values.length) {
                    byte[] value;
                    byte[] connectionId = values[i].getAttribute().getEntry().getBrowserConnection().getConnection().getId().getBytes("UTF-8");
                    writeOut.writeInt(connectionId.length);
                    writeOut.write(connectionId);
                    byte[] dn = values[i].getAttribute().getEntry().getDn().getName().getBytes("UTF-8");
                    writeOut.writeInt(dn.length);
                    writeOut.write(dn);
                    byte[] attributeName = values[i].getAttribute().getDescription().getBytes("UTF-8");
                    writeOut.writeInt(attributeName.length);
                    writeOut.write(attributeName);
                    if (values[i].isString()) {
                        value = values[i].getStringValue().getBytes("UTF-8");
                        writeOut.writeBoolean(true);
                        writeOut.writeInt(value.length);
                        writeOut.write(value);
                    } else if (values[i].isBinary()) {
                        value = values[i].getBinaryValue();
                        writeOut.writeBoolean(false);
                        writeOut.writeInt(value.length);
                        writeOut.write(value);
                    }
                    ++i;
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        try {
            if (!this.isSupportedType(transferData)) return null;
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            ArrayList<IValue> valueList = new ArrayList<IValue>();
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                DataInputStream readIn = new DataInputStream(in);
                do {
                    IBrowserConnection connection = null;
                    if (readIn.available() > 1) {
                        int size = readIn.readInt();
                        byte[] connectionId = new byte[size];
                        readIn.read(connectionId);
                        connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(new String(connectionId, "UTF-8"));
                    }
                    IEntry entry = null;
                    if (readIn.available() <= 1) return null;
                    if (connection == null) return null;
                    int size = readIn.readInt();
                    byte[] dn = new byte[size];
                    readIn.read(dn);
                    entry = connection.getEntryFromCache(new Dn(new String[]{new String(dn, "UTF-8")}));
                    IAttribute attribute = null;
                    if (readIn.available() <= 1) return null;
                    if (entry == null) return null;
                    int size2 = readIn.readInt();
                    byte[] attributeName = new byte[size2];
                    readIn.read(attributeName);
                    attribute = entry.getAttribute(new String(attributeName, "UTF-8"));
                    IValue value = null;
                    if (readIn.available() <= 1) return null;
                    if (attribute == null) return null;
                    boolean isString = readIn.readBoolean();
                    int size3 = readIn.readInt();
                    byte[] val = new byte[size3];
                    readIn.read(val);
                    String test = new String(val, "UTF-8");
                    IValue[] values = attribute.getValues();
                    int i = 0;
                    while (i < values.length) {
                        if (isString && values[i].isString() && test.equals(values[i].getStringValue())) {
                            value = values[i];
                            break;
                        }
                        if (!isString && values[i].isBinary() && test.equals(new String(values[i].getBinaryValue()))) {
                            value = values[i];
                            break;
                        }
                        ++i;
                    }
                    if (value == null) continue;
                    valueList.add(value);
                } while (readIn.available() > 1);
                readIn.close();
            }
            catch (IOException iOException) {
                return null;
            }
            if (valueList.isEmpty()) {
                return null;
            }
            IValue[] iValueArray = valueList.toArray(new IValue[valueList.size()]);
            return iValueArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }
}

