/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.filtereditor;

import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapAndFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapNotFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapOrFilterComponent;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;

public class FilterAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy
implements IAutoEditStrategy {
    public static final String INDENT_STRING = "    ";
    private LdapFilterParser parser;

    public FilterAutoEditStrategy(LdapFilterParser parser) {
        this.parser = parser;
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        super.customizeDocumentCommand(d, c);
        AutoEditParameters aep = new AutoEditParameters(c.text, c.offset, c.length, c.caretOffset, c.shiftsCaret);
        this.customizeAutoEditParameters(d.get(), aep);
        c.offset = aep.offset;
        c.length = aep.length;
        c.text = aep.text;
        c.caretOffset = aep.caretOffset;
        c.shiftsCaret = aep.shiftsCaret;
    }

    public void customizeAutoEditParameters(String currentFilter, AutoEditParameters aep) {
        this.parser.parse(currentFilter);
        LdapFilter filter = this.parser.getModel().getFilter(aep.offset);
        if (filter == null) {
            return;
        }
        int balanced = 0;
        int i = 0;
        while (i < currentFilter.length()) {
            if (currentFilter.charAt(i) == '(') {
                ++balanced;
            } else if (currentFilter.charAt(i) == ')') {
                --balanced;
            }
            ++i;
        }
        if (aep.length > 0 && (aep.text == null || "".equals(aep.text))) {
            if (filter.toString().length() - aep.length == 2 && filter.getStartToken() != null && filter.getStopToken() != null && aep.offset >= filter.getStartToken().getOffset() + filter.getStartToken().getLength() && aep.offset + aep.length <= filter.getStopToken().getOffset() && filter.toString().length() - aep.length == 2) {
                --aep.offset;
                aep.length += 2;
                aep.caretOffset = aep.offset;
                aep.shiftsCaret = false;
            }
            if (filter.toString().length() - aep.length == 1 && filter.getStartToken() != null && filter.getStopToken() != null && aep.offset == filter.getStartToken().getOffset()) {
                ++aep.length;
                aep.caretOffset = aep.offset;
                aep.shiftsCaret = false;
            }
        }
        if (!(aep.length != 0 && aep.length != currentFilter.length() || aep.text == null || "".equals(aep.text))) {
            boolean isNewFilter = aep.text.equals("(");
            boolean isNewNestedFilter = aep.text.equals("&") || aep.text.equals("|") || aep.text.equals("!");
            boolean isSurroundNew = false;
            boolean isSurroundNested = false;
            boolean isSurroundBeforeOtherFilter = false;
            boolean isSurroundAfterOtherFilter = false;
            if (!(Character.isWhitespace(aep.text.charAt(0)) || aep.text.startsWith("(") || aep.text.endsWith(")"))) {
                boolean bl = isSurroundNew = aep.offset == 0;
                if (filter.getStartToken() != null && filter.getFilterComponent() != null && (filter.getFilterComponent() instanceof LdapAndFilterComponent || filter.getFilterComponent() instanceof LdapOrFilterComponent || filter.getFilterComponent() instanceof LdapNotFilterComponent)) {
                    LdapFilterComponent fc = filter.getFilterComponent();
                    LdapFilter[] filters = fc.getFilters();
                    if (filters.length == 0 && aep.offset > fc.getStartToken().getOffset()) {
                        isSurroundNested = true;
                    }
                    if (filters.length > 0 && aep.offset > fc.getStartToken().getOffset() && aep.offset < filters[0].getStartToken().getOffset()) {
                        isSurroundNested = true;
                    }
                    if (filters.length > 0 && aep.offset > filters[filters.length - 1].getStopToken().getOffset() && aep.offset <= filter.getStopToken().getOffset()) {
                        isSurroundNested = true;
                    }
                    int i2 = 0;
                    while (i2 < filters.length) {
                        if (filters.length > i2 + 1 && aep.offset > filters[i2].getStopToken().getOffset() && aep.offset <= filters[i2 + 1].getStopToken().getOffset()) {
                            isSurroundNested = true;
                        }
                        ++i2;
                    }
                }
                isSurroundBeforeOtherFilter = filter.getStartToken() != null && aep.offset == filter.getStartToken().getOffset();
                boolean bl2 = isSurroundAfterOtherFilter = filter.getStopToken() != null && aep.offset == filter.getStopToken().getOffset() && (filter.getFilterComponent() instanceof LdapAndFilterComponent || filter.getFilterComponent() instanceof LdapOrFilterComponent || filter.getFilterComponent() instanceof LdapNotFilterComponent);
            }
            if (isSurroundNew || isSurroundNested || isSurroundAfterOtherFilter || isSurroundBeforeOtherFilter) {
                aep.text = "(" + aep.text;
                aep.caretOffset = aep.offset + aep.text.length();
                aep.shiftsCaret = false;
            }
            if (isNewNestedFilter) {
                aep.text = String.valueOf(aep.text) + "()";
                aep.caretOffset = aep.offset + aep.text.length() - 1;
                aep.shiftsCaret = false;
            }
            if ((isNewFilter || isSurroundNew || isSurroundNested || isSurroundAfterOtherFilter || isSurroundBeforeOtherFilter) && balanced == 0) {
                aep.text = String.valueOf(aep.text) + ")";
                if (aep.caretOffset == -1) {
                    aep.caretOffset = aep.offset + aep.text.length() - 1;
                    aep.shiftsCaret = false;
                }
            }
            if (aep.text.equals("\t")) {
                aep.text = INDENT_STRING;
            }
        }
    }

    public static class AutoEditParameters {
        public String text;
        public int offset;
        public int length;
        public int caretOffset;
        public boolean shiftsCaret;

        public AutoEditParameters(String text, int offset, int length, int caretOffset, boolean shiftsCaret) {
            this.text = text;
            this.offset = offset;
            this.length = length;
            this.caretOffset = caretOffset;
            this.shiftsCaret = shiftsCaret;
        }
    }
}

