/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.filtereditor;

import java.util.ArrayList;
import org.apache.directory.studio.common.ui.CommonUIConstants;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.FilterCharacterPairMatcher;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.MatchingCharacterPainter;

public class FilterReconcilingStrategy
implements IReconcilingStrategy {
    private ISourceViewer sourceViewer;
    private LdapFilterParser parser;
    private PaintManager paintManager;

    public FilterReconcilingStrategy(ISourceViewer sourceViewer, LdapFilterParser parser) {
        this.sourceViewer = sourceViewer;
        this.parser = parser;
        this.paintManager = null;
    }

    public void setDocument(IDocument document) {
        if (this.sourceViewer.getAnnotationModel() == null) {
            AnnotationModel model = new AnnotationModel();
            this.sourceViewer.setDocument(this.sourceViewer.getDocument(), (IAnnotationModel)model);
        }
        if (this.paintManager == null && this.sourceViewer.getAnnotationModel() instanceof IAnnotationModelExtension) {
            AnnotationPainter ap = new AnnotationPainter(this.sourceViewer, null);
            ap.addAnnotationType((Object)"DEFAULT");
            ap.setAnnotationTypeColor((Object)"DEFAULT", CommonUIConstants.RED_COLOR);
            this.sourceViewer.getAnnotationModel().addAnnotationModelListener((IAnnotationModelListener)ap);
            FilterCharacterPairMatcher cpm = new FilterCharacterPairMatcher(this.sourceViewer, this.parser);
            MatchingCharacterPainter mcp = new MatchingCharacterPainter(this.sourceViewer, (ICharacterPairMatcher)cpm);
            mcp.setColor(CommonUIConstants.ML_GREY_COLOR);
            this.paintManager = new PaintManager((ITextViewer)this.sourceViewer);
            this.paintManager.addPainter((IPainter)ap);
            this.paintManager.addPainter((IPainter)mcp);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile((IRegion)dirtyRegion);
    }

    public void reconcile(IRegion partition) {
        LdapFilterToken[] tokens = this.parser.getModel().getTokens();
        if (this.sourceViewer.getAnnotationModel() instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)this.sourceViewer.getAnnotationModel()).removeAllAnnotations();
            ArrayList<Position> positionList = new ArrayList<Position>();
            LdapFilter[] invalidFilters = this.parser.getModel().getInvalidFilters();
            int i = 0;
            while (i < invalidFilters.length) {
                if (invalidFilters[i].getStartToken() != null) {
                    int start = invalidFilters[i].getStartToken().getOffset();
                    int stop = invalidFilters[i].getStopToken() != null ? invalidFilters[i].getStopToken().getOffset() + invalidFilters[i].getStopToken().getLength() : start + invalidFilters[i].getStartToken().getLength();
                    Annotation annotation = new Annotation("DEFAULT", true, invalidFilters[i].toString());
                    Position position = new Position(start, stop - start);
                    positionList.add(position);
                    this.sourceViewer.getAnnotationModel().addAnnotation(annotation, position);
                }
                ++i;
            }
            i = 0;
            while (i < tokens.length) {
                if (tokens[i].getType() == -2) {
                    boolean overlaps = false;
                    int k = 0;
                    while (k < positionList.size()) {
                        Position pos = (Position)positionList.get(k);
                        if (pos.overlapsWith(tokens[i].getOffset(), tokens[i].getLength())) {
                            overlaps = true;
                            break;
                        }
                        ++k;
                    }
                    if (!overlaps) {
                        Annotation annotation = new Annotation("DEFAULT", true, tokens[i].getValue());
                        Position position = new Position(tokens[i].getOffset(), tokens[i].getLength());
                        this.sourceViewer.getAnnotationModel().addAnnotation(annotation, position);
                    }
                }
                ++i;
            }
        }
    }
}

