/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.common.ui.widgets.ViewFormWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetConfiguration;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetQuickFilterWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetTableMetadata;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class EntryEditorWidget
extends ViewFormWidget {
    private EntryEditorWidgetConfiguration configuration;
    private EntryEditorWidgetQuickFilterWidget quickFilterWidget;
    private Tree tree;
    private TreeViewer viewer;

    public EntryEditorWidget(EntryEditorWidgetConfiguration configuration) {
        this.configuration = configuration;
    }

    protected Control createContent(Composite parent) {
        this.quickFilterWidget = new EntryEditorWidgetQuickFilterWidget(this.configuration.getFilter(), this);
        this.quickFilterWidget.createComposite(parent);
        this.tree = new Tree(parent, 101122);
        GridData data = new GridData(1808);
        data.widthHint = 450;
        data.heightHint = 250;
        this.tree.setLayoutData((Object)data);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.viewer = new TreeViewer(this.tree);
        this.viewer.setUseHashlookup(true);
        int i = 0;
        while (i < EntryEditorWidgetTableMetadata.COLUM_NAMES.length) {
            TreeColumn column = new TreeColumn(this.tree, 16384, i);
            column.setText(EntryEditorWidgetTableMetadata.COLUM_NAMES[i]);
            column.setWidth(200);
            column.setResizable(true);
            ++i;
        }
        this.viewer.setColumnProperties(EntryEditorWidgetTableMetadata.COLUM_NAMES);
        this.tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (((EntryEditorWidget)EntryEditorWidget.this).tree.getClientArea().width > 0) {
                    int width = ((EntryEditorWidget)EntryEditorWidget.this).tree.getClientArea().width - 2 * EntryEditorWidget.this.tree.getBorderWidth();
                    if (EntryEditorWidget.this.tree.getVerticalBar().isVisible()) {
                        width -= ((EntryEditorWidget)EntryEditorWidget.this).tree.getVerticalBar().getSize().x;
                    }
                    EntryEditorWidget.this.tree.getColumn(1).setWidth(width - EntryEditorWidget.this.tree.getColumn(0).getWidth());
                }
            }
        });
        this.configuration.getSorter().connect(this.viewer);
        this.configuration.getFilter().connect(this.viewer);
        this.configuration.getPreferences().connect(this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.configuration.getContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.configuration.getLabelProvider(this.viewer));
        this.viewer.setCellModifier((ICellModifier)this.configuration.getCellModifier(this.viewer));
        CellEditor[] editors = new CellEditor[EntryEditorWidgetTableMetadata.COLUM_NAMES.length];
        this.viewer.setCellEditors(editors);
        return this.tree;
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void dispose() {
        if (this.viewer != null) {
            this.configuration.dispose();
            this.configuration = null;
            if (this.quickFilterWidget != null) {
                this.quickFilterWidget.dispose();
                this.quickFilterWidget = null;
            }
            this.tree.dispose();
            this.tree = null;
            this.viewer = null;
        }
        super.dispose();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public EntryEditorWidgetQuickFilterWidget getQuickFilterWidget() {
        return this.quickFilterWidget;
    }

    public void setEnabled(boolean enabled) {
        this.tree.setEnabled(enabled);
    }
}

