/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetPreferences;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeColumn;

public class EntryEditorWidgetSorter
extends ViewerSorter
implements SelectionListener {
    private TreeViewer viewer;
    private int sortBy = 0;
    private int sortOrder = 0;
    private EntryEditorWidgetPreferences preferences;

    public EntryEditorWidgetSorter(EntryEditorWidgetPreferences preferences) {
        this.preferences = preferences;
    }

    public void connect(TreeViewer viewer) {
        this.viewer = viewer;
        viewer.setSorter((ViewerSorter)this);
        TreeColumn[] columns = viewer.getTree().getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].addSelectionListener((SelectionListener)this);
            ++i;
        }
    }

    public void dispose() {
        this.viewer = null;
        this.preferences = null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof TreeColumn && this.viewer != null) {
            int index = this.viewer.getTree().indexOf((TreeColumn)e.widget);
            switch (index) {
                case 0: {
                    if (this.sortBy == 3) {
                        this.sortOrder = this.sortOrder == 0 ? 1 : (this.sortOrder == 1 ? 2 : 0);
                        break;
                    }
                    this.sortBy = 3;
                    this.sortOrder = 1;
                    break;
                }
                case 1: {
                    if (this.sortBy == 4) {
                        this.sortOrder = this.sortOrder == 0 ? 1 : (this.sortOrder == 1 ? 2 : 0);
                        break;
                    }
                    this.sortBy = 4;
                    this.sortOrder = 1;
                }
            }
            if (this.sortOrder == 0) {
                this.sortBy = 0;
            }
            TreeColumn[] columns = this.viewer.getTree().getColumns();
            int i = 0;
            while (i < columns.length) {
                columns[i].setImage(null);
                ++i;
            }
            if (this.sortOrder == 1) {
                ((TreeColumn)e.widget).setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/sort_ascending.gif"));
            } else if (this.sortOrder == 2) {
                ((TreeColumn)e.widget).setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/sort_descending.gif"));
            }
            this.viewer.refresh();
        }
    }

    public void sort(final Viewer viewer, Object[] elements) {
        Arrays.sort(elements, new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                return EntryEditorWidgetSorter.this.compare(viewer, a, b);
            }
        });
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        IAttribute attribute1 = null;
        IValue value1 = null;
        if (o1 instanceof IAttribute) {
            attribute1 = (IAttribute)o1;
        } else if (o1 instanceof IValue) {
            value1 = (IValue)o1;
            attribute1 = value1.getAttribute();
        }
        IAttribute attribute2 = null;
        IValue value2 = null;
        if (o2 instanceof IAttribute) {
            attribute2 = (IAttribute)o2;
        } else if (o2 instanceof IValue) {
            value2 = (IValue)o2;
            attribute2 = value2.getAttribute();
        }
        if (value1 != null && value2 != null) {
            if (this.getSortByOrDefault() == 3) {
                if (value1.getAttribute() != value2.getAttribute()) {
                    return this.compareAttributes(value1.getAttribute(), value2.getAttribute());
                }
                return this.compareValues(value1, value2);
            }
            if (this.getSortByOrDefault() == 4) {
                return this.compareValues(value1, value2);
            }
            return this.equal();
        }
        if (attribute1 != null && attribute2 != null) {
            return this.compareAttributes(attribute1, attribute2);
        }
        return this.equal();
    }

    private int compareAttributes(IAttribute attribute1, IAttribute attribute2) {
        if (this.sortOrder == 0) {
            if (this.preferences == null || this.preferences.isObjectClassAndMustAttributesFirst()) {
                if (attribute1.isObjectClassAttribute()) {
                    return this.lessThan();
                }
                if (attribute2.isObjectClassAttribute()) {
                    return this.greaterThan();
                }
                if (attribute1.isMustAttribute() && !attribute2.isMustAttribute()) {
                    return this.lessThan();
                }
                if (attribute2.isMustAttribute() && !attribute1.isMustAttribute()) {
                    return this.greaterThan();
                }
            }
            if (this.preferences == null || this.preferences.isOperationalAttributesLast()) {
                if (attribute1.isOperationalAttribute() && !attribute2.isOperationalAttribute()) {
                    return this.greaterThan();
                }
                if (attribute2.isOperationalAttribute() && !attribute1.isOperationalAttribute()) {
                    return this.lessThan();
                }
            }
        }
        return this.compare(attribute1.getDescription(), attribute2.getDescription());
    }

    private int compareValues(IValue value1, IValue value2) {
        if (value1.isEmpty() && value2.isEmpty()) {
            return this.equal();
        }
        if (value1.isEmpty() && !value2.isEmpty()) {
            return this.greaterThan();
        }
        if (!value1.isEmpty() && value2.isEmpty()) {
            return this.lessThan();
        }
        return this.compare(value1.getStringValue(), value2.getStringValue());
    }

    private int getSortOrderOrDefault() {
        if (this.preferences == null) {
            return 1;
        }
        if (this.sortOrder == 0) {
            return this.preferences.getDefaultSortOrder();
        }
        return this.sortOrder;
    }

    private int getSortByOrDefault() {
        if (this.preferences == null) {
            return 3;
        }
        if (this.sortBy == 0) {
            return this.preferences.getDefaultSortBy();
        }
        return this.sortBy;
    }

    private int lessThan() {
        return this.getSortOrderOrDefault() == 1 ? -1 : 1;
    }

    private int equal() {
        return 0;
    }

    private int greaterThan() {
        return this.getSortOrderOrDefault() == 1 ? 1 : -1;
    }

    private int compare(String s1, String s2) {
        return this.getSortOrderOrDefault() == 1 ? s1.compareToIgnoreCase(s2) : s2.compareToIgnoreCase(s1);
    }
}

