/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.IComponentTypeExtension;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;

public final class ComponentTypeExtensionManager {
    private static final ComponentTypeExtensionManager INSTANCE = new ComponentTypeExtensionManager();
    private Map<Class<? extends Implementation>, IComponentTypeExtension> _cache = new HashMap<Class<? extends Implementation>, IComponentTypeExtension>();
    private List<IComponentTypeExtension> _extensions = new ArrayList<IComponentTypeExtension>();
    private IComponentTypeExtension _defaultExtension = new DefaultComponentTypeExtension();

    public static ComponentTypeExtensionManager instance() {
        return INSTANCE;
    }

    public static Set<InterfaceControl.InterfaceType> getSupportedInterfaceTypes(Component component) {
        Implementation implementation = component.getImplementation();
        if (implementation == null) {
            return EnumSet.allOf(InterfaceControl.InterfaceType.class);
        }
        IComponentTypeExtension extension = ComponentTypeExtensionManager.instance().getExtensionFor(implementation.getClass());
        return extension == null ? Collections.emptySet() : extension.getSupportedInterfaceTypes(implementation);
    }

    private ComponentTypeExtensionManager() {
        this.loadExtensions();
    }

    public IComponentTypeExtension getExtensionFor(Class<? extends Implementation> type) {
        if (this._cache.containsKey(type)) {
            return this._cache.get(type);
        }
        for (IComponentTypeExtension extension : this._extensions) {
            if (!extension.supports(type)) continue;
            this._cache.put(type, extension);
            return extension;
        }
        this._cache.put(type, this._defaultExtension);
        return this._defaultExtension;
    }

    public Collection<IComponentTypeExtension> getExtensions() {
        return Collections.unmodifiableCollection(this._extensions);
    }

    private void loadExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.switchyard.tools.ui.editor", "editorExtension");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension pluginExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = pluginExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("componentExtension".equals(element.getName())) {
                    try {
                        this._extensions.add((IComponentTypeExtension)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static final class DefaultComponentTypeExtension
    implements IComponentTypeExtension {
        private DefaultComponentTypeExtension() {
        }

        @Override
        public ICreateFeature[] newCreateFeatures(IFeatureProvider fp) {
            return new ICreateFeature[0];
        }

        public ImageDecorator getImageDecorator(Implementation implementation) {
            return new ImageDecorator(ImageProvider.IMG_16_UNKNOWN_IMPL);
        }

        @Override
        public boolean supports(Class<? extends Implementation> type) {
            return false;
        }

        @Override
        public List<String> getRequiredCapabilities(Implementation object) {
            return Collections.emptyList();
        }

        @Override
        public Set<InterfaceControl.InterfaceType> getSupportedInterfaceTypes(Implementation implementation) {
            return Collections.emptySet();
        }

        @Override
        public String getTypeName(Implementation object) {
            return Messages.constant_unknown;
        }
    }
}

