/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.binding.sca;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.SCABinding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.jms.CamelJmsBindingType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyBooleanValidator;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;

public class BindingSCAComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private SCABinding _binding = null;
    private Text _nameText;
    private Combo _clusteredCombo;
    private Combo _preferLocalCombo;
    private ComboViewer _loadBalancingCombo;
    private Text _loadBalancingCustomClassText;
    private Button _browseLoadBalancingClassButton;
    private Text _targetServiceText;
    private Text _targetNamespaceText;
    private boolean _showConsumer;
    private IJavaProject _project;
    private WritableValue _bindingValue;

    BindingSCAComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_scaBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_scaBindingDetails;
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof SCABinding) {
            IFile file;
            this._binding = (SCABinding)impl;
            this._bindingValue.setValue((Object)this._binding);
            Resource resource = MergedModelUtil.getSwitchYard(this.getTargetObject()).eResource();
            if (resource.getURI().isPlatformResource() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resource.getURI().toPlatformString(true)))) != null) {
                this._project = JavaCore.create((IProject)file.getProject());
            }
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void setTargetObject(EObject target) {
        super.setTargetObject(target);
        if (target instanceof Service) {
            this._showConsumer = true;
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = this.getToolkit().createComposite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getConsumerTabControl(this._panel, context);
        this.bindControls(context);
    }

    private Control getConsumerTabControl(Composite tabFolder, DataBindingContext context) {
        FormToolkit toolkit = this.getToolkit();
        Composite composite = toolkit.createComposite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        if (!this._showConsumer) {
            this._targetServiceText = this.createLabelAndText(composite, Messages.label_targetService);
            this._targetNamespaceText = this.createLabelAndText(composite, Messages.label_targetNamespace);
        }
        Group clusteringGroup = new Group(composite, 0);
        clusteringGroup.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        clusteringGroup.setLayout((Layout)new GridLayout(3, false));
        clusteringGroup.setText(Messages.label_clustering);
        toolkit.adapt((Composite)clusteringGroup);
        this.getToolkit().createLabel((Composite)clusteringGroup, Messages.label_clustered);
        this._clusteredCombo = new Combo((Composite)clusteringGroup, 2052);
        this.getToolkit().adapt((Composite)this._clusteredCombo);
        this._clusteredCombo.add("true");
        this._clusteredCombo.add("false");
        this._clusteredCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addGridData((Control)this._clusteredCombo, 2, 768);
        if (!this._showConsumer) {
            this.getToolkit().createLabel((Composite)clusteringGroup, "Prefer Local");
            this._preferLocalCombo = new Combo((Composite)clusteringGroup, 2052);
            this.getToolkit().adapt((Composite)this._preferLocalCombo);
            this._preferLocalCombo.add("true");
            this._preferLocalCombo.add("false");
            this._preferLocalCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this._loadBalancingCombo = this.createLabelAndComboViewer((Composite)clusteringGroup, Messages.label_loadBalancing, true);
            this.addGridData((Control)this._loadBalancingCombo.getCombo(), 2, 768);
            this._loadBalancingCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this._loadBalancingCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            String[] authTypes = new String[]{"", "RoundRobinStrategy", "RandomStrategy", Messages.constant_customLoadBalanceStrategy};
            this._loadBalancingCombo.setInput((Object)authTypes);
            this._loadBalancingCustomClassText = this.createLabelAndText((Composite)clusteringGroup, Messages.label_customClass);
            this._loadBalancingCombo.getCombo().setEnabled(false);
            this._loadBalancingCustomClassText.setEnabled(false);
            this._browseLoadBalancingClassButton = toolkit.createButton((Composite)clusteringGroup, Messages.button_browse, 8);
            GridData btnGD = new GridData();
            this._browseLoadBalancingClassButton.setLayoutData((Object)btnGD);
            this._browseLoadBalancingClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String newClass = BindingSCAComposite.this.handleBrowse(BindingSCAComposite.this._loadBalancingCustomClassText.getText());
                    if (newClass != null) {
                        BindingSCAComposite.this.setTextValueAndNotify(BindingSCAComposite.this._loadBalancingCustomClassText, newClass, true);
                    }
                }
            });
            this._browseLoadBalancingClassButton.setEnabled(false);
        }
        return composite;
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    public void setShowConsumer(boolean showConsumer) {
        this._showConsumer = showConsumer;
    }

    private String handleBrowse(String filter) {
        IJavaSearchScope scope = null;
        scope = this._project == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this._project});
        try {
            Object[] result;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Display.getCurrent().getActiveShell(), null, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)(filter.isEmpty() ? "* " : filter));
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IType) {
                return ((IType)result[0]).getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelJmsBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("SCA binding name should not be empty.", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("SCA binding name should not be empty.", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        IObservableValue clusteredValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SwitchyardPackage.eINSTANCE.getDocumentRoot_Clustered());
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._clusteredCombo), clusteredValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyBooleanValidator("Clustered  must be a valid boolean value (true or false) or follow the pattern for escaped properties (i.e. '${propName}').")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        if (!this._showConsumer) {
            this.bindReferenceControls(context, domain, realm, clusteredValue);
        }
    }

    private void bindReferenceControls(DataBindingContext context, EditingDomain domain, Realm realm, final IObservableValue clusteredValue) {
        WritableValue loadBalanceValue = new WritableValue(realm, null, String.class);
        WritableValue loadBalanceCustomValue = new WritableValue(realm, null, String.class);
        IObservableValue preferLocalValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SwitchyardPackage.eINSTANCE.getDocumentRoot_PreferLocal());
        clusteredValue.addChangeListener(new IChangeListener((IObservableValue)loadBalanceValue, preferLocalValue){
            private final /* synthetic */ IObservableValue val$loadBalanceValue;
            private final /* synthetic */ IObservableValue val$preferLocalValue;
            {
                this.val$loadBalanceValue = iObservableValue2;
                this.val$preferLocalValue = iObservableValue3;
            }

            public void handleChange(ChangeEvent event) {
                Object something = clusteredValue.getValue();
                boolean isClustered = false;
                if (something instanceof Boolean && ((Boolean)something).booleanValue()) {
                    isClustered = true;
                } else if (something instanceof String) {
                    String clusteredvalue = (String)clusteredValue.getValue();
                    isClustered = clusteredvalue != null && !clusteredvalue.trim().isEmpty();
                }
                BindingSCAComposite.this._loadBalancingCombo.getControl().setEnabled(isClustered);
                BindingSCAComposite.this._preferLocalCombo.setEnabled(isClustered);
                String value = (String)this.val$loadBalanceValue.getValue();
                if (!isClustered && value != null) {
                    this.val$loadBalanceValue.setValue(null);
                    this.val$preferLocalValue.setValue((Object)"true");
                }
                Object plValue = this.val$preferLocalValue.getValue();
                if (isClustered && plValue == null) {
                    this.val$preferLocalValue.setValue((Object)"true");
                }
            }
        });
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._preferLocalCombo), preferLocalValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyBooleanValidator("Prefer Local must be a valid boolean value (true or false) or follow the pattern for escaped properties (i.e. '${propName}').")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        loadBalanceValue.addChangeListener(new IChangeListener((IObservableValue)loadBalanceValue, (IObservableValue)loadBalanceCustomValue){
            private final /* synthetic */ IObservableValue val$loadBalanceValue;
            private final /* synthetic */ IObservableValue val$loadBalanceCustomValue;
            {
                this.val$loadBalanceValue = iObservableValue;
                this.val$loadBalanceCustomValue = iObservableValue2;
            }

            public void handleChange(ChangeEvent event) {
                String value = (String)this.val$loadBalanceValue.getValue();
                boolean isCustom = false;
                if (value != null) {
                    isCustom = value.equals(Messages.constant_customLoadBalanceStrategy);
                }
                BindingSCAComposite.this._loadBalancingCustomClassText.setEnabled(isCustom);
                BindingSCAComposite.this._browseLoadBalancingClassButton.setEnabled(isCustom);
                if (!isCustom) {
                    this.val$loadBalanceCustomValue.setValue(null);
                }
            }
        });
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._targetServiceText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SwitchyardPackage.eINSTANCE.getDocumentRoot_Target()), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._targetNamespaceText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SwitchyardPackage.eINSTANCE.getDocumentRoot_TargetNamespace()), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._loadBalancingCombo), (IObservableValue)loadBalanceValue, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._loadBalancingCustomClassText, (int)24), (IObservableValue)loadBalanceCustomValue, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        ComputedValue computedLoadBalanceValue = new ComputedValue((IObservableValue)loadBalanceValue, (IObservableValue)loadBalanceCustomValue){
            private final /* synthetic */ IObservableValue val$loadBalanceValue;
            private final /* synthetic */ IObservableValue val$loadBalanceCustomValue;
            {
                this.val$loadBalanceValue = iObservableValue;
                this.val$loadBalanceCustomValue = iObservableValue2;
            }

            protected Object calculate() {
                String loadBalance = (String)this.val$loadBalanceValue.getValue();
                String customLoadBalance = (String)this.val$loadBalanceCustomValue.getValue();
                if (loadBalance != null && loadBalance.equalsIgnoreCase(Messages.constant_customLoadBalanceStrategy) && customLoadBalance != null) {
                    return customLoadBalance;
                }
                if (loadBalance != null && !loadBalance.equalsIgnoreCase(Messages.constant_customLoadBalanceStrategy)) {
                    this.val$loadBalanceCustomValue.setValue(null);
                    return loadBalance;
                }
                return null;
            }

            protected void doSetValue(Object value) {
                String strValue = (String)value;
                if (strValue != null && !strValue.equalsIgnoreCase("RoundRobinStrategy") && !strValue.equalsIgnoreCase("RandomStrategy")) {
                    this.val$loadBalanceValue.setValue((Object)Messages.constant_customLoadBalanceStrategy);
                    this.val$loadBalanceCustomValue.setValue((Object)strValue);
                } else if (strValue != null) {
                    this.val$loadBalanceValue.setValue((Object)strValue);
                    this.val$loadBalanceCustomValue.setValue(null);
                    BindingSCAComposite.this.setTextValueAndNotify(BindingSCAComposite.this._loadBalancingCustomClassText, "", false);
                } else {
                    this.val$loadBalanceValue.setValue(null);
                    this.val$loadBalanceCustomValue.setValue(null);
                }
                this.getValue();
            }
        };
        binding = context.bindValue((IObservableValue)computedLoadBalanceValue, ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SwitchyardPackage.eINSTANCE.getDocumentRoot_LoadBalance()));
    }
}

