/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.java;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.switchyard.tools.models.switchyard1_0.camel.CamelFactory;
import org.switchyard.tools.models.switchyard1_0.camel.CamelImplementationType;
import org.switchyard.tools.models.switchyard1_0.camel.JavaDSLType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.editor.components.camel.java.NewCamelRouteClassWizardPage;
import org.switchyard.tools.ui.editor.diagram.component.IComponentWizard;

public class NewCamelJavaRouteComponentWizard
extends NewClassCreationWizard
implements IComponentWizard {
    private Contract _serviceInterface;
    private Component _component;

    public NewCamelJavaRouteComponentWizard() {
        this(true);
    }

    public NewCamelJavaRouteComponentWizard(boolean openEditorOnFinish) {
        super((NewClassWizardPage)new NewCamelRouteClassWizardPage(), openEditorOnFinish);
    }

    public NewCamelJavaRouteComponentWizard(NewCamelRouteClassWizardPage page, boolean openEditorOnFinish) {
        super((NewClassWizardPage)page, openEditorOnFinish);
    }

    @Override
    public Component getCreatedObject() {
        return this._component;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
    }

    @Override
    public void init(Composite container) {
        if (container == null || this.getSelection() != null && !this.getSelection().isEmpty()) {
            return;
        }
        IProject project = PlatformResourceAdapterFactory.getContainingProject((Object)container);
        if (project == null) {
            return;
        }
        IJavaElement element = JavaUtil.getInitialPackageForProject((IJavaProject)JavaCore.create((IProject)project));
        StructuredSelection selection = element == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)element);
        this.init(this.getWorkbench() == null ? PlatformUI.getWorkbench() : this.getWorkbench(), (IStructuredSelection)selection);
    }

    public void forceServiceInterfaceType(Contract serviceInterface) {
        this._serviceInterface = serviceInterface;
    }

    public void addPages() {
        super.addPages();
        NewCamelRouteClassWizardPage page = this.getCamelRouteClassPage();
        page.init(this.getSelection());
        page.forceServiceInterfaceType(this._serviceInterface);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        super.finishPage(monitor);
        NewCamelRouteClassWizardPage page = this.getCamelRouteClassPage();
        IType newType = page.getCreatedType();
        if (newType == null) {
            return;
        }
        JavaDSLType javaType = CamelFactory.eINSTANCE.createJavaDSLType();
        javaType.setClass(newType.getFullyQualifiedName());
        CamelImplementationType implementation = CamelFactory.eINSTANCE.createCamelImplementationType();
        implementation.setJava(javaType);
        this._component = ScaFactory.eINSTANCE.createComponent();
        this._component.setName(newType.getElementName());
        this._component.setImplementation((Implementation)implementation);
        ComponentService service = page.getService();
        if (service != null) {
            this._component.getService().add((Object)service);
        }
    }

    private NewCamelRouteClassWizardPage getCamelRouteClassPage() {
        return (NewCamelRouteClassWizardPage)this.getPages()[0];
    }
}

