/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.switchyard.tools.models.switchyard1_0.camel.CamelFactory;
import org.switchyard.tools.models.switchyard1_0.camel.CamelImplementationType;
import org.switchyard.tools.models.switchyard1_0.camel.XMLDSLType;
import org.switchyard.tools.models.switchyard1_0.spring.DocumentRoot;
import org.switchyard.tools.models.switchyard1_0.spring.FromDefinition;
import org.switchyard.tools.models.switchyard1_0.spring.LogDefinition;
import org.switchyard.tools.models.switchyard1_0.spring.RouteDefinition;
import org.switchyard.tools.models.switchyard1_0.spring.RoutesDefinition;
import org.switchyard.tools.models.switchyard1_0.spring.SpringFactory;
import org.switchyard.tools.models.switchyard1_0.spring.util.SpringResourceFactoryImpl;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.BaseNewServiceFileWizard;

public class NewCamelXMLRouteCompenentWizard
extends BaseNewServiceFileWizard {
    public NewCamelXMLRouteCompenentWizard(boolean openAfterCreate) {
        super(openAfterCreate, "xml");
        this.setWindowTitle(Messages.title_newCamelXmlRouteFile);
    }

    @Override
    public void addPages() {
        super.addPages();
        WizardNewFileCreationPage page = this.getFileCreationPage();
        page.setTitle(Messages.title_routeFile);
        page.setDescription(Messages.description_routeFile);
        if (this.getService() == null) {
            page.setFileName("route.xml");
        } else {
            page.setFileName(this.getService().getName() + "Route.xml");
        }
    }

    @Override
    protected Implementation createImplementation() {
        XMLDSLType xmlType = CamelFactory.eINSTANCE.createXMLDSLType();
        xmlType.setPath(this.getCreatedFilePath());
        CamelImplementationType implementation = CamelFactory.eINSTANCE.createCamelImplementationType();
        implementation.setXml(xmlType);
        return implementation;
    }

    @Override
    protected List<ComponentReference> createReferences() {
        return Collections.emptyList();
    }

    private String getNewRouteStubText(String serviceName) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<beans xmlns=\"http://www.springframework.org/schema/beans\"\n");
        sb.append("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd        http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd\">\n");
        sb.append("   <camelContext id=\"camelContext1\" xmlns=\"http://camel.apache.org/schema/spring\">\n");
        sb.append("      <route id=\"_route1\">\n");
        sb.append("         <from id=\"_from1\" uri=\"switchyard://" + serviceName + "\"/>\n");
        sb.append("         <log id=\"_log1\" message=\"" + serviceName + " - message received: ${body}\"/>\n");
        sb.append("      </route>\n");
        sb.append("   </camelContext>\n");
        sb.append("</beans>\n");
        return sb.toString();
    }

    private InputStream getOldRouteStubText() {
        ByteArrayOutputStream baos = null;
        try {
            DocumentRoot doc = SpringFactory.eINSTANCE.createDocumentRoot();
            RoutesDefinition routes = SpringFactory.eINSTANCE.createRoutesDefinition();
            RouteDefinition route = SpringFactory.eINSTANCE.createRouteDefinition();
            route.setId("_route1");
            FromDefinition from = SpringFactory.eINSTANCE.createFromDefinition();
            from.setId("_from1");
            LogDefinition log = SpringFactory.eINSTANCE.createLogDefinition();
            log.setId("_log1");
            String serviceName = this.getService().getName();
            from.setUri("switchyard://" + serviceName);
            log.setMessage(serviceName + " - message received: ${body}");
            doc.setRoutes(routes);
            doc.setRoute(route);
            route.getFrom().add((Object)from);
            route.getLog().add((Object)log);
            routes.getRoute().add((Object)route);
            doc.getXMLNSPrefixMap().put((Object)"", (Object)"http://camel.apache.org/schema/spring");
            Resource routeResource = new SpringResourceFactoryImpl().createResource(URI.createGenericURI((String)"temp", (String)"temp", null));
            routeResource.getContents().add((Object)doc);
            baos = new ByteArrayOutputStream();
            routeResource.save((OutputStream)baos, null);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            Activator.logError(e2);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    protected InputStream getInitialContents() {
        String serviceName;
        boolean useNewCamelRoute = true;
        IProject project = this.getJavaProject().getProject();
        String version = SwitchYardModelUtils.getSwitchYardProjectRuntimeVersion((IProject)project);
        if (version.startsWith("2.0") || version.startsWith("1")) {
            useNewCamelRoute = false;
        }
        if ((serviceName = this.getService().getName()) != null) {
            if (useNewCamelRoute) {
                return new ByteArrayInputStream(this.getNewRouteStubText(serviceName).getBytes(StandardCharsets.UTF_8));
            }
            return this.getOldRouteStubText();
        }
        return null;
    }
}

