/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.http;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.http.BasicAuthenticationType;
import org.switchyard.tools.models.switchyard1_0.http.HTTPBindingType;
import org.switchyard.tools.models.switchyard1_0.http.HttpFactory;
import org.switchyard.tools.models.switchyard1_0.http.HttpPackage;
import org.switchyard.tools.models.switchyard1_0.http.NTLMAuthenticationType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyIntegerValidator;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;

public class HttpAuthenticationComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private HTTPBindingType _binding = null;
    private ComboViewer _authTypeCombo;
    private Text _authUserText;
    private Text _authPasswordText;
    private Text _authRealmText;
    private Text _authHostText;
    private Text _authPortText;
    private Text _authDomainText;
    private WritableValue _bindingValue;

    HttpAuthenticationComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_httpAuthenticationDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_httpAuthenticationDetals;
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getAuthenticationControl(this._panel);
        this.bindControls(context);
    }

    private Control getAuthenticationControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._authTypeCombo = this.createLabelAndComboViewer(composite, Messages.label_authenticationType, true);
        this._authTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._authTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        String[] authTypes = new String[]{"Basic", "NTLM"};
        this._authTypeCombo.setInput((Object)authTypes);
        this._authUserText = this.createLabelAndText(composite, Messages.label_user);
        this._authPasswordText = this.createLabelAndText(composite, Messages.label_password);
        this._authRealmText = this.createLabelAndText(composite, Messages.label_realm);
        this._authHostText = this.createLabelAndText(composite, Messages.label_host);
        this._authPortText = this.createLabelAndText(composite, Messages.label_port);
        this._authDomainText = this.createLabelAndText(composite, Messages.label_domain);
        return composite;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    public void setBinding(Binding switchYardBindingType) {
        super.setBinding(switchYardBindingType);
        if (switchYardBindingType instanceof HTTPBindingType) {
            this.setTargetObject(switchYardBindingType.eContainer());
            this._binding = (HTTPBindingType)switchYardBindingType;
            this._bindingValue.setValue((Object)this._binding);
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._authTypeCombo.getCombo().getDisplay());
        this._bindingValue = new WritableValue(realm, null, HTTPBindingType.class);
        WritableValue authType = new WritableValue(realm, null, String.class);
        WritableValue basicAuthUser = new WritableValue(realm, null, String.class);
        WritableValue basicAuthPwd = new WritableValue(realm, null, String.class);
        WritableValue basicAuthRealm = new WritableValue(realm, null, String.class);
        WritableValue basicAuthHost = new WritableValue(realm, null, String.class);
        WritableValue basicAuthPort = new WritableValue(realm, null, String.class);
        WritableValue ntlmAuthDomain = new WritableValue(realm, null, String.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._authTypeCombo.getCombo()), (IObservableValue)authType);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._authUserText, (int)24), (IObservableValue)basicAuthUser, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._authPasswordText, (int)24), (IObservableValue)basicAuthPwd, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._authRealmText, (int)24), (IObservableValue)basicAuthRealm, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._authHostText, (int)24), (IObservableValue)basicAuthHost, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._authPortText, (int)24), (IObservableValue)basicAuthPort, new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidator("Port must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._authDomainText, (int)24), (IObservableValue)ntlmAuthDomain, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        AuthComputedValue computed = new AuthComputedValue((IObservableValue)authType, (IObservableValue)basicAuthUser, (IObservableValue)basicAuthPwd, (IObservableValue)basicAuthRealm, (IObservableValue)basicAuthHost, (IObservableValue)basicAuthPort, (IObservableValue)ntlmAuthDomain);
        final IObservableValue ntlmValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)HttpPackage.Literals.HTTP_BINDING_TYPE__NTLM);
        final IObservableValue basicValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)HttpPackage.Literals.HTTP_BINDING_TYPE__BASIC);
        final org.eclipse.core.databinding.Binding ntlmBinding = context.bindValue((IObservableValue)computed, ntlmValue, (UpdateValueStrategy)new EMFUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        final org.eclipse.core.databinding.Binding basicBinding = context.bindValue((IObservableValue)computed, basicValue, (UpdateValueStrategy)new EMFUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST), (UpdateValueStrategy)new EMFUpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        final IValueChangeListener changeListener = new IValueChangeListener((IObservableValue)computed){
            private boolean _updating = false;
            private final /* synthetic */ IObservableValue val$computed;
            {
                this.val$computed = iObservableValue3;
            }

            public void handleValueChange(ValueChangeEvent event) {
                if (!this._updating) {
                    this._updating = true;
                    if (event.getSource() == ntlmValue || event.getSource() == basicValue) {
                        if (ntlmValue.getValue() == null) {
                            basicBinding.updateModelToTarget();
                        } else {
                            ntlmBinding.updateModelToTarget();
                        }
                    } else if (this.val$computed.getValue() instanceof NTLMAuthenticationType) {
                        ntlmBinding.updateTargetToModel();
                        basicValue.setValue(null);
                    } else {
                        basicBinding.updateTargetToModel();
                        ntlmValue.setValue(null);
                    }
                    this._updating = false;
                }
            }
        };
        IDisposeListener disposeListener = new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
                ((IObservableValue)event.getSource()).removeValueChangeListener(changeListener);
            }
        };
        computed.addValueChangeListener(changeListener);
        ntlmValue.addValueChangeListener(changeListener);
        basicValue.addValueChangeListener(changeListener);
        computed.addDisposeListener(disposeListener);
        ntlmValue.addDisposeListener(disposeListener);
        basicValue.addDisposeListener(disposeListener);
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }

    class AuthComputedValue
    extends ComputedValue {
        private IObservableValue _authType = null;
        private IObservableValue _basicAuthUser = null;
        private IObservableValue _basicAuthPwd = null;
        private IObservableValue _basicAuthRealm = null;
        private IObservableValue _basicAuthHost = null;
        private IObservableValue _basicAuthPort = null;
        private IObservableValue _ntlmAuthDomain = null;

        public AuthComputedValue(IObservableValue authType, IObservableValue user, IObservableValue pwd, IObservableValue authrealm, IObservableValue host, IObservableValue port, IObservableValue domain) {
            this._authType = authType;
            this._basicAuthUser = user;
            this._basicAuthPwd = pwd;
            this._basicAuthRealm = authrealm;
            this._basicAuthHost = host;
            this._basicAuthPort = port;
            this._ntlmAuthDomain = domain;
        }

        protected Object calculate() {
            String authTypeStr = (String)this._authType.getValue();
            String user = (String)this._basicAuthUser.getValue();
            String pwd = (String)this._basicAuthPwd.getValue();
            String realm = (String)this._basicAuthRealm.getValue();
            String host = (String)this._basicAuthHost.getValue();
            String port = (String)this._basicAuthPort.getValue();
            String domain = (String)this._ntlmAuthDomain.getValue();
            boolean isBasic = false;
            boolean isNtlm = false;
            if (authTypeStr == null) {
                this.updateControls(isBasic, isNtlm);
                return null;
            }
            if (authTypeStr.equalsIgnoreCase("Basic")) {
                isBasic = true;
                if (user != null || pwd != null || realm != null || host != null || port != null) {
                    BasicAuthenticationType basicAuth = HttpFactory.eINSTANCE.createBasicAuthenticationType();
                    basicAuth.setUser(user);
                    basicAuth.setPassword(pwd);
                    basicAuth.setRealm(realm);
                    basicAuth.setHost(host);
                    basicAuth.setPort((Object)port);
                    this.updateControls(isBasic, isNtlm);
                    return basicAuth;
                }
                this.updateControls(isBasic, isNtlm);
                return null;
            }
            if (authTypeStr.equalsIgnoreCase("NTLM")) {
                isNtlm = true;
                if (user != null || pwd != null || realm != null || host != null || port != null || domain != null) {
                    NTLMAuthenticationType ntlmAuth = HttpFactory.eINSTANCE.createNTLMAuthenticationType();
                    ntlmAuth.setUser(user);
                    ntlmAuth.setPassword(pwd);
                    ntlmAuth.setRealm(realm);
                    ntlmAuth.setHost(host);
                    ntlmAuth.setPort((Object)port);
                    ntlmAuth.setDomain(domain);
                    this.updateControls(isBasic, isNtlm);
                    return ntlmAuth;
                }
                this.updateControls(isBasic, isNtlm);
                return null;
            }
            return null;
        }

        protected void doSetValue(Object value) {
            if (value instanceof NTLMAuthenticationType) {
                this._authType.setValue((Object)"NTLM");
                NTLMAuthenticationType ntlmAuth = (NTLMAuthenticationType)value;
                this._basicAuthHost.setValue((Object)ntlmAuth.getHost());
                this._basicAuthPwd.setValue((Object)ntlmAuth.getPassword());
                this._basicAuthPort.setValue(ntlmAuth.getPort());
                this._basicAuthUser.setValue((Object)ntlmAuth.getUser());
                this._basicAuthRealm.setValue((Object)ntlmAuth.getRealm());
                this._ntlmAuthDomain.setValue((Object)ntlmAuth.getDomain());
            } else if (value instanceof BasicAuthenticationType) {
                BasicAuthenticationType basicAuth = (BasicAuthenticationType)value;
                this._authType.setValue((Object)"Basic");
                this._basicAuthHost.setValue((Object)basicAuth.getHost());
                this._basicAuthPwd.setValue((Object)basicAuth.getPassword());
                this._basicAuthPort.setValue(basicAuth.getPort());
                this._basicAuthUser.setValue((Object)basicAuth.getUser());
                this._basicAuthRealm.setValue((Object)basicAuth.getRealm());
                this._ntlmAuthDomain.setValue(null);
            } else {
                this._authType.setValue(null);
                this._basicAuthHost.setValue(null);
                this._basicAuthPwd.setValue(null);
                this._basicAuthPort.setValue(null);
                this._basicAuthUser.setValue(null);
                this._basicAuthRealm.setValue(null);
                this._ntlmAuthDomain.setValue(null);
            }
            this.getValue();
        }

        private void updateControls(boolean isBasic, boolean isNtlm) {
            HttpAuthenticationComposite.this._authDomainText.setEnabled(isNtlm);
            HttpAuthenticationComposite.this._authHostText.setEnabled(isBasic || isNtlm);
            HttpAuthenticationComposite.this._authPasswordText.setEnabled(isBasic || isNtlm);
            HttpAuthenticationComposite.this._authPortText.setEnabled(isBasic || isNtlm);
            HttpAuthenticationComposite.this._authRealmText.setEnabled(isBasic || isNtlm);
            HttpAuthenticationComposite.this._authUserText.setEnabled(isBasic || isNtlm);
        }
    }
}

