/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.components.jca.IJCAResourceAdapterExtension;
import org.switchyard.tools.ui.editor.components.jca.JCAGenericResourceAdapterExtension;

public final class IJCAResourceAdapterExtensionManager {
    private static final IJCAResourceAdapterExtensionManager INSTANCE = new IJCAResourceAdapterExtensionManager();
    private Map<Class<? extends Binding>, IJCAResourceAdapterExtension> _cache = new HashMap<Class<? extends Binding>, IJCAResourceAdapterExtension>();
    private List<IJCAResourceAdapterExtension> _extensions = new ArrayList<IJCAResourceAdapterExtension>();
    private IJCAResourceAdapterExtension _defaultExtension = new JCAGenericResourceAdapterExtension();

    public static IJCAResourceAdapterExtensionManager instance() {
        return INSTANCE;
    }

    private IJCAResourceAdapterExtensionManager() {
        this.loadExtensions();
    }

    public IJCAResourceAdapterExtension getExtensionFor(Class<? extends Binding> type) {
        if (this._cache.containsKey(type)) {
            return this._cache.get(type);
        }
        this._cache.put(type, this._defaultExtension);
        return this._defaultExtension;
    }

    public Collection<IJCAResourceAdapterExtension> getExtensions() {
        return Collections.unmodifiableCollection(this._extensions);
    }

    private void loadExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.switchyard.tools.ui.editor", "jcaResourceAdapterExtension");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension pluginExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = pluginExtension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    this._extensions.add((IJCAResourceAdapterExtension)element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
                ++n4;
            }
            ++n2;
        }
    }
}

